/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.dirty;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.bos.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.bos.ctrl.ext.util.VariantUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ExtReportingDirtyManagerLoader {
    public void load(ExtReportingDirtyManager manager) throws ExtReportingBizException {
        String lastValue = (String)manager._book.getUserObjectValue("EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY");
        Book book = manager._book;
        IReportingModel model = book.getReportingModel();
        if (StringUtil.isEmptyString((String)lastValue) || model == null) {
            return;
        }
        IUpdateConstraint[] contraints = model.getUpdateConstraintList();
        if (contraints == null || contraints.length == 0) {
            return;
        }
        HashMap<String, IUpdateConstraint> constraintMap = new HashMap<String, IUpdateConstraint>();
        for (int i = 0; i < contraints.length; ++i) {
            constraintMap.put(contraints[i].getUserDefineName(), contraints[i]);
        }
        try {
            Element root = new SAXBuilder().build((InputStream)new ByteArrayInputStream(lastValue.getBytes("UTF-8"))).getRootElement();
            List recodes = root.getChild("Recodes").getChildren("Recode");
            manager._records = new ArrayList();
            for (Element recode : recodes) {
                String className = recode.getAttributeValue("className");
                String constraintName = recode.getAttributeValue("constraintName");
                String identityKey = recode.getAttributeValue("identityKey");
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                List cells = recode.getChildren("Cell");
                int index = 0;
                for (Element cell : cells) {
                    cellList.add(book.getSheetByName(cell.getAttributeValue("sheetName")).getCell(Integer.parseInt(cell.getAttributeValue("rowIndex")), Integer.parseInt(cell.getAttributeValue("colIndex")), true));
                }
                List valueElementList = recode.getChildren("CommitValue");
                Variant[] values = new Variant[valueElementList.size()];
                int[] jdbcTypes = new int[valueElementList.size()];
                for (Element commitValue : valueElementList) {
                    String type = commitValue.getAttributeValue("valueType");
                    jdbcTypes[index] = Integer.parseInt(commitValue.getAttributeValue("jdbcType"));
                    values[index++] = VariantUtil.parsePlainString2Variant(commitValue.getAttributeValue("value"), Byte.valueOf(type));
                }
                IUpdateConstraint constraint = (IUpdateConstraint)constraintMap.get(constraintName);
                Class<?> clazz = Class.forName(className);
                ExecutionPlan plan = (ExecutionPlan)clazz.getConstructor(String.class, Cell[].class, IUpdateConstraint.class).newInstance(identityKey, cellList.toArray(new Cell[0]), constraint);
                plan.setLoaded(true);
                plan.setValues(values);
                plan.setJdbcTypes(jdbcTypes);
                plan.setSQL(recode.getAttributeValue("sqlContent"));
                manager._records.add(plan);
            }
            manager._commitResults = new ArrayList();
            List results = root.getChild("Results").getChildren("Result");
            for (Element result : results) {
                String className = result.getAttributeValue("className");
                Class<?> clazz = Class.forName(className);
                CommitResult cr = (CommitResult)clazz.getConstructor(String.class, String.class, String.class).newInstance(result.getAttributeValue("identityKey"), result.getText(), result.getAttributeValue("level"));
                manager._commitResults.add(cr);
            }
        }
        catch (Throwable cause) {
            throw new ExtReportingBizException("error ocurred during loading dirty manager", cause);
        }
    }
}

