/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilderDesc;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.AbstractTableStyleScheme;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyle;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import java.awt.Color;

public abstract class AbstractTableBuilder
implements DesignBuilder,
DesignBuilderDesc {
    protected StyleAttributes titleSa;
    protected StyleAttributes detailSa;
    protected StyleAttributes totalSa;
    protected StyleAttributes segmentSa;
    protected StyleAttributes subTotalSa;
    protected StyleAttributes whiteSa;
    protected StyleAttributes leftSa;
    protected StyleAttributes pointSa;
    protected StyleAttributes boldSa;
    protected StyleAttributes wrapTextSa;
    protected StyleAttributes borderSa;
    protected StyleAttributes borderSaTop;
    protected StyleAttributes borderSaBottom;
    protected Sheet sheet;
    protected MobileReportWizardModel model;
    protected TableModel tableModel;
    protected int fieldSize;
    protected TableStyle tableStyle;
    protected AbstractTableStyleScheme tableStyleScheme;
    private KDExt ext;
    protected SpreadContext sc;
    protected boolean isShowSubTotal;
    protected boolean isShowTotal;
    protected boolean isFirst = true;
    protected static final String subTotalStr = "\u5c0f\u8ba1";
    protected static final String totalStr = "\u603b\u8ba1";
    protected static final int NUMBERS = 0;
    protected static final int CHARACTERS = 1;
    protected int startRow = 0;
    private int tableWidth = 306;

    public AbstractTableBuilder(KDExt ext, MobileReportWizardModel model) {
        this.ext = ext;
        this.model = model;
    }

    private void init(KDExt ext, MobileReportWizardModel model) {
        this.sc = MiscUtil.getActiveSpreadContext(ext);
        this.sheet = this.sc.getBook().getActiveSheet();
        this.tableModel = model.getTableModel();
        if (model.getReportType() != ReportType.CHART) {
            this.fieldSize = this.tableModel.getFieldList().size();
        }
        if (this.tableModel != null) {
            this.tableStyle = this.tableModel.getTableStyle();
            this.tableStyleScheme = this.tableStyle.getTableStyleScheme();
            this.isShowSubTotal = this.tableModel.isShowSubTotal();
            this.isShowTotal = this.tableModel.isShowTotal();
            this.initTableStyleSchemeSA(this.tableStyleScheme);
        }
    }

    private void initSA() {
        this.whiteSa = Styles.getEmptySA();
        this.whiteSa.setFontSize(10);
        this.whiteSa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.whiteSa.setBackground(Color.WHITE);
        this.leftSa = Styles.getEmptySA();
        this.leftSa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.pointSa = Styles.getEmptySA();
        this.pointSa.setNumberFormat("#,##0.00;-#,##0.00");
        this.boldSa = Styles.getEmptySA();
        this.boldSa.setBold(true);
        this.wrapTextSa = Styles.getEmptySA();
        this.wrapTextSa.setWrapText(true);
        this.borderSa = Styles.getEmptySA();
        this.borderSa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        this.borderSa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        this.borderSa.setBorderColor(Styles.Position.TOP, new Color(221, 221, 223));
        this.borderSa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        this.borderSa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        this.borderSa.setBorderColor(Styles.Position.BOTTOM, new Color(221, 221, 223));
        this.borderSa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        this.borderSa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        this.borderSa.setBorderColor(Styles.Position.LEFT, new Color(221, 221, 223));
        this.borderSa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        this.borderSa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        this.borderSa.setBorderColor(Styles.Position.RIGHT, new Color(221, 221, 223));
        this.borderSaTop = Styles.getEmptySA();
        this.borderSaTop.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        this.borderSaTop.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        this.borderSaTop.setBorderColor(Styles.Position.TOP, new Color(221, 221, 223));
        this.borderSaBottom = Styles.getEmptySA();
        this.borderSaBottom.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        this.borderSaBottom.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        this.borderSaBottom.setBorderColor(Styles.Position.BOTTOM, new Color(221, 221, 223));
    }

    private void initTableStyleSchemeSA(AbstractTableStyleScheme tableStyleScheme) {
        this.titleSa = tableStyleScheme.getTitleSa();
        this.detailSa = tableStyleScheme.getDetailSa();
        this.totalSa = tableStyleScheme.getTotalSa();
        this.segmentSa = tableStyleScheme.getSegmentSa();
        this.subTotalSa = tableStyleScheme.getSubTotalSa();
    }

    protected void buildTotal(int row, int index, int parentRow) {
        String total;
        if (this.tableModel.getTotalList() != null && (total = this.tableModel.getTotalList().get(index).toString()) != "") {
            String ref = this.sheet.getCell(parentRow, index, true).getName(false, false);
            this.sheet.getCell(row, index, true).setFormula(this.buildFormula(ref, this.getFunctionName(total)));
        }
    }

    protected void buildSpecialSA(int minRow, int maxRow, boolean isColThree) {
        if (isColThree) {
            for (int i = 0; i < this.fieldSize; ++i) {
                int dataType = this.tableModel.getMapDataType().get(this.tableModel.getFieldList().get(i)) == null ? 1 : this.tableModel.getMapDataType().get(this.tableModel.getFieldList().get(i));
                if (this.dataTypeTransform(dataType) == 1) {
                    this.sheet.getRange(minRow, i, maxRow, i).setStyle(this.leftSa, Styles.getEmptySA());
                    continue;
                }
                if (dataType != 4 && dataType != 5 && dataType != 11) continue;
                this.sheet.getRange(minRow, i, maxRow, i).setStyle(this.pointSa, Styles.getEmptySA());
            }
            if (this.fieldSize == 2) {
                this.sc.getRangeManager().getColRange(0, 1).setColumnWidth(153);
            } else if (this.fieldSize == 3) {
                this.sc.getRangeManager().getColRange(0, 2).setColumnWidth(102);
            } else {
                this.sc.getRangeManager().getColRange(0, this.fieldSize).setColumnWidth(79);
                this.tableWidth = 79 * this.fieldSize;
            }
        } else {
            for (int i = 1; i < this.fieldSize + 1; ++i) {
                int dataType = this.tableModel.getMapDataType().get(this.tableModel.getFieldList().get(i - 1)) == null ? 1 : this.tableModel.getMapDataType().get(this.tableModel.getFieldList().get(i - 1));
                if (this.dataTypeTransform(dataType) == 1) {
                    this.sheet.getRange(minRow, i, maxRow, i).setStyle(this.leftSa, Styles.getEmptySA());
                    continue;
                }
                if (dataType != 4 && dataType != 5 && dataType != 11) continue;
                this.sheet.getRange(minRow, i, maxRow, i).setStyle(this.pointSa, Styles.getEmptySA());
            }
            if (this.fieldSize == 2) {
                this.sc.getRangeManager().getColRange(1, 2).setColumnWidth(143);
            } else if (this.fieldSize == 3) {
                this.sc.getRangeManager().getColRange(1, 3).setColumnWidth(95);
            } else {
                this.sc.getRangeManager().getColRange(1, this.fieldSize).setColumnWidth(79);
                this.tableWidth = 79 * this.fieldSize + 20;
            }
        }
    }

    protected void setFormulaTotal(int row, int col, String text) {
        if (this.sheet.getCell(row, col, false) != null && this.sheet.getCell(row, col, false).getFormula() == "") {
            this.sheet.getCell(row, col, false).setFormula(text);
        }
    }

    private int dataTypeTransform(int dataType) {
        if (dataType == 6 || dataType == 7 || dataType == 8 || dataType == 9 || dataType == 10) {
            return 1;
        }
        return 0;
    }

    protected String getFunctionName(String colName) {
        String str = colName.split("\uff1a")[0];
        String funcName = null;
        if ("\u8ba1\u6570".equals(str)) {
            funcName = "COUNTA";
        } else if ("\u6c42\u548c".equals(str)) {
            funcName = "SUM";
        }
        return funcName;
    }

    protected String buildFormula(String colName, String functionName) {
        StringBuffer sb = new StringBuffer();
        sb.append("=");
        sb.append(functionName);
        sb.append("(EXS(");
        sb.append(colName);
        sb.append("))");
        return sb.toString();
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    @Override
    public void build() {
        this.initSA();
        this.init(this.ext, this.model);
    }
}

