/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.pic;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ImageUtils {
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String bmp = "bmp";
    public static final String png = "png";

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.ENGLISH);
        }
        return ext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = ImageUtils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        int type = 1;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean isTranslucent = false;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkURL(URL url, long maxSize) {
        block10: {
            block12: {
                if (!url.getProtocol().equals("file")) break block12;
                File f = new File(url.toString().substring(6));
                if (!f.exists() || f.length() <= 0L || f.length() > maxSize) {
                    return false;
                }
                break block10;
            }
            if (url.getProtocol().equals("http")) {
                try {
                    if (!ImageUtils.verifyImageExist2(url)) {
                        return false;
                    }
                    break block10;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (url.getProtocol().equals("rtp")) {
                InputStream in;
                block11: {
                    boolean bl;
                    in = null;
                    try {
                        URLConnection connnection = url.openConnection();
                        in = connnection.getInputStream();
                        long length = connnection.getContentLength();
                        if (in != null && length > 0L && length <= maxSize) break block11;
                        bl = false;
                    }
                    catch (IOException e) {
                        boolean bl2;
                        try {
                            bl2 = false;
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{in});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{in});
                        return bl2;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    return bl;
                }
                CloseUtil.close((Closeable[])new Closeable[]{in});
            }
        }
        return true;
    }

    public static boolean checkURL(URL url) {
        return ImageUtils.checkURL(url, Integer.MAX_VALUE);
    }

    public static boolean verifyImageExist2(URL imageUrl) throws IOException, Exception {
        return ImageIO.read(imageUrl) != null;
    }

    public static boolean verifyImageExist(URL imageUrl) throws IOException, Exception {
        String uri = imageUrl.toString();
        return ImageUtils.isHTTPOK(uri);
    }

    private static boolean isHTTPOK(String uri) throws IOException {
        HttpClient httpclient = new HttpClient();
        GetMethod get = new GetMethod(uri);
        httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
        try {
            int status = httpclient.executeMethod((HttpMethod)get);
            if (status == 200) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            get.releaseConnection();
        }
    }

    public static String retrieveImageType(byte[] b) {
        String imageType = null;
        boolean flag = false;
        if (b.length > 8) {
            boolean bl = flag = b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
            if (flag) {
                imageType = png;
            }
        }
        if (!flag && b.length > 2) {
            int byte1 = b[0] & 0xFF;
            int byte2 = b[1] & 0xFF;
            if (byte1 == 255 && byte2 == 216) {
                flag = true;
                imageType = jpeg;
            }
        }
        if (!flag && b.length > 6) {
            boolean bl = flag = b[0] == 71 && b[1] == 73 && b[2] == 70 && b[3] == 56 && (b[4] == 55 || b[4] == 57) && b[5] == 97;
            if (flag) {
                imageType = gif;
            }
        }
        if (!flag && b.length > 2) {
            boolean bl = flag = b[0] == 66 && b[1] == 77;
            if (flag) {
                imageType = bmp;
            }
        }
        if (!flag && b.length > 3) {
            boolean bl = flag = b[0] == 0 && b[1] == 0 && ((b[2] & 0x8F) != 0 || (b[2] & 0x7F) != 0);
            if (flag) {
                imageType = "wbmp";
            }
        }
        return imageType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImageByteContent(String str) throws IOException {
        block5: {
            if (StringUtil.isEmptyString((String)str)) break block5;
            String filePath = str;
            if (str.startsWith("file://")) {
                filePath = str.substring(7);
            }
            FileInputStream in = null;
            byte[] content = null;
            try {
                in = new FileInputStream(new File(filePath));
                content = StreamUtil.readInputStream((InputStream)in);
            }
            catch (FileNotFoundException e) {
                int n;
                try {
                    n = 0;
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{in});
                return n;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
            return content.length / 1024;
        }
        return 0;
    }

    public static BufferedImage getScaledBufferedImage(BufferedImage buffImg, int width, int height) {
        BufferedImage buff = null;
        width = 208;
        height = 38;
        buff = new BufferedImage(width, height, 1);
        Graphics g = buff.getGraphics();
        g.drawImage(buffImg.getScaledInstance(width, height, 4), 0, 0, width, height, null);
        g.dispose();
        return buff;
    }

    public static String getFormatName(String fileName) {
        if (StringUtil.isEmptyString((String)fileName)) {
            return null;
        }
        if ((fileName = fileName.toLowerCase(Locale.ENGLISH)).endsWith(png)) {
            return png;
        }
        if (fileName.endsWith(jpeg)) {
            return jpeg;
        }
        if (fileName.endsWith(gif)) {
            return gif;
        }
        if (fileName.endsWith(bmp)) {
            return bmp;
        }
        if (fileName.endsWith("wbmp")) {
            return "wbmp";
        }
        return null;
    }
}

