/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.hyperlink;

import com.kingdee.bos.ctrl.common.hyperlink.LinkToPanel;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BookLinkToPanel
extends LinkToPanel {
    private KDLabel _cellRefLb;
    private KDTextField _cellRefField;
    private KDLabel _posRefLb;
    private KDScrollPane _posRefPan;
    private KDTree _posRefTree;
    private DefaultKingdeeTreeNode _sheetNode;
    private DefaultKingdeeTreeNode _namesNode;
    private SpreadContext _context;

    public BookLinkToPanel(SpreadContext context) {
        this._context = context;
        this._cellRefLb = new KDLabel();
        this._cellRefLb.setText(MultiLanguageKeys.getLocalText("KEY_HYPERLINK_CELLREF", "\u8bf7\u952e\u5165\u5355\u5143\u683c\u5f15\u7528"));
        this._cellRefField = new KDTextField();
        this._posRefLb = new KDLabel();
        this._posRefLb.setText(MultiLanguageKeys.getLocalText("KEY_HYPERLINK_BOOKPOSITION", "\u5728\u8fd9\u7bc7\u6587\u6863\u4e2d\u9009\u62e9\u4f4d\u7f6e"));
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"KDTree");
        this._sheetNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("KEY_SHEET"));
        this._namesNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("KEY_NAME"));
        root.add((MutableTreeNode)this._sheetNode);
        root.add((MutableTreeNode)this._namesNode);
        this._posRefTree = new KDTree((ITreeNode)root, false);
        this._posRefTree.getSelectionModel().setSelectionMode(1);
        this._posRefTree.setRootVisible(false);
        this._posRefPan = new KDScrollPane((Component)this._posRefTree);
        this._posRefPan.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(null);
        this.add((Component)this._cellRefLb);
        this.add((Component)this._cellRefField);
        this.add((Component)this._posRefLb);
        this.add((Component)this._posRefPan);
        this._cellRefLb.setBounds(5, 5, 510, 20);
        this._cellRefField.setBounds(5, 30, 510, 20);
        this._posRefLb.setBounds(5, 55, 510, 20);
        this._posRefPan.setBounds(5, 80, 510, 125);
        this._posRefTree.addTreeSelectionListener((TreeSelectionListener)new TreeHandler());
    }

    public String getLinkTo() {
        TreePath path = this._posRefTree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        TreeNode parent = node.getParent();
        if (parent == this._sheetNode) {
            String str = this._cellRefField.getText();
            if (StringUtil.isEmptyString((String)str)) {
                return node.getText();
            }
            Sheet sheet = this._context.getBook().getSheet(node.getText());
            return sheet.getSyntaxName() + "!" + str;
        }
        if (parent == this._namesNode) {
            return node.getText();
        }
        return null;
    }

    public void updatePanel(String linkTo) {
        int activeIndex = this.updateByBook();
        if (StringUtil.isEmptyString((String)linkTo)) {
            if (activeIndex == -1) {
                this._posRefTree.setSelectionNode((DefaultKingdeeTreeNode)this._sheetNode.getFirstChild());
            } else {
                this._posRefTree.setSelectionNode((DefaultKingdeeTreeNode)this._sheetNode.getChildAt(activeIndex));
            }
            this._cellRefField.setText("A1");
        } else {
            int count = this._namesNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._namesNode.getChildAt(i);
                if (!node.getText().equals(linkTo)) continue;
                this._posRefTree.setSelectionNode(node);
                return;
            }
            int index = linkTo.indexOf(33);
            if (index > 0) {
                this._cellRefField.setText(linkTo.substring(index + 1));
                linkTo = linkTo.substring(0, index);
            } else {
                this._cellRefField.setText("A1");
            }
            count = this._sheetNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._sheetNode.getChildAt(i);
                if (!node.getText().equals(linkTo)) continue;
                this._posRefTree.setSelectionNode(node);
                return;
            }
            this._posRefTree.setSelectionNode((DefaultKingdeeTreeNode)this._sheetNode.getFirstChild());
            this._cellRefField.setText("A1");
        }
    }

    private int updateByBook() {
        DefaultKingdeeTreeNode node;
        NamedObjectNode nonode;
        int i;
        Book book = this._context.getBook();
        if (book == null) {
            return -1;
        }
        this._posRefTree.removeAllChildrenFromParent((MutableTreeNode)this._sheetNode);
        this._posRefTree.removeAllChildrenFromParent((MutableTreeNode)this._namesNode);
        int count = book.getSheetCount();
        for (int i2 = 0; i2 < count; ++i2) {
            DefaultKingdeeTreeNode node2 = new DefaultKingdeeTreeNode((Object)book.getSheet(i2).getSheetName());
            this._posRefTree.addNodeInto((MutableTreeNode)node2, (MutableTreeNode)this._sheetNode);
        }
        SortedNamedObjectNodeArray names = book.getNames();
        count = names.size();
        for (i = 0; i < count; ++i) {
            nonode = names.getObjectNode(i);
            if (!nonode.isVisible() || nonode.isUndefined()) continue;
            node = new DefaultKingdeeTreeNode((Object)nonode.getFullName());
            this._posRefTree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)this._namesNode);
        }
        names = book.getActiveSheet().getNames();
        count = names.size();
        for (i = 0; i < count; ++i) {
            nonode = names.getObjectNode(i);
            if (!nonode.isVisible() || nonode.isUndefined()) continue;
            node = new DefaultKingdeeTreeNode((Object)nonode.getFullName());
            this._posRefTree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)this._namesNode);
        }
        this._posRefTree.expandAllNodes(true, (TreeNode)this._namesNode);
        return book.getActiveSheetIndex();
    }

    private class TreeHandler
    implements TreeSelectionListener {
        private TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                TreePath path = BookLinkToPanel.this._posRefTree.getSelectionPath();
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                BookLinkToPanel.this._cellRefField.setEnabled(node != BookLinkToPanel.this._namesNode && node.getParent() != BookLinkToPanel.this._namesNode);
            }
        }
    }
}

