/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class WizzardChart
extends KDDialog
implements ISpreadWizzard {
    private static final ChartType[] supports = new ChartType[]{ChartType.CT_PIE, ChartType.CT_PIEEXPLODED, ChartType.CT_PIE3D, ChartType.CT_COLUMNCLUSTERED, ChartType.CT_COLUMNSTACKED, ChartType.CT_COLUMNCLUSTERED3D, ChartType.CT_COLUMNSTACKED3D, ChartType.CT_BARCLUSTERED, ChartType.CT_BARSTACKED, ChartType.CT_BARCLUSTERED3D, ChartType.CT_BARSTACKED3D, ChartType.CT_LINE, ChartType.CT_LINESTACKED, ChartType.CT_LINEMARKERS, ChartType.CT_LINEMARKERSSTACKED, ChartType.CT_XYSCATTER, ChartType.CT_XYSCATTERLINES, ChartType.CT_XYSCATTERLINESNOMARKERS, ChartType.CT_AREA, ChartType.CT_AREASTACKED};
    private KDComboBox _cbChartType;
    private KDTextField _tfChartTitle;
    private KDTextField _tfCategoryAxisTitle;
    private KDTextField _tfValAxisTitle;
    private RangeSelector _rsRange;
    private KDTextField _tfGroupKey;
    private KDFormattedTextField _ftfAngle;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private SpreadContext _context;
    private Chart _chart;

    public WizzardChart(Dialog parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public WizzardChart(Frame parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
    }

    private void init() {
        this.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setSize(new Dimension(430, 200));
        this.setSize(440, 220);
        this._cbChartType = new KDComboBox();
        for (int i = 0; i < supports.length; ++i) {
            this._cbChartType.addItem((Object)supports[i]);
        }
        KDLabelContainer lc = new KDLabelContainer("\u56fe\u8868\u7c7b\u578b:", (JComponent)this._cbChartType);
        cp.add((Component)lc);
        lc.setBounds(10, 10, 400, 20);
        this._tfChartTitle = new KDTextField();
        KDLabelContainer lc1 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartTitle") + ":", (JComponent)this._tfChartTitle);
        lc1.setBoundLabelAlignment(8);
        lc1.setPreferredSize(new Dimension(125, 42));
        this._tfCategoryAxisTitle = new KDTextField();
        KDLabelContainer lc2 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartCatAxisTitle") + ":", (JComponent)this._tfCategoryAxisTitle);
        lc2.setBoundLabelAlignment(8);
        lc2.setPreferredSize(new Dimension(125, 42));
        this._tfValAxisTitle = new KDTextField();
        KDLabelContainer lc3 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartValAxisTitle") + ":", (JComponent)this._tfValAxisTitle);
        lc3.setBoundLabelAlignment(8);
        lc3.setPreferredSize(new Dimension(125, 42));
        this._tfGroupKey = new KDTextField();
        KDLabelContainer lc4 = new KDLabelContainer(MultiLanguageKeys.getLocalText("KEY_ChartGroupKeys") + ":", (JComponent)this._tfGroupKey);
        lc4.setBoundLabelAlignment(7);
        lc4.setPreferredSize(new Dimension(325, 21));
        this._ftfAngle = new KDFormattedTextField();
        this._ftfAngle.setColumns(4);
        this._ftfAngle.setDataType(0);
        this._ftfAngle.setSupportedEmpty(false);
        this._ftfAngle.setNumberValue((Number)new Integer(0));
        KDLabelContainer lc5 = new KDLabelContainer("\u503e\u89d2:", (JComponent)this._ftfAngle);
        lc5.setBoundLabelAlignment(7);
        lc5.setPreferredSize(new Dimension(60, 21));
        KDPanel p = new KDPanel();
        p.setLayout((LayoutManager)new FlowLayout(0));
        p.add((Component)lc1);
        p.add((Component)lc2);
        p.add((Component)lc3);
        p.add((Component)lc4);
        p.add((Component)lc5);
        cp.add((Component)p);
        p.setBounds(10, 40, 400, 75);
        this._rsRange = this._context.getFacadeManager().createRangeSelector(MultiLanguageKeys.getLocalText("KEY_ChartChooseData"));
        this._rsRange.setWithSheetName(true);
        this._rsRange.setWithOpreatorEqual(true);
        cp.add(this._rsRange);
        this._rsRange.setBounds(10, 125, 400, 20);
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnOk.addActionListener((ActionListener)new FinishAction());
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardChart.this.closeDialog();
            }
        });
        KDPanel pnlCtrl = new KDPanel();
        pnlCtrl.setLayout((LayoutManager)new FlowLayout());
        pnlCtrl.add((Component)this._btnOk);
        pnlCtrl.add((Component)this._btnCancel);
        cp.add((Component)pnlCtrl);
        pnlCtrl.setBounds(10, 155, 400, 30);
    }

    private void initDatas(Chart chart) {
        if (chart == null) {
            this._cbChartType.setSelectedItem((Object)supports[3]);
            this._tfChartTitle.setText("");
            this._tfCategoryAxisTitle.setText("");
            this._tfValAxisTitle.setText("");
            String srg = '=' + this._context.getBook().getActiveSheet().getSyntaxName() + '!' + SheetBaseMath.getBlocksName(this._context.getBook().getActiveSheet().getSheetOption().getSelection().toSortedBlocks(), this._context.getBook().getDeps().isA1Style(), false);
            this._rsRange.setText(srg);
        } else {
            ChartModel model = chart.getModel();
            this._cbChartType.setSelectedItem((Object)model.getChartType());
            ChartDataNode dn = model.getDataNode();
            this._tfChartTitle.setText(dn.getChartTitleFormula());
            this._tfCategoryAxisTitle.setText(dn.getCategoryAxisTitleFormula());
            this._tfValAxisTitle.setText(dn.getValueAxisTitleFormula());
            this._rsRange.setText(dn.getDataFormula());
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            EmbedObject gr = gl.getActiveSelectedEmbed();
            if (gr instanceof Chart) {
                this._chart = (Chart)gr;
                this.initDatas(this._chart);
                return true;
            }
            return false;
        }
        this._chart = null;
        this.initDatas(this._chart);
        return true;
    }

    private class FinishAction
    extends AbstractAction {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Book book = WizzardChart.this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            ChartType type = (ChartType)WizzardChart.this._cbChartType.getSelectedItem();
            ObjectArray rg = null;
            String refersTo = WizzardChart.this._rsRange.getText();
            if (!StringUtil.isEmptyString((String)refersTo)) {
                rg = WizzardChart.this._context.getRangeManager().findRangeInBook(refersTo, false);
            }
            if (rg == null) {
                WizzardChart.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                WizzardChart.this._rsRange.requestFocus();
                return;
            }
            int allCells = 0;
            for (int i = rg.size() - 1; i >= 0; --i) {
                CellBlock cb = ((SortedCellBlockArray)rg).getBlock(i);
                allCells += cb.getWidth() * cb.getHeight();
            }
            if (allCells > 1000) {
                WizzardChart.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_TooLongRange"), 2);
                return;
            }
            ChartDataNode dn = new ChartDataNode(sheet);
            dn.setDataFormula(WizzardChart.this._rsRange.getText());
            String title = WizzardChart.this._tfChartTitle.getText();
            String categoryTitle = WizzardChart.this._tfCategoryAxisTitle.getText();
            String valueTitle = WizzardChart.this._tfValAxisTitle.getText();
            String groupKeys = WizzardChart.this._tfGroupKey.getText();
            int angle = WizzardChart.this._ftfAngle.getNumberValue().intValue();
            ChartModel model = WizzardChart.this._chart.getModel();
            model.setDataNode(dn);
            model.setChartType(type);
            dn.setChartTitleFormula(title);
            dn.setCategoryAxisTitleFormula(categoryTitle);
            dn.setValueAxisTitleFormula(valueTitle);
            dn.setGroupFormula(groupKeys);
            dn.setAngle(angle);
            WizzardChart.this._context.repaint();
            WizzardChart.this.closeDialog();
        }
    }
}

