/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state.mouse;

import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.DefaultMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.IMouseState;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.OutlineGroupColHeaderMouseHandle;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.event.MouseEvent;

public class OutlineGroupColHeaderMouseController
extends DefaultMouseController {
    private SpreadContext _context;
    protected IMouseState ch = new OutlineGroupColHeaderMouseHandle();

    public OutlineGroupColHeaderMouseController(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        return this.ch;
    }

    public static void switchTheHandlerWhenLeft(Sheet sheet, int colId, SortedAttributeSpanArray sasa, int level, boolean isOff, int step) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        SortedCellBlockArray blocks = new SortedCellBlockArray();
        int i = colId + step;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
            } else {
                int sPos;
                int m = as.getStart() - step;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getEnd() == colId) {
                            blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
                            break;
                        }
                        if (OutlineGroupColHeaderMouseController.isCollapseWhenHandlerLeft(lookupAs, sasa, colId)) break;
                        blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
                        break;
                    }
                    m -= step;
                }
            }
            i = as.getEnd();
            ++i;
        }
        if (!blocks.isEmpty()) {
            sheet.getRange(blocks).setColumnHidden(!isOff);
        }
        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerLeft(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int colId) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getStart() - 1;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getEnd() > colId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            --m;
        }
        return false;
    }

    public static void switchTheHandlerWhenRight(Sheet sheet, int colId, SortedAttributeSpanArray sasa, int level, boolean isOff) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        SortedCellBlockArray blocks = new SortedCellBlockArray();
        int i = colId - 1;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
            } else {
                int sPos;
                int m = as.getEnd() + 1;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getStart() == colId) {
                            blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
                            break;
                        }
                        if (OutlineGroupColHeaderMouseController.isCollapseWhenHandlerRight(lookupAs, sasa, colId)) break;
                        blocks.insert(CellBlock.getCellBlock(0, as.getStart(), 1048575, as.getEnd()));
                        break;
                    }
                    ++m;
                }
            }
            i = as.getStart();
            --i;
        }
        if (!blocks.isEmpty()) {
            sheet.getRange(blocks).setColumnHidden(!isOff);
        }
        sheet.getColRange(colId, colId).setColumnOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerRight(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int colId) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getEnd() + 1;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getStart() < colId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            ++m;
        }
        return false;
    }
}

