/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm.explorer;

import com.kingdee.bos.ctrl.kds.io.htm.explorer.HtmlSheetModel;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.MeasureHelper;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.Rectangle;
import java.util.Iterator;

public class PageContext {
    private int _startRow = 0;
    private int _endRow;
    private int _rowSum;
    private int _pageIndex;
    private int _pageCount;
    private boolean _isPaging;
    private HtmlSheetModel _hsModel;
    private MeasureHelper _rowHelper;
    private MeasureHelper _colHelper;
    private int _headRows = 0;
    private int _screenCount;
    private int _screenHeight;
    private int _screenRowCount;
    private boolean _hasScreenCount;

    public void init(Sheet sheet, HtmlSheetModel hsModel, int startRow, int count) {
        this._hsModel = hsModel;
        this._startRow = startRow;
        this._headRows = startRow;
        this._isPaging = !this._hsModel.isTree();
        this._rowSum = count;
        this.setRowSum(count);
        this.updateEndRow();
        this._rowHelper = new MeasureHelper(true, sheet.getDefRowHeight());
        this._colHelper = new MeasureHelper(false, sheet.getDefColWidth());
    }

    public void setRowSum(int count) {
        if (!this._isPaging) {
            this._pageIndex = 0;
            this._pageCount = 1;
        } else {
            int outputRows = this._rowSum * this._pageIndex;
            this._startRow = this._pageIndex == 0 ? this._headRows : outputRows;
            this._pageIndex = (int)Math.ceil(outputRows / count);
            this._pageCount = (int)Math.ceil(this._hsModel.getRowCount() / count) + 1;
        }
        this._rowSum = count;
        this.updateEndRow();
    }

    public int getRowSumPerPage() {
        return this._rowSum;
    }

    public int getTheoreticalRemainRows() {
        int result = this._rowSum + this._startRow - this._endRow + 1;
        return result;
    }

    public int getActualColCount(int start, int count) {
        int[] columns = this._hsModel.getVisibleColumns();
        int toReturn = 0;
        int end = start + count - 1;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] >= start && columns[i] <= end) {
                ++toReturn;
                continue;
            }
            if (columns[i] > end) break;
        }
        return toReturn;
    }

    public int getPageCount() {
        return this._pageCount;
    }

    public int getPageIndex() {
        return this._pageIndex;
    }

    public void setPageIndex(int index) {
        int num;
        int n = num = this._pageIndex < index ? 1 : -1;
        while (this._pageIndex != index) {
            if (num == 1) {
                this.nextPage();
            } else {
                this.lastPage();
            }
            this._pageIndex += num;
        }
    }

    public int getStartRow() {
        return this._startRow;
    }

    public int getEndRow() {
        return this._endRow;
    }

    public boolean nextPage() {
        double rowSpan = this._endRow - this._startRow;
        if (rowSpan < (double)this._rowSum && this._pageIndex < this._pageCount - 1) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        if (this._isPaging && this._startRow < this._hsModel.getMaxRowIndex()) {
            this._startRow = this._hsModel.searchStartRow(this._endRow++, true);
            this.updateEndRow();
            return true;
        }
        return false;
    }

    public boolean hasNextPage() {
        return this._isPaging && this._endRow < this._hsModel.getMaxRowIndex();
    }

    public boolean lastPage() {
        if (this._isPaging && this._startRow > 0) {
            int forecast = this._startRow > this._rowSum ? this._startRow - this._rowSum : this._headRows;
            this._startRow = this._hsModel.searchStartRow(forecast, false);
            this.updateEndRow();
            return true;
        }
        return false;
    }

    public Iterator headerIterator(int end) {
        return this.iterator(0, end);
    }

    public Iterator iterator() {
        return this.iterator(-1, -1);
    }

    private Iterator iterator(final int start, final int end) {
        final boolean hasContent = this._rowSum > 0;
        return new Iterator(){
            int count;
            int index;
            boolean _hasNext;
            boolean _isHeader;
            {
                this.count = PageContext.this._rowSum;
                this.index = start == -1 ? PageContext.this._startRow : start;
                this._hasNext = hasContent;
                this._isHeader = start != -1;
            }

            @Override
            public boolean hasNext() {
                return this._hasNext;
            }

            public Object next() {
                Integer toReturn = new Integer(this.index);
                this.index = PageContext.this._hsModel.searchNextRow(this.index);
                --this.count;
                if (!this._isHeader) {
                    PageContext.this._endRow++;
                }
                if (this.index >= 0) {
                    boolean bl = PageContext.this._isPaging ? this.count > 0 : (this._hasNext = true);
                    if (end > -1 && this._hasNext) {
                        this._hasNext = this.index < end;
                    }
                } else {
                    this._hasNext = false;
                }
                return toReturn;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Unsupport action");
            }
        };
    }

    private void updateEndRow() {
        if (this._isPaging) {
            this.updateEndRow(this._startRow);
        }
    }

    public void updateEndRow(int index) {
        this._endRow = index;
    }

    public int getRowHeight(int pos, Cell cell, SortedAttributeSpanArray array) {
        int length = this._rowHelper.getLength(pos, array, cell);
        if (this._hasScreenCount && this._screenRowCount > 0) {
            this._screenHeight += length;
            --this._screenRowCount;
        }
        return length;
    }

    public Rectangle getEmbedObjectRect(int row, int col, Rectangle rect) {
        int x = this.getAttentionX(col);
        int y = this.getAttentionY(row);
        int width = x + rect.width;
        int height = y + rect.height;
        this._colHelper.refreshMaxLength(width);
        this._rowHelper.refreshMaxLength(height);
        rect.setBounds(x, y, rect.width, rect.height);
        return rect;
    }

    public int getColWidth(int pos, Cell cell, SortedAttributeSpanArray array) {
        int length = this._colHelper.getLength(pos, array, cell);
        return length;
    }

    public int getTotalWidth() {
        return this._colHelper.getTotalLength();
    }

    public int getTotalHeight() {
        int height = this._hasScreenCount ? this._screenHeight : this._rowHelper.getTotalLength();
        return height;
    }

    public void addAttentionX(int position) {
        this._colHelper.addAttention(position);
    }

    public void addAttentionY(int position) {
        this._rowHelper.addAttention(position);
    }

    public int getAttentionX(int position) {
        return this._colHelper.getAttensionValue(position);
    }

    public int getAttentionY(int position) {
        return this._rowHelper.getAttensionValue(position);
    }

    public boolean isPaging() {
        return this._isPaging;
    }

    public void clearMeasureHelper() {
        this._rowHelper.clear();
        this._colHelper.clear();
    }

    public void setScreenRowCount(int rows) {
        this._screenCount = rows;
        this._screenRowCount = Math.min(this._screenCount, this._rowSum);
        this._screenHeight = 0;
    }

    public int getScreenHeight() {
        return this._screenHeight + 20;
    }

    public int getScreenCount() {
        return this._screenCount;
    }

    public boolean isScreenCountEnable() {
        return this._hasScreenCount;
    }

    public void setScreenCountEnable(boolean isCount) {
        this._hasScreenCount = isCount;
    }
}

