/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.kml;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kds.io.kml.AbsElement;
import com.kingdee.bos.ctrl.kds.io.kml.BasicElement;
import com.kingdee.bos.ctrl.kds.io.kml.CellElement;
import com.kingdee.bos.ctrl.kds.io.kml.KingdeeDefinedElement;
import com.kingdee.bos.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RowElement
extends BasicElement {
    private AbsElement _ce;
    private AbsElement _kde;

    RowElement() {
    }

    private void updateRowSpans(String uri, String localName, String qName, Attributes attributes, KmlToBook.DataCache dataCache, KmlToBook ktb) {
        int rowIndex;
        Sheet sheet = dataCache.getCurSheet();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        String strRowIndex = attributes.getValue(KmlUtil.getNSName("Index", NS_SHEET));
        if (strRowIndex == null) {
            rowIndex = 0;
            String defaultRowIndex = dataCache.getCurRowIndex();
            if (defaultRowIndex != null) {
                rowIndex = Integer.parseInt(defaultRowIndex) + 1;
            }
        } else {
            rowIndex = Integer.parseInt(strRowIndex) - 1;
        }
        int span = 0;
        String strSpan = attributes.getValue(KmlUtil.getNSName("Span", NS_SHEET));
        if (strSpan != null) {
            span = Integer.parseInt(strSpan);
        }
        if (span == 0) {
            dataCache.setCurUOParent(sheet.getRow(rowIndex, true));
        }
        dataCache.setCurRowIndex(String.valueOf(rowIndex + span));
        dataCache.setDefaultCellIndex(0);
        ShareStyleAttributes ssa = null;
        if (ktb.touchModeFlag(FLAG_STYLE)) {
            String styleID = attributes.getValue(KmlUtil.getNSName("StyleID", NS_SHEET));
            ssa = (ShareStyleAttributes)dataCache.getStyles().get(styleID);
        }
        Integer height = null;
        String strHeight = attributes.getValue(KmlUtil.getNSName("Height", NS_SHEET));
        if (strHeight != null) {
            height = new Integer(KmlUtil.toScreenValue(Float.parseFloat(strHeight)));
        }
        Boolean visible = null;
        String strHidden = attributes.getValue(KmlUtil.getNSName("Hidden", NS_SHEET));
        if (strHidden != null) {
            visible = Integer.parseInt(strHidden) > 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (ssa != null || height != null || visible != null) {
            rowSpans.setSpanAttribute(new Span(rowIndex, rowIndex + span), ssa, height, visible, null, null, false);
        }
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        if ("Cell".equals(KmlUtil.getLocalName(qName))) {
            if (this._ce == null) {
                this._ce = new CellElement();
            }
            return this._ce;
        }
        if ("KingdeeDefined".equals(KmlUtil.getLocalName(qName))) {
            if (this._kde == null) {
                this._kde = new KingdeeDefinedElement();
            }
            return this._kde;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Row".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            this.updateRowSpans(uri, localName, qName, attributes, dataCache, ktb);
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }
}

