/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.kds.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.kds.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.kds.model.struct.IMethodBatchQuery;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class FunctionManager
implements Cloneable {
    private HashMap _funcs;
    private final HashMap _errProviders = new HashMap();
    private int _batchProviders = 0;
    private IErrorResultProvider _errorResultProvider;

    public FunctionManager() {
        this._funcs = new HashMap(255);
    }

    public int getBatchProvidersCount() {
        return this._batchProviders;
    }

    public boolean addFunctionProvider(Object provider, boolean local) {
        if (provider == null) {
            return false;
        }
        boolean batch = provider instanceof IMethodBatchQuery || provider instanceof com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
        String instName = provider.getClass().getName();
        boolean changed = false;
        Method[] methods = provider.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            ReflectUtil.makeAccessible((Method)m);
            ExprMethod newEM = new ExprMethod(instName, provider, m, batch, local);
            int paramCount = newEM.getParamCount();
            changed |= this.putMethod(m.getName().toUpperCase(), paramCount, newEM);
        }
        if (batch && changed) {
            ++this._batchProviders;
        }
        return true;
    }

    private boolean putMethod(String upperFuncName, int paramCount, ExprMethod newEM) {
        Object obj = this._funcs.get(upperFuncName);
        if (obj == null) {
            ExprMethod[] a = new ExprMethod[paramCount + 1];
            a[paramCount] = newEM;
            this._funcs.put(upperFuncName, a);
        } else {
            boolean oldIsInner;
            ExprMethod oldEM;
            Object[] a = (ExprMethod[])obj;
            if (a.length < paramCount + 1) {
                Object[] aNew = new ExprMethod[paramCount + 1];
                KDToolkit.arraycopy((Object[])a, (int)0, (Object[])aNew, (int)0, (int)a.length);
                a = aNew;
                this._funcs.put(upperFuncName, a);
            }
            if ((oldEM = a[paramCount]) != null && ((oldIsInner = IInnerFuncProvider.class.isAssignableFrom(oldEM.getMethod().getDeclaringClass())) || oldEM.getMethod().getDeclaringClass() == newEM.getMethod().getDeclaringClass() && oldEM.isVarietyParams())) {
                return false;
            }
            a[paramCount] = newEM;
        }
        return true;
    }

    public Object clone() {
        FunctionManager fm = null;
        try {
            fm = (FunctionManager)super.clone();
            HashMap<String, Object[]> newMap = fm._funcs = new HashMap<String, Object[]>(this._funcs.size());
            for (Map.Entry e : this._funcs.entrySet()) {
                String methodName = (String)e.getKey();
                Object[] a = (ExprMethod[])e.getValue();
                Object[] aNew = new ExprMethod[a.length];
                KDToolkit.arraycopy((Object[])a, (int)0, (Object[])aNew, (int)0, (int)a.length);
                newMap.put(methodName, aNew);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return fm;
    }

    public boolean removeFunctionProvider(Class provider) {
        if (provider == null) {
            return false;
        }
        boolean bRet = false;
        Method[] methods = provider.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ExprMethod em;
            Method m = methods[i];
            String upperFuncName = m.getName().toUpperCase();
            Object obj = this._funcs.get(upperFuncName);
            if (obj == null) continue;
            ExprMethod[] a = (ExprMethod[])obj;
            int paramCount = m.getParameterTypes().length;
            if (paramCount >= a.length || (em = a[paramCount]) == null || !em.getMethod().equals(m)) continue;
            a[paramCount] = null;
            boolean bRemove = true;
            for (int k = 0; k < a.length; ++k) {
                if (a[k] == null) continue;
                bRemove = false;
                break;
            }
            if (bRemove) {
                this._funcs.remove(upperFuncName);
            }
            bRet = true;
        }
        return bRet;
    }

    public void removeAllFunctionProvider() {
        this._funcs.clear();
    }

    public ExprMethod getExprMethod(ExprMethod[] funcList, int paramCount) {
        ExprMethod em = null;
        if (paramCount < funcList.length) {
            em = funcList[paramCount];
        }
        if (em == null && funcList.length >= 2 && (em = funcList[1]) != null && !em.isVarietyParams()) {
            em = null;
        }
        return em;
    }

    public ExprMethod getExprMethod(String methodName, int paramCount) {
        ExprMethod[] funcList = (ExprMethod[])this._funcs.get(methodName.toUpperCase());
        return funcList != null ? this.getExprMethod(funcList, paramCount) : null;
    }

    public ExprMethod[] getFuncList(String methodName) {
        return (ExprMethod[])this._funcs.get(methodName.toUpperCase());
    }

    public boolean isNeedExpParam(ExprMethod[] funcList) {
        if (funcList != null) {
            for (int i = 0; i < funcList.length; ++i) {
                ExprMethod m = funcList[i];
                if (m == null || !m.isNeedExpParam()) continue;
                return true;
            }
        }
        return false;
    }

    public Object setErrorProvider(Class exception, IErrorProvider ep) {
        return this._errProviders.put(exception, ep);
    }

    public IErrorProvider getErrorProvider(Class exception) {
        Object obj = this._errProviders.get(exception);
        while (obj == null && (exception = exception.getSuperclass()) != Exception.class && exception != Object.class) {
            obj = this._errProviders.get(exception);
        }
        return (IErrorProvider)obj;
    }

    public void setErrorResultProvider(IErrorResultProvider pvd) {
        this._errorResultProvider = pvd;
    }

    public IErrorResultProvider getErrorResultProvider() {
        return this._errorResultProvider;
    }
}

