/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.kds.model.struct.HiLight;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.StyledDocument;

class HilightCaretListener
implements CaretListener {
    private HiLight _ht;
    private CaretListener _listener;
    private Span _span;

    public HilightCaretListener(HiLight ht) {
        this._ht = ht;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int caret;
        Span span;
        JTextPane pane = (JTextPane)e.getSource();
        StyledDocument doc = pane.getStyledDocument();
        if (this._listener == null) {
            this._listener = this._ht.getCaretListener();
        }
        if ((span = this._ht.getCaretParentheses(caret = e.getDot())) != null) {
            pane.removeCaretListener(this._listener);
            if (!span.equals(this._span)) {
                if (this._span != null) {
                    this.setParentheses(doc, this._span, false);
                }
                this._span = span;
                this.setParentheses(doc, this._span, true);
            }
            pane.addCaretListener(this._listener);
        } else if (this._span != null) {
            pane.removeCaretListener(this._listener);
            this.setParentheses(doc, this._span, false);
            this._span = null;
            pane.addCaretListener(this._listener);
        }
    }

    private void setParentheses(StyledDocument doc, Span span, boolean bold) {
        int index = span.getStart();
        Span pos = this._ht.getCodePos(index);
        doc.setCharacterAttributes(pos.getStart(), 1, doc.getStyle(HiLight.getStyle(this._ht.getStyleIndex(index), bold)), true);
        index = span.getEnd();
        pos = this._ht.getCodePos(index);
        doc.setCharacterAttributes(pos.getStart(), 1, doc.getStyle(HiLight.getStyle(this._ht.getStyleIndex(index), bold)), true);
    }
}

