/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.ISelectMode;
import com.kingdee.bos.ctrl.kds.model.struct.ISheet;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Position;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;
import java.util.ArrayList;
import java.util.Iterator;

public final class Selection
implements ISelectMode {
    public static final int ROW_SELECT = 1;
    public static final int COLUMN_SELECT = 2;
    public static final int PART_SELECT = 3;
    public static final int NO_SELECT = 4;
    private SortedCellBlockArray _invalidBlocks = new SortedCellBlockArray();
    private final CellBlock bufBlock = CellBlock.getCellBlock(0, 0, 0, 0);
    private final CellBlock bufBlock2 = CellBlock.getCellBlock(0, 0, 0, 0);
    private Sheet _sheet;
    private ArrayList _blocks;
    private ActivePosition _pos;
    private int _selectMode;

    public Selection(Sheet sheet) {
        this._sheet = sheet;
        this._blocks = new ArrayList();
        this.reset(CellBlock.getCellBlock(0, 0, 0, 0), true, false);
    }

    public void copyFrom(Selection sel) {
        this._pos.copyFrom(sel._pos);
        this._blocks = (ArrayList)sel._blocks.clone();
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    public void setSelectMode(int mode) {
        this._selectMode = mode;
    }

    public int getSelectMode() {
        return this._selectMode;
    }

    public void clear() {
        this._pos = null;
        this._blocks.clear();
    }

    public void setData(ArrayList blocks, int avIndex, int avRow, int avCol) {
        boolean needCalcAv = blocks.size() >= avIndex || !((CellBlock)blocks.get(avIndex)).contains(avRow, avCol);
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            if (!needCalcAv || !((CellBlock)blocks.get(avIndex)).contains(avRow, avCol)) continue;
            avIndex = i;
            break;
        }
        this._blocks = blocks;
        CellBlock avBlock = (CellBlock)this._blocks.get(avIndex);
        if (!avBlock.contains(avRow, avCol)) {
            avRow = avBlock.getRow();
            avCol = avBlock.getCol();
        }
        this.setActivePosition(avRow, avCol, avIndex, false);
    }

    public boolean changeSelection(CellBlock block, int changeMode) {
        return this.changeSelection(block, changeMode, true);
    }

    public boolean changeSelection(CellBlock block, int changeMode, boolean calcMerger) {
        return this.changeSelectionImpl(block, changeMode, calcMerger, true);
    }

    public void moveActiveCell(boolean bAscend, boolean bUpright) {
        if (SheetBaseMath.isHideRow(this._sheet, this.getActiveRow()) || SheetBaseMath.isHideCol(this._sheet, this.getActiveCol())) {
            return;
        }
        if (bUpright && bAscend) {
            this.activeMoveDown();
        } else if (bUpright && !bAscend) {
            this.activeMoveUp();
        } else if (bAscend) {
            this.activeMoveRight();
        } else {
            this.activeMoveLeft();
        }
    }

    public SelectIterator getSelectIterator() {
        return new SelectIterator();
    }

    public ActivePosition getActivePosition() {
        if (this._pos == null) {
            this._pos = new ActivePosition();
        }
        return this._pos;
    }

    public void setActiveCell(int row, int col) {
        this.getActivePosition().setRowCol(row, col);
    }

    public CellBlock getBlock(int index) {
        return (CellBlock)this._blocks.get(index);
    }

    public SortedSpanArray toRowSpans() {
        SortedSpanArray rowSpans = new SortedSpanArray();
        SelectIterator it = this.getSelectIterator();
        while (it.hasNext()) {
            CellBlock block = it.next();
            rowSpans.restruct(block.getRow(), block.getRow2());
        }
        return rowSpans;
    }

    public SortedSpanArray toColumnSpans() {
        SortedSpanArray colSpans = new SortedSpanArray();
        SelectIterator it = this.getSelectIterator();
        while (it.hasNext()) {
            CellBlock block = it.next();
            colSpans.restruct(block.getCol(), block.getCol2());
        }
        return colSpans;
    }

    public ArrayList toSelectionBlocks() {
        ArrayList<CellBlock> al = new ArrayList<CellBlock>();
        SelectIterator iter = this.getSelectIterator();
        while (iter.hasNext()) {
            al.add(iter.next());
        }
        return al;
    }

    public SortedCellBlockArray toSortedBlocks() {
        SortedCellBlockArray sortedBlocks = new SortedCellBlockArray();
        SelectIterator it = this.getSelectIterator();
        while (it.hasNext()) {
            CellBlock block = it.next();
            sortedBlocks.insert(block);
        }
        return sortedBlocks;
    }

    public boolean isMixedBlocks() {
        boolean containRowColSelect = false;
        boolean containCellSelect = false;
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            CellBlock block = this.getBlock(index);
            if (block.isRow() || block.isCol()) {
                containRowColSelect = true;
                continue;
            }
            containCellSelect = true;
        }
        return containCellSelect && containRowColSelect;
    }

    public boolean isRowBlocks() {
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            if (this.getBlock(index).isRow()) continue;
            return false;
        }
        return true;
    }

    public boolean isColBlocks() {
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            if (this.getBlock(index).isCol()) continue;
            return false;
        }
        return true;
    }

    public void setActivePosition(int row, int col, int index) {
        this.setActivePosition(row, col, index, true);
    }

    public boolean isSheetBlocks() {
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            if (!this.getBlock(index).isWholeSheet()) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapped() {
        int size = this._blocks.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                CellBlock block = (CellBlock)this._blocks.get(i);
                if (!block.isIntersect((CellBlock)this._blocks.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSingleBlock() {
        return this._blocks.size() == 1;
    }

    public boolean isBaseUnit() {
        if (!this.isSingleBlock()) {
            return false;
        }
        CellBlock activeBlock = this.getBlock(this.getActiveIndex());
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        boolean isCellBase = activeBlock.isSingleCell();
        boolean isMergeBase = merger == null ? false : merger.isMerged(activeBlock);
        return isCellBase || isMergeBase;
    }

    public int getSelectModeAtRow(int row) {
        int selectMode = 4;
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            CellBlock block = this.getBlock(index);
            if (!block.containsRow(row)) continue;
            selectMode = 3;
            if (!block.isRow()) continue;
            selectMode = 1;
            break;
        }
        return selectMode;
    }

    public int getSelectModeAtCol(int column) {
        int selectMode = 4;
        for (int index = this._blocks.size() - 1; index >= 0; --index) {
            CellBlock block = this.getBlock(index);
            if (!block.containsCol(column)) continue;
            selectMode = 3;
            if (!block.isCol()) continue;
            selectMode = 2;
            break;
        }
        return selectMode;
    }

    public boolean isRowSelect(int row) {
        return this.getSelectModeAtRow(row) == 1;
    }

    public boolean isColumnSelect(int col) {
        return this.getSelectModeAtCol(col) == 2;
    }

    public int getActiveCol() {
        return this._pos.getCol();
    }

    public int getActiveRow() {
        return this._pos.getRow();
    }

    public int getActiveIndex() {
        return this._pos.getIndex();
    }

    public CellBlock getCloneActiveBlock() {
        return (CellBlock)this.getBlock(this.getActiveIndex()).clone();
    }

    @Deprecated
    public CellBlock getActiveBlock() {
        return this.getBlock(this.getActiveIndex());
    }

    public boolean contains(int row, int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getBlock(i).contains(row, col)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRow(int row) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getBlock(i).containsRow(row)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCol(int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getBlock(i).containsCol(col)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this._blocks.size();
    }

    void setData(SortedCellBlockArray blocks, int avIndex, int avRow, int avCol) {
        ArrayList<CellBlock> list = new ArrayList<CellBlock>();
        for (int i = 0; i < blocks.size(); ++i) {
            list.add(blocks.getBlock(i));
        }
        this.setData(list, avIndex, avRow, avCol);
    }

    public void syncAllSelected() {
        this._invalidBlocks.clear();
        for (int i = this._blocks.size() - 1; i >= 0; --i) {
            CellBlock block = (CellBlock)this._blocks.get(i);
            if (!this.calcActualBlock(block)) continue;
            this._invalidBlocks.insert(block);
        }
        if (!this._invalidBlocks.isEmpty()) {
            this.invalidate(SheetChangeEvent.Changed_Selection);
        }
        this.sameSelection();
    }

    private boolean changeSelectionImpl(CellBlock block, int changeMode, boolean calcMerger, boolean invaldate) {
        if (invaldate) {
            Book book = this._sheet.getBook();
            book.fireSheetChange(this._sheet, null, SheetChangeEvent.Changed_BeforeSelection);
        }
        if (this._selectMode == 1) {
            block = CellBlock.getCellBlock(block._row, 0, block._row2, 65535);
        } else if (this._selectMode == 2) {
            block = CellBlock.getCellBlock(0, block._col, 1048575, block._col2);
        }
        if (!this._sheet.allowSelectBlock(block)) {
            return false;
        }
        if (!calcMerger) {
            SortedCellBlockArray limitMerger;
            MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
            SortedCellBlockArray sortedCellBlockArray = limitMerger = merger == null ? null : merger.getTouchedBlocks(block);
            if (block.isRow()) {
                int r = block.getRow();
                int r2 = block.getRow2();
                if (limitMerger != null) {
                    for (int i = limitMerger.size() - 1; i >= 0; --i) {
                        CellBlock mb = limitMerger.getBlock(i);
                        if (!mb.isRow()) continue;
                        r = Math.min(r, mb.getRow());
                        r2 = Math.max(r2, mb.getRow2());
                    }
                }
                block.setRow(r);
                block.setRow2(r2);
            } else if (block.isCol()) {
                int c = block.getCol();
                int c2 = block.getCol2();
                if (limitMerger != null) {
                    for (int i = limitMerger.size() - 1; i >= 0; --i) {
                        CellBlock mb = limitMerger.getBlock(i);
                        if (!mb.isCol()) continue;
                        c = Math.min(c, mb.getCol());
                        c2 = Math.max(c2, mb.getCol2());
                    }
                }
                block.setCol(c);
                block.setCol2(c2);
            }
        }
        if (changeMode == 1) {
            this.append(block, calcMerger, invaldate);
        } else if (changeMode == 3) {
            this.update(block, calcMerger, invaldate);
        } else {
            this.reset(block, calcMerger, invaldate);
        }
        this.sameSelection();
        return true;
    }

    private void sameSelection() {
        Book book = this._sheet.getBook();
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            ISheet sheet = book.getISheet(i);
            if (sheet == this._sheet || !(sheet instanceof Sheet) || !sheet.isSelected()) continue;
            Selection sel = ((Sheet)sheet).getSheetOption().getSelection();
            sel._blocks.clear();
            ArrayList<CellBlock> synBlocks = new ArrayList<CellBlock>();
            Iterator iterator = this._blocks.iterator();
            while (iterator.hasNext()) {
                CellBlock synBlock = CellBlock.getCellBlock((CellBlock)iterator.next());
                MergeBlocks mb = ((Sheet)sheet).getSheetOption().getMerger(false);
                if (mb != null) {
                    mb.calActualBlock(synBlock);
                }
                synBlocks.add(synBlock);
            }
            sel._blocks.addAll(synBlocks);
            sel.setActivePosition(this.getActiveRow(), this.getActiveCol(), this.getActiveIndex(), false);
        }
    }

    private void append(CellBlock block, boolean calcMerger, boolean invaldate) {
        boolean bWhole = this.calcSelectionActualBlock(block, calcMerger);
        this._invalidBlocks.clear();
        int size = this.size();
        if (size == 1) {
            for (int i = 0; i < size; ++i) {
                this._invalidBlocks.insert(this.getBlock(i));
            }
        }
        this._invalidBlocks.insert(block);
        this._blocks.add(block);
        if (bWhole) {
            this.setActivePosition(block.getRow(), block.getCol(), this._blocks.size() - 1, false);
        } else {
            this.calcAndSetActivePosition(block);
        }
        if (invaldate) {
            this.invalidate(SheetChangeEvent.Changed_SelectionActive | SheetChangeEvent.Changed_Selection);
        }
    }

    private void reset(CellBlock block, boolean calcMerger, boolean invalide) {
        boolean bWhole = this.calcSelectionActualBlock(block, calcMerger);
        this._invalidBlocks.clear();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this._invalidBlocks.insert(this.getBlock(i));
        }
        this._invalidBlocks.insert(block);
        this._blocks.clear();
        this._blocks.add(block);
        if (bWhole) {
            this.setActivePosition(block.getRow(), block.getCol(), 0, false);
        } else {
            this.calcAndSetActivePosition(block);
        }
        if (invalide) {
            this.invalidate(SheetChangeEvent.Changed_SelectionActive | SheetChangeEvent.Changed_Selection);
        }
    }

    private void update(CellBlock block, boolean calcMerger, boolean invaldate) {
        this.calcSelectionActualBlock(block, calcMerger);
        int avIndex = this.getActiveIndex();
        CellBlock oldBlock = this.getBlock(avIndex);
        if (oldBlock.equals(block)) {
            return;
        }
        this._invalidBlocks.clear();
        long states = SheetChangeEvent.Changed_Selection;
        if (oldBlock.isRow()) {
            states = SheetChangeEvent.Changed_SelectionRowCorner;
        } else if (oldBlock.isCol()) {
            states = SheetChangeEvent.Changed_SelectionColCorner;
        }
        oldBlock.split(block, this._invalidBlocks);
        block.split(oldBlock, this._invalidBlocks);
        this._blocks.set(avIndex, block);
        if (invaldate) {
            this.invalidate(states);
        }
    }

    private boolean calcSelectionActualBlock(CellBlock block, boolean calcMerger) {
        boolean bWhole = false;
        if (calcMerger || block.isNotRowCol()) {
            bWhole = true;
            this.calcActualBlock(block);
        }
        return bWhole;
    }

    private void calcAndSetActivePosition(CellBlock block) {
        if (block.isRow()) {
            CellBlock mb;
            int col = this._sheet.getSheetOption().getViewSplitInfo().getFirstCol();
            int row = block.getRow();
            MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
            CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(row, col);
            while (mb != null && !mb.isFirstCell(row, col)) {
                col = SheetBaseMath.getNextVisibleCol(this._sheet, mb.getCol2());
                mb = merger.searchBlock(row, col);
            }
            this.setActiveCell(row, col);
            this.getActivePosition().setBlockIndex(0);
        } else if (block.isCol()) {
            CellBlock mb;
            int row = this._sheet.getSheetOption().getViewSplitInfo().getFirstRow();
            int col = block.getCol();
            MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
            CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(row, col);
            while (mb != null && !mb.isFirstCell(row, col)) {
                row = SheetBaseMath.getNextVisibleRow(this._sheet, mb.getRow2());
                mb = merger.searchBlock(row, col);
            }
            this.setActiveCell(row, col);
            this.getActivePosition().setBlockIndex(0);
        } else if (block.isRow() && block.isCol()) {
            CellBlock mb;
            int row = this._sheet.getSheetOption().getViewSplitInfo().getFirstRow();
            int col = this._sheet.getSheetOption().getViewSplitInfo().getFirstCol();
            MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
            CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(row, col);
            while (mb != null && !mb.isFirstCell(row, col)) {
                row = mb.getRow();
                col = mb.getCol();
            }
            this.setActiveCell(row, col);
            this.getActivePosition().setBlockIndex(0);
        }
    }

    private void invalidate(long changedState) {
        Book book = this._sheet.getBook();
        book.fireSheetChange(this._sheet, this._invalidBlocks, changedState);
    }

    private void activeMoveLeft() {
        int col = SheetBaseMath.getLastVisibleCol(this._sheet, this.getActiveCol());
        if (col == this.getActiveCol()) {
            col = -1;
        }
        int row = this.getActiveRow();
        int index = this.getActiveIndex();
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        CellBlock block = this.getBlock(index);
        while (true) {
            if (block.contains(row, col)) {
                CellBlock cb;
                CellBlock cellBlock = cb = merger == null ? null : merger.searchBlock(row, col);
                if (cb == null || cb.isFirstCell(row, col)) break;
                col = SheetBaseMath.getLastVisibleCol(this._sheet, cb._row == row ? cb._col + 1 : cb._col);
                if (col != cb._col || row == cb._row) continue;
                col = -1;
                continue;
            }
            if (block._row < row) {
                row = SheetBaseMath.getLastVisibleRow(this._sheet, row);
                col = SheetBaseMath.getLastVisibleCol(this._sheet, block._col2 + 1);
                continue;
            }
            index = index == 0 ? this.size() - 1 : --index;
            block = this.getBlock(index);
            row = SheetBaseMath.getLastVisibleRow(this._sheet, block._row2 + 1);
            col = SheetBaseMath.getLastVisibleCol(this._sheet, block._col2 + 1);
        }
        this.setActivePosition(row, col, index, true);
    }

    private void activeMoveRight() {
        int col = SheetBaseMath.getNextVisibleCol(this._sheet, this.getActiveCol());
        if (col == this.getActiveCol()) {
            col = -1;
        }
        int row = this.getActiveRow();
        int index = this.getActiveIndex();
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        CellBlock block = this.getBlock(index);
        while (true) {
            if (block.contains(row, col)) {
                CellBlock cb;
                CellBlock cellBlock = cb = merger == null ? null : merger.searchBlock(row, col);
                if (cb == null || cb.isFirstCell(row, col)) break;
                col = SheetBaseMath.getNextVisibleCol(this._sheet, cb._col2);
                if (col != cb._col2) continue;
                col = -1;
                continue;
            }
            if (block._row2 > row) {
                row = SheetBaseMath.getNextVisibleRow(this._sheet, row);
                col = SheetBaseMath.getNextVisibleCol(this._sheet, block._col - 1);
                continue;
            }
            index = index == this.size() - 1 ? 0 : ++index;
            block = this.getBlock(index);
            row = SheetBaseMath.getNextVisibleRow(this._sheet, block._row - 1);
            col = SheetBaseMath.getNextVisibleCol(this._sheet, block._col - 1);
        }
        this.setActivePosition(row, col, index, true);
    }

    private void activeMoveDown() {
        int row = SheetBaseMath.getNextVisibleRow(this._sheet, this.getActiveRow());
        if (row == this.getActiveRow()) {
            row = -1;
        }
        int col = this.getActiveCol();
        int index = this.getActiveIndex();
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        CellBlock block = this.getBlock(index);
        while (true) {
            if (block.contains(row, col)) {
                CellBlock cb;
                CellBlock cellBlock = cb = merger == null ? null : merger.searchBlock(row, col);
                if (cb == null || cb.isFirstCell(row, col)) break;
                row = SheetBaseMath.getNextVisibleRow(this._sheet, cb._row2);
                if (row != cb._row2) continue;
                row = -1;
                continue;
            }
            if (block._col2 > col) {
                row = SheetBaseMath.getNextVisibleRow(this._sheet, block._row - 1);
                col = SheetBaseMath.getNextVisibleCol(this._sheet, col);
                continue;
            }
            index = index == this.size() - 1 ? 0 : ++index;
            block = this.getBlock(index);
            row = SheetBaseMath.getNextVisibleRow(this._sheet, block._row - 1);
            col = SheetBaseMath.getNextVisibleCol(this._sheet, block._col - 1);
        }
        this.setActivePosition(row, col, index, true);
    }

    private void activeMoveUp() {
        int row = SheetBaseMath.getLastVisibleRow(this._sheet, this.getActiveRow());
        if (row == this.getActiveRow()) {
            row = -1;
        }
        int col = this.getActiveCol();
        int index = this.getActiveIndex();
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        CellBlock block = this.getBlock(index);
        while (true) {
            if (block.contains(row, col)) {
                CellBlock cb;
                CellBlock cellBlock = cb = merger == null ? null : merger.searchBlock(row, col);
                if (cb == null || cb.isFirstCell(row, col)) break;
                row = SheetBaseMath.getLastVisibleRow(this._sheet, col == cb._col ? cb._row + 1 : cb._row);
                if (row != cb._row || col == cb._col) continue;
                row = -1;
                continue;
            }
            if (block._col < col) {
                row = SheetBaseMath.getLastVisibleRow(this._sheet, block._row2 + 1);
                col = SheetBaseMath.getLastVisibleCol(this._sheet, col);
                continue;
            }
            index = index == 0 ? this.size() - 1 : --index;
            block = this.getBlock(index);
            row = SheetBaseMath.getLastVisibleRow(this._sheet, block._row2 + 1);
            col = SheetBaseMath.getLastVisibleCol(this._sheet, block._col2 + 1);
        }
        this.setActivePosition(row, col, index, true);
    }

    private void setActivePosition(int row, int col, int index, boolean bInvalidate) {
        boolean b = false;
        if (bInvalidate && (row != this.getActiveRow() || col != this.getActiveCol())) {
            this._invalidBlocks.clear();
            this._invalidBlocks.insert(CellBlock.getCellBlock(row, col));
            this._invalidBlocks.insert(CellBlock.getCellBlock(this.getActiveRow(), this.getActiveCol()));
            b = true;
        }
        this.getActivePosition().setActive(row, col, index);
        if (b) {
            this.invalidate(SheetChangeEvent.Changed_SelectionActive);
        }
    }

    private boolean calcActualBlock(CellBlock block) {
        Book book = this._sheet.getBook();
        int count = book.getSheetCount();
        this.bufBlock.setRowCol(block);
        this.bufBlock2.setRowCol(block);
        do {
            this.bufBlock.setRowCol(this.bufBlock2);
            for (int i = count - 1; i >= 0; --i) {
                MergeBlocks mb;
                ISheet sheet = book.getISheet(i);
                if (!(sheet instanceof Sheet) || sheet != book.getActiveSheet() || (mb = ((Sheet)sheet).getSheetOption().getMerger(false)) == null) continue;
                mb.calActualBlock(this.bufBlock2);
            }
        } while (!this.bufBlock.equals(this.bufBlock2));
        boolean b = !this.bufBlock.equals(block);
        block.setRowCol(this.bufBlock);
        return b;
    }

    public class ActivePosition
    extends Position {
        protected int _blockInx;
        private Object _o;

        public ActivePosition() {
        }

        public ActivePosition(int row, int col, int bInx) {
            this.setActive(row, col, bInx);
        }

        public void copyFrom(ActivePosition ap) {
            super.copyFrom(ap);
            this._blockInx = ap._blockInx;
            this._o = ap._o;
        }

        public void setActive(ActivePosition pos) {
            this.setActive(pos.row, pos.col, pos._blockInx);
        }

        public void setActive(int row, int col, int bInx) {
            this.setRowCol(row, col);
            this.setBlockIndex(bInx);
        }

        public void setBlockIndex(int bInx) {
            this._blockInx = bInx;
        }

        public int getIndex() {
            return this._blockInx;
        }

        public Object getObject() {
            return this._o;
        }

        public void setObject(Object o) {
            this._o = o;
        }
    }

    public class SelectIterator {
        private int index;
        private boolean started = false;

        SelectIterator() {
            this.index = Selection.this.getActiveIndex();
        }

        public CellBlock next() {
            CellBlock block = (CellBlock)Selection.this._blocks.get(this.index);
            this.started = true;
            int size = Selection.this._blocks.size();
            this.index = (this.index + 1) % size;
            return block;
        }

        public boolean hasNext() {
            return Selection.this.size() > 0 && (!this.started || this.index != Selection.this.getActiveIndex());
        }
    }
}

