/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class SheetAction_AutoFilter_DoSort
extends SheetAction {
    private Sheet sheet;
    private byte orderBy;
    private int orderColIndex;
    private RangeSorter sorter;
    private boolean containMerge = false;

    public SheetAction_AutoFilter_DoSort(Range rg, byte orderBy, int orderColIndex, boolean containMerge) {
        super(rg, SheetChangeEvent.Changed_AutoFilter);
        if (rg.size() > 1) {
            throw new IllegalArgumentException("range should not be list");
        }
        if (rg.getBlock(0) == null) {
            throw new IllegalArgumentException("the cellblock in range should not be null");
        }
        this.sheet = rg.getRangeSheets().getSheet(0);
        this.orderBy = orderBy;
        this.orderColIndex = orderColIndex;
        this.containMerge = containMerge;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        state.setData("orderBy", sheet.getOrderBy());
        state.setData("orderColIndex", sheet.getOrderColIndex());
        if (this.containMerge) {
            if (this.sorter == null) {
                this.sorter = new RangeSorter();
            }
            this.sorter.sortRange(this.orderColIndex, this.orderBy == 0);
        } else {
            this._rg.sort(new int[]{this.orderColIndex}, new boolean[]{this.orderBy == 0}, true, false);
        }
        sheet.calc();
        sheet.setOrderColIndex(this.orderColIndex);
        sheet.setOrderBy(this.orderBy);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        byte orderBy = Byte.valueOf(state.get("orderBy").toString());
        int orderColIndex = Integer.valueOf(state.get("orderColIndex").toString());
        sheet.setOrderColIndex(orderColIndex);
        sheet.setOrderBy(orderBy);
    }

    private class RangeSorter
    implements Comparator {
        private Sheet sortSheet = null;

        private RangeSorter() {
        }

        public int compare(Object arg0, Object arg1) {
            return 0;
        }

        void sortRange(int colIndex, boolean isRowSort) {
            CellBlock cb;
            ArrayList rowList;
            int i;
            if (this.sortSheet == null) {
                Book sortBook = Book.Manager.getNewBook("_Sort_", 1);
                sortBook.setAutoCalculate(false);
                sortBook.getUndoManager().enable(false);
                this.sortSheet = sortBook.getSheet(0);
            }
            HashMap<String, CellBlock> valueMap = new HashMap<String, CellBlock>();
            CellBlock autoFilterArea = SheetAction_AutoFilter_DoSort.this.sheet.getAutoFilterArea();
            int row = autoFilterArea.getRow();
            int row2 = autoFilterArea.getRow2();
            int col = autoFilterArea.getCol();
            int col2 = autoFilterArea.getCol2();
            ArrayList<ArrayList> buffer = new ArrayList<ArrayList>();
            for (i = row; i <= row2; ++i) {
                rowList = new ArrayList();
                int t = i;
                for (int j = col; j <= col2; ++j) {
                    cb = SheetAction_AutoFilter_DoSort.this.sheet.getMergeBlock(t, j);
                    if (cb == null || cb.isSingleCell() || buffer.contains(cb)) continue;
                    rowList.add(cb);
                    i = cb.getRow2();
                }
                buffer.add(rowList);
            }
            buffer.remove(0);
            for (i = 0; i < buffer.size(); ++i) {
                rowList = (ArrayList)buffer.get(i);
                col = 0;
                Iterator iter = rowList.iterator();
                while (iter.hasNext()) {
                    Cell cell = this.sortSheet.getCell(i, col, true);
                    cb = (CellBlock)iter.next();
                    cell.setValue(this.getCellBlockValue(cb));
                    cell.setUserObject("sortInformation", i + ":" + col + "");
                    valueMap.put(i + ":" + col + "", cb);
                    ++col;
                }
            }
            CellBlock cb2 = CellBlock.getCellBlock(0, 0, buffer.size() - 1, col - 1);
            this.sortSheet.setAutoFilterArea(cb2);
            Range sort = new Range(this.sortSheet.getBook(), this.sortSheet, cb2);
            sort.sort(new int[]{colIndex - autoFilterArea.getCol()}, new boolean[]{isRowSort}, true, false);
            for (int i2 = 0; i2 < (buffer.size() - 1) / 2; ++i2) {
                ArrayList rowList2 = (ArrayList)buffer.get(i2);
                for (int j = 0; j < col; ++j) {
                    Cell cell = this.sortSheet.getCell(i2, j, false);
                    CellBlock temp = (CellBlock)valueMap.get(cell.getUserObject("sortInformation").getValue());
                    this.switchBlock(temp, (CellBlock)rowList2.get(j));
                }
            }
            sort.delete();
        }

        private Variant getCellBlockValue(CellBlock cb) {
            Cell cell = SheetAction_AutoFilter_DoSort.this.sheet.getCell(cb.getRow(), cb.getCol(), false);
            if (cell != null) {
                return cell.getValue();
            }
            return Variant.nullVariant;
        }

        private void switchBlock(CellBlock src, CellBlock dest) {
            Sheet temp = null;
            Book sortBook = Book.Manager.getNewBook("_Sort_", 1);
            sortBook.setAutoCalculate(false);
            sortBook.getUndoManager().enable(false);
            temp = sortBook.getSheet(0);
            Range destR = new Range(SheetAction_AutoFilter_DoSort.this.sheet.getBook(), SheetAction_AutoFilter_DoSort.this.sheet, dest);
            Range tempR = new Range(temp.getBook(), temp, src);
            Range srcR = new Range(SheetAction_AutoFilter_DoSort.this.sheet.getBook(), SheetAction_AutoFilter_DoSort.this.sheet, src);
            destR.copy();
            tempR.paste(PasteMode.ALL);
            srcR.copy();
            destR.paste(PasteMode.ALL);
            tempR.copy();
            srcR.paste(PasteMode.ALL);
        }
    }
}

