/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.collection;

import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;

public class CellBlockMatrix
extends SortedSpanArray {
    private static final long serialVersionUID = -7088928773056594799L;
    private final BlocksSpan _cols = new BlocksSpan(-1, -1);

    public CellBlockMatrix() {
        super(1048575);
    }

    public boolean addBlock(CellBlock cb) {
        int row = cb.getRow();
        int pos = this.searchSpan(row);
        if (pos > -1) {
            BlocksSpan sp = (BlocksSpan)this.get(pos);
            if (sp.getStart() != row || sp.getEnd() != cb.getRow2() || !this._cols.addBlock(cb)) {
                return false;
            }
            return sp.addBlock(cb);
        }
        int row2 = cb.getRow2();
        if (this.searchSpan(row2) != pos || !this._cols.addBlock(cb)) {
            return false;
        }
        BlocksSpan sp = new BlocksSpan(row, row2);
        sp.addBlock(cb);
        this.insert(pos, sp);
        return true;
    }

    public CellBlock[][] getMatrix() {
        if (this._count < 1) {
            return null;
        }
        SortedSpanArray colBlocks = this._cols.getBlocks();
        int cols = colBlocks.size();
        CellBlock[][] matrix = new CellBlock[this._count][];
        for (int i = 0; i < matrix.length; ++i) {
            SortedSpanArray blocks = ((BlocksSpan)this.get(i)).getBlocks();
            if (blocks.size() != cols) {
                for (int j = 0; j < cols; ++j) {
                    Span sp = colBlocks.getSpan(j);
                    int pos = blocks.searchSpan(sp.getStart());
                    if (pos >= 0) continue;
                    blocks.insert(pos, null);
                }
            }
            CellBlock[] row = new CellBlock[cols];
            for (int c = 0; c < cols; ++c) {
                BlockSpan sp = (BlockSpan)blocks.get(c);
                row[c] = sp == null ? null : sp.getBlock();
            }
            matrix[i] = row;
        }
        return matrix;
    }

    static final class BlocksSpan
    extends Span {
        private final SortedSpanArray _blocks = new SortedSpanArray(65535);

        BlocksSpan(int start, int end) {
            super(start, end);
        }

        boolean addBlock(CellBlock cb) {
            int col = cb.getCol();
            int pos = this._blocks.searchSpan(col);
            if (pos > -1) {
                BlockSpan sp = (BlockSpan)this._blocks.get(pos);
                if (sp.getStart() != col || sp.getEnd() != cb.getCol2()) {
                    return false;
                }
                sp.setBlock(cb);
            } else {
                if (this._blocks.searchSpan(cb.getCol2()) != pos) {
                    return false;
                }
                BlockSpan sp = new BlockSpan(cb);
                this._blocks.insert(pos, sp);
            }
            return true;
        }

        int size() {
            return this._blocks.size();
        }

        SortedSpanArray getBlocks() {
            return this._blocks;
        }
    }

    static final class BlockSpan
    extends Span {
        private CellBlock _block;

        BlockSpan(CellBlock block) {
            super(block.getCol(), block.getCol2());
            this._block = block;
        }

        CellBlock getBlock() {
            return this._block;
        }

        void setBlock(CellBlock block) {
            this._block = block;
        }
    }
}

