/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts;

import chrriis.dj.nativeswing.common.Utils;
import chrriis.dj.nativeswing.common.WebServer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.util.backport.concurrent.atomic.AtomicInteger;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.WeakHashMap;

public class DebugResourceProvider {
    private static final Map<String, String> jsMap = new WeakHashMap<String, String>();
    private static final AtomicInteger count = new AtomicInteger();
    private static final String REPLACE_CHECKPOINT = "//put your js code here";

    public static void addJS(String debugID, String js) {
        jsMap.put(debugID, js);
    }

    public static String genDebugID() {
        return "debug" + count.incrementAndGet();
    }

    private DebugResourceProvider() {
    }

    private static String removeHTMLAnchor(String location) {
        int anchorIndex = location.indexOf(35);
        if (anchorIndex > 0) {
            location = location.substring(0, anchorIndex);
        }
        return location;
    }

    public static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        int index;
        String parameter = httpRequest.getResourcePath();
        if (parameter.startsWith("/")) {
            parameter = parameter.substring(1);
        }
        if ((index = parameter.indexOf(47)) != -1) {
            final String resourcePath = Utils.decodeURL((String)DebugResourceProvider.removeHTMLAnchor(parameter));
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    int index = resourcePath.lastIndexOf(46);
                    return 1.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                }

                public InputStream getInputStream() {
                    try {
                        InputStream in = DebugResourceProvider.class.getResourceAsStream(resourcePath);
                        if (in != null) {
                            return in;
                        }
                        return Utils.getResourceAsStreamWithinJavaModules(WebServer.class, (String)('/' + resourcePath));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        final String debugID = parameter;
        return new WebServer.WebServerContent(){

            public InputStream getInputStream() {
                String htmlContent = TransferUtils.getResourceAsString(DebugResourceProvider.class, "chart.html", StandardCharsets.UTF_8);
                String js = (String)jsMap.get(debugID);
                if (null != js) {
                    htmlContent = htmlContent.replace(DebugResourceProvider.REPLACE_CHECKPOINT, js);
                }
                return 2.getInputStream((String)htmlContent);
            }
        };
    }
}

