/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts;

import chrriis.dj.nativeswing.common.UIUtils;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.GsonOption;
import com.github.abel533.echarts.series.Bar;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsRenderType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.swing.KDFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class EChartPanelTest {
    private EChartDisplayPanel displayPanel;
    private KDFrame frame;

    private void addEchart(BrowserType type) {
        if (this.displayPanel == null) {
            EChartDisplayPanel.EChartDisPlayPanelBuidler buidler = EChartDisplayPanel.getBuidler();
            buidler.renderType(EChartsRenderType.SVG).browserType(type).charReadyFunction(b -> b.execute(TransferUtils.getExecuteStr(this.getOption(), true))).panelDebug(true);
            this.displayPanel = buidler.build();
            this.frame.add((Component)this.displayPanel.getDisplayPanel(), (Object)"Center");
        }
    }

    private Option getOption() {
        GsonOption p = new GsonOption();
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        p.xAxis().add(caxis);
        p.yAxis().add(new ValueAxis());
        p.tooltip().trigger(Trigger.axis);
        p.tooltip().axisPointer().type(PointerType.shadow);
        p.legend().data(Arrays.asList("2020\u5e74", "2021\u5e74"));
        Bar bar1 = new Bar();
        bar1.name("2020\u5e74");
        bar1.setData(Arrays.asList(120, 200, 150, 80, 70, 110, 130));
        Bar bar2 = new Bar();
        bar2.name("2021\u5e74");
        bar2.setData(Arrays.asList(50, 120, 200, 30, 120, 60, 150));
        p.series().add(bar1);
        p.series().add(bar2);
        return p;
    }

    private void setup(BrowserType type) {
        this.frame = new KDFrame("echart testing");
        this.frame.setLayout((LayoutManager)new BorderLayout());
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(800, 800);
        this.frame.setVisible(true);
        this.addEchart(type);
    }

    public static void main(String[] args) {
        BrowserType type = BrowserType.WEBVIEW;
        if (BrowserType.DJNATIVEBROWSER == type) {
            NativeInterface.open();
            UIUtils.setPreferredLookAndFeel();
            NativeInterface.runEventPump();
        }
        SwingUtilities.invokeLater(() -> {
            EChartPanelTest test = new EChartPanelTest();
            test.setup(type);
        });
    }
}

