/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.bos.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.IEmbedX;
import com.kingdee.bos.ctrl.kds.model.struct.embed.RectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportGuiExecutor;
import com.kingdee.bos.ctrl.kds.model.struct.embed.subrpt.SubReportSpreadContext;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SubReportEmbed
extends RectEmbedment
implements IEmbedX,
ImageObserver {
    private static final Logger logger = CommonLogger.getLogger(SubReportEmbed.class);
    private Cell _cell;
    private SubReportInfo _subReportInfo;
    private SubReportSpreadContext _subRptSpreadContext;
    private Image image;
    private static final byte ID_SubBookContent = 1;

    public SubReportEmbed(Cell cell) {
        super(cell.getSheet());
        this.setCell(cell);
        this.setSubReportInfo(cell.getSubReportInfo());
    }

    public SubReportEmbed(Sheet sheet) {
        super(sheet);
    }

    public Cell getCell() {
        return this._cell;
    }

    public void setCell(Cell cell) {
        this._cell = cell;
    }

    public SubReportInfo getSubReportInfo() {
        return this._subReportInfo;
    }

    public void setSubReportInfo(SubReportInfo _subReportInfo) {
        this._subReportInfo = _subReportInfo;
    }

    @Override
    public Component getPhysicalUI() {
        return this._subRptSpreadContext;
    }

    public void setPhysicalUI(SubReportSpreadContext subRptSpreadContext) {
        this._subRptSpreadContext = subRptSpreadContext;
    }

    @Override
    public void setUIPhysical(boolean physical) {
    }

    @Override
    public void relayout() {
        if (this._cell == null) {
            super.relayout();
        } else {
            SubReportGuiExecutor.setSubRptEmbedBounds(this, this._cell);
        }
    }

    @Override
    public void paintData(Graphics g) {
        if (this._subRptSpreadContext != null) {
            this._subRptSpreadContext.hideOrShowScrollBar(this.getBounds());
        }
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] saveCustom() {
        Book subBook;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        if (this._subReportInfo != null && (subBook = this._subReportInfo.getBook()) != null) {
            Book mainBook = null;
            try {
                mainBook = this.getSheet().getBook();
                SnapReportControlModel controlModel = new SnapReportControlModel();
                Object oIsSavelink = mainBook.getUserObjectValue("isSnapReportSaveHyperLink");
                if (oIsSavelink != null) {
                    if (oIsSavelink instanceof Boolean) {
                        controlModel.setSaveHyplink((Boolean)oIsSavelink);
                    } else if (oIsSavelink instanceof String) {
                        boolean isSaveHyperlink = Boolean.valueOf((String)oIsSavelink);
                        controlModel.setSaveHyplink(isSaveHyperlink);
                    }
                }
                byte[] contents = ExecutorUtil.generateShapShot(subBook, controlModel);
                out.writeByte(1);
                out.writeLengthBytes(contents);
            }
            catch (Exception e) {
                logger.error((Object)"\u4fdd\u5b58\u5b50\u62a5\u8868\u51fa\u9519\uff01", (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (bs != null) {
                        bs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bs.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadCustom(byte[] str) {
        KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
        byte id = 0;
        try {
            id = is.readByte();
            if (id == 1) {
                byte[] content = is.readLengthBytes();
                Book subBook = BookIOUtil.unpack(content);
                this._subReportInfo = new SubReportInfo();
                this._subReportInfo.setBook(subBook);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8bfb\u53d6\u5b50\u62a5\u8868\u51fa\u9519\uff01", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void split(SpreadView[] splitViews, SpreadContext.PhysicalEmbedXListener listener) {
        if (splitViews == null || this.splitArray != null) {
            return;
        }
        int len = splitViews.length;
        if (this.splitArray == null || this.splitArray.length == 0) {
            this.splitArray = new Object[2 * len];
        }
        Rectangle bounds = this.getBounds();
        for (int i = 0; i < len; ++i) {
            if (splitViews[i] == null) continue;
            SubReportEmbed newEmbed = new SubReportEmbed(this.getSheet());
            SubReportSpreadContext spreadContext = new SubReportSpreadContext(this._subReportInfo.getBook(), this._subRptSpreadContext.getExecutor(), bounds);
            newEmbed.setPhysicalUI(spreadContext);
            newEmbed.setBounds(bounds);
            Component physicUI = newEmbed.getPhysicalUI();
            physicUI.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            splitViews[i].add(physicUI);
            splitViews[i].revalidate();
            this.splitArray[i * 2] = splitViews[i];
            this.splitArray[i * 2 + 1] = newEmbed;
        }
    }

    @Override
    public void merge() {
        if (this.splitArray == null) {
            return;
        }
        int len = this.splitArray.length / 2;
        for (int i = 0; i < len; ++i) {
            if (this.splitArray[i * 2] == null || this.splitArray[i * 2 + 1] == null) continue;
            ((SpreadView)this.splitArray[i * 2]).remove(((SubReportEmbed)this.splitArray[i * 2 + 1]).getPhysicalUI());
            ((SpreadView)this.splitArray[i * 2]).revalidate();
        }
        this.splitArray = null;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}

