/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.validate;

import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;

public final class ValidationList {
    private static final SortedCellBlockArray compResult = new SortedCellBlockArray();
    private static final SortedCellBlockArray remainResult = new SortedCellBlockArray();
    private ArrayList _validations = new ArrayList();
    private SortedCellBlockArray _all;

    public ValidationList getClippedCopy(int left, int top, int right, int bottom) {
        ArrayList<Validation> clippedValidations = new ArrayList<Validation>();
        for (int i = 0; i < this._validations.size(); ++i) {
            Validation val = ((Validation)this._validations.get(i)).getClippedCopy(left, top, right, bottom);
            if (val == null) continue;
            clippedValidations.add(val);
        }
        if (clippedValidations.size() == 0) {
            return null;
        }
        ValidationList vl = new ValidationList();
        vl._validations = clippedValidations;
        return vl;
    }

    public void merge(Sheet sheet, ValidationList clippedCopy, int offsetY, int offsetX) {
        if (clippedCopy == null) {
            return;
        }
        ArrayList clippedValidations = clippedCopy._validations;
        for (int i = 0; i < clippedValidations.size(); ++i) {
            Validation validation = (Validation)clippedValidations.get(i);
            if (validation.isReportingValidation()) continue;
            SortedCellBlockArray scba = validation.getBlocks();
            for (int j = 0; j < scba.size(); ++j) {
                CellBlock cb = scba.getBlock(j);
                cb.offset(offsetY, offsetX);
            }
            this.insertValidation(sheet, validation.getMessagedValidate(), scba);
        }
    }

    public int size() {
        return this._validations == null ? 0 : this._validations.size();
    }

    public Validation getValidation(int index) {
        return (Validation)this._validations.get(index);
    }

    public MessagedValidate getValidate(Sheet sheet, int row, int col) {
        SortedCellBlockArray sa;
        Validation dv;
        int i;
        int size;
        if (!MiscUtil.isExecutedBook(sheet.getBook())) {
            return null;
        }
        if (this._all == null) {
            this._all = new SortedCellBlockArray();
            size = this.size();
            for (i = 0; i < size; ++i) {
                dv = this.getValidation(i);
                sa = dv.getBlocks();
                this._all.addAll(sa);
            }
            this._all.mergeSelf();
        }
        size = this.size();
        for (i = 0; i < size; ++i) {
            dv = this.getValidation(i);
            sa = dv.getBlocks();
            int vIndex = sa.searchBlockIndex(row, col);
            if (vIndex < 0) continue;
            return dv.getMessagedValidate();
        }
        return null;
    }

    public Validation getValidationContainer(SortedCellBlockArray source) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray sa = dv.getBlocks();
            if (!source.equals(sa)) continue;
            return dv;
        }
        return null;
    }

    public Validation getValidationContainer(int row, int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray sa = dv.getBlocks();
            int vIndex = sa.searchBlockIndex(row, col);
            if (vIndex < 0) continue;
            return dv;
        }
        return null;
    }

    public boolean isValided(Sheet sheet, int row, int col, String formula) {
        MessagedValidate mv = this.getValidate(sheet, row, col);
        if (mv == null) {
            return true;
        }
        return mv.isValidated(sheet, formula);
    }

    public void addValidation(Validation val) {
        this._validations.add(val);
    }

    private void insertValidation(Sheet sheet, MessagedValidate vm, SortedCellBlockArray sa, IntArray intersects) {
        int size = intersects.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(intersects.get(i));
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            remainResult.clear();
            sa.split(thisBlocks, remainResult);
            thisBlocks.copyFrom(remainResult);
        }
        if (vm != null) {
            if (this._validations == null) {
                this._validations = new ArrayList();
            }
            Validation dv = new Validation(sheet, vm, sa);
            this._validations.add(dv);
        }
        this.reduceImpl();
    }

    public void reduce() {
        this.reduceImpl();
    }

    private void reduceImpl() {
        for (int i = this.size() - 1; i >= 0; --i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            if (thisBlocks.isEmpty()) {
                this._validations.remove(i);
                continue;
            }
            if (dv.getMessagedValidate() != null) continue;
            this._validations.remove(i);
        }
    }

    public void insertValidation(Sheet sheet, MessagedValidate vm, SortedCellBlockArray sa) {
        IntArray intersects = new IntArray();
        this.calcIntersects(sa, intersects);
        this.insertValidation(sheet, vm, sa, intersects);
    }

    public boolean calcIntersects(SortedCellBlockArray sa, IntArray intersects) {
        int size = this.size();
        if (size <= 0) {
            return false;
        }
        compResult.copyFrom(sa);
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            remainResult.clear();
            boolean split = thisBlocks.split(compResult, remainResult);
            if (split) {
                intersects.add(i);
            }
            if (remainResult.isEmpty()) {
                return true;
            }
            compResult.copyFrom(remainResult);
        }
        return false;
    }

    public void addValidationAt(Validation val, int index) {
        this._validations.add(0, val);
    }
}

