/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.actions;

import com.kingdee.bos.ctrl.kdf.fd2.actions.AbstractDesignerFontAction;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.event.FontChangeEvent;
import java.util.ArrayList;

public class FontAction
extends AbstractDesignerFontAction {
    private boolean notFireFontChange = false;

    public void fontChanged(FontChangeEvent e) {
        if (this.notFireFontChange) {
            return;
        }
        ArrayList eles = this.designer.getKDFFrame().getSelectedElements();
        for (ReportElement ele : eles) {
            StyleAttributes sa = ele.getStyleAttribute();
            if (e.isFamilyChanged()) {
                sa.setFontName(e.getNewFamily());
            }
            if (e.isSizeChanged()) {
                sa.setFontSize(e.getNewSize());
            }
            if (e.isStyleChanged()) {
                sa.setBold((e.getNewStyle() & 1) == 1);
                sa.setItalic((e.getNewStyle() & 2) == 2);
            }
            this.notFireElePrptChg = true;
            ele.setStyleAttribute(sa);
            this.notFireElePrptChg = false;
        }
        this.designer.getKDFFrame().repaint();
        if (this.designer.getElementPropertiesDialog().isVisible()) {
            this.designer.getElementPropertiesDialog().updateSelection();
        }
    }

    @Override
    protected void syncCtrl(StyleAttributes sa) {
        this.notFireFontChange = true;
        String fontName = null;
        int fontSize = -1;
        int fontStyle = 0;
        if (!sa.isUnsureValue(StyleAttributes.FONT_NAME)) {
            fontName = sa.getFontName();
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_SIZE)) {
            fontSize = sa.getFontSize();
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_BOLD) && sa.isBold()) {
            ++fontStyle;
        }
        if (!sa.isUnsureValue(StyleAttributes.FONT_ITALIC) && sa.isItalic()) {
            fontStyle += 2;
        }
        this.ctrl.setSelectionFontWithUnsure(fontName, fontStyle, fontSize);
        this.notFireFontChange = false;
    }

    @Override
    protected boolean isEnabled() {
        return this.isSelectedHasFont();
    }

    @Override
    protected void setCtrlEnabled(boolean isEnabled) {
        this.ctrl.setEnabled(isEnabled);
    }
}

