/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.reportelement;

import com.kingdee.bos.ctrl.kdf.fd2.reportelement.GraphicElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public class LineElement
extends GraphicElement {
    public int direction;

    public LineElement(String name, int x, int y, int width, int height) {
        this(name, x, y, width, height, 0);
    }

    public LineElement(String name, int x, int y, int width, int height, int direction) {
        super(name, x, y, width, height);
        this.direction = direction;
        this.eletype = 5;
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderColor(Styles.Position.LEFT, Color.black);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        this.ssa = Styles.getSSA((StyleAttributes)sa);
        this.style = Styles.getStyle((ShareStyleAttributes)this.ssa);
    }

    @Override
    public void drawObject(Graphics2D g, double zoom_factor) {
        this.zoom_factor = zoom_factor;
        Point a = new Point(this.getZoomedDim(this.position.x - 10) + 10, this.getZoomedDim(this.position.y - 10) + 10);
        Point b = new Point(this.getZoomedDim(this.position.x + this.width - 10) + 10, this.getZoomedDim(this.position.y + this.height - 10) + 10);
        if (this.direction != 0) {
            b.y = this.getZoomedDim(this.position.y - 10) + 10;
            a.y = this.getZoomedDim(this.position.y + this.height - 10) + 10;
        }
        g.setColor(this.style.getBorderColor(Styles.Position.LEFT));
        Stroke stroke = this.style.getStroke(Styles.Position.LEFT);
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.drawLine(a.x, a.y, b.x, b.y);
        g.setStroke(oldStroke);
    }

    public void drawBorder(Graphics2D g, double zoom_factor, int x_shift_origin) {
    }

    @Override
    public ReportElement cloneMe() {
        LineElement newReportElement = new LineElement(this.name, 0, 0, this.width, this.height);
        newReportElement.direction = this.direction;
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.firePropertyChange(null);
    }

    @Override
    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof LineElement && source instanceof LineElement) {
            ((LineElement)destination).setDirection(((LineElement)source).getDirection());
        }
    }
}

