/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.config;

import com.kingdee.bos.ctrl.kdf.data.config.DBInfo;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public final class DBConfig {
    private File configFile;
    private Document doc;
    private Element root;
    private HashMap infoMap;
    private DBInfo[] dbis;

    public DBConfig(String fileName) {
        this.configFile = new File(fileName);
        if (!this.configFile.exists()) {
            throw new RuntimeException("Can not find Config file: " + fileName);
        }
        this.loadFile();
    }

    public DBInfo getDBInfo(String id) {
        return (DBInfo)this.infoMap.get(id);
    }

    public DBInfo getDBInfo(int idx) {
        if (this.dbis == null) {
            this.dbis = this.infoMap.values().toArray(new DBInfo[0]);
        }
        if (idx < 0 || idx >= this.dbis.length) {
            return null;
        }
        return this.dbis[idx];
    }

    public int getDBInfoSize() {
        return this.infoMap.size();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFile() {
        FileInputStream fis = null;
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            fis = new FileInputStream(this.configFile);
            this.doc = builder.build(new InputSource(fis));
        }
        catch (JDOMException err) {
            try {
                throw new RuntimeException("Error on analysis XML file, info: " + err.getMessage());
                catch (IOException err2) {
                    throw new RuntimeException("Failed loading file");
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
        this.root = this.doc.getRootElement();
        this.infoMap = new HashMap();
        List dbconns = this.root.getChildren("DBConnection");
        if (dbconns.size() > 0) {
            for (int i = 0; i < dbconns.size(); ++i) {
                Element ele = (Element)dbconns.get(i);
                DBInfo dbi = new DBInfo();
                dbi.id = ele.getAttributeValue("id");
                dbi.connection = ele.getChildText("Connection");
                dbi.dbType = ele.getChildText("DBType");
                dbi.driver = ele.getChildText("Driver");
                dbi.user = ele.getChildText("User");
                dbi.pwd = ele.getChildText("Password");
                this.infoMap.put(dbi.id, dbi);
            }
            return;
        } else {
            DBInfo dbi = new DBInfo();
            dbi.id = "default";
            dbi.connection = this.root.getChildText("Connection");
            dbi.dbType = this.root.getChildText("DBType");
            dbi.driver = this.root.getChildText("Driver");
            dbi.user = this.root.getChildText("User");
            dbi.pwd = this.root.getChildText("Password");
            this.infoMap.put(dbi.id, dbi);
        }
    }
}

