/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.impl;

import com.kingdee.bos.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.bos.ctrl.kdf.data.config.DBInfo;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.event.RequestDataListener;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.BaseDataSetWrapper;
import com.kingdee.bos.ctrl.kdf.data.impl.RowSetVisitor;
import com.kingdee.bos.ctrl.kdf.data.param.ReportParam;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jdom2.Element;

public final class DataSetWrapperFactory {
    private HashMap bizGroup;
    private EventListenerList listenerList = new EventListenerList();
    private ArrayList dsList = new ArrayList();
    private DBInfo[] extraInfo;

    public DataSetWrapperFactory() {
        this.bizGroup = new HashMap();
    }

    public DataSetWrapperFactory(List dsNodes, KDF kdf) {
        this(dsNodes, null, kdf);
    }

    public DataSetWrapperFactory(List dsNodes, DBInfo[] extraInfo, KDF kdf) {
        this.extraInfo = extraInfo;
        if (dsNodes == null) {
            this.bizGroup = new HashMap();
        } else {
            int size = dsNodes.size();
            this.bizGroup = new HashMap(size);
            for (int i = 0; i < size; ++i) {
                DataSource ds = DataSource.buildFromNode((Element)dsNodes.get(i), kdf);
                this.addDataSource(ds);
            }
            this.contact();
        }
    }

    public void setExtraDBInfo(DBInfo[] info) {
        this.extraInfo = info;
    }

    private void contact() {
        for (DataSetWrapper biz : this.bizGroup.values()) {
            int count = biz.getDSParamCount();
            HashMap<String, String> parent = new HashMap<String, String>(count);
            for (int i = 0; i < count; ++i) {
                String id = biz.getDSParam(i).getAssociateSource();
                parent.put(id, id);
            }
            for (String parentID : parent.values()) {
                DataSetWrapper bizParent = (DataSetWrapper)this.bizGroup.get(parentID);
                if (bizParent == null) continue;
                bizParent.addMasterDataSetListener(biz);
            }
        }
    }

    public DataSetWrapper[] getDataSetWrappers() {
        return this.bizGroup.values().toArray(new DataSetWrapper[0]);
    }

    public DataSetWrapper getDataSetWrapper(String id) {
        return (DataSetWrapper)this.bizGroup.get(id);
    }

    public DataSetWrapper getDataSetWrapper(int index) {
        if (index < 0 || index >= this.bizGroup.size()) {
            return null;
        }
        return (DataSetWrapper)this.bizGroup.values().toArray()[index];
    }

    public boolean addDataSource(DataSource ds) {
        Object o = this.bizGroup.get(ds.getID());
        if (o != null) {
            return false;
        }
        this.dsList.add(ds);
        BaseDataSetWrapper biz = new BaseDataSetWrapper(ds, this.extraInfo);
        String id = biz.getID();
        this.bizGroup.put(id, biz);
        this.contact();
        return true;
    }

    public String save() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.dsList.size(); ++i) {
            sb.append(((DataSource)this.dsList.get(i)).writeToNode().getText());
        }
        return sb.toString();
    }

    public void requestData(String dataSourceID, String queryName, String[] fields, int oper, Object param1, Object param2) {
        DataSetWrapper o = this.getDataSetWrapper(dataSourceID);
        if (null == o) {
            return;
        }
        RequestRowSetEvent e = new RequestRowSetEvent(o, dataSourceID, queryName, fields, oper, param1, param2);
        this.fireRequestRowSet(e);
        IRowSet rowset = e.getRowSet();
        if (rowset != null) {
            RowSetVisitor visitor = new RowSetVisitor(rowset);
            o.changeDataSource(visitor);
        }
    }

    private void fireRequestRowSet(RequestRowSetEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RequestRowSetListener.class) continue;
            ((RequestRowSetListener)listeners[i + 1]).doRequestRowSet(e);
        }
    }

    public void addRequestRowSetListener(RequestRowSetListener requestRowSetListener) {
        this.listenerList.add(RequestRowSetListener.class, requestRowSetListener);
    }

    public void removeRequestRowSetListener(RequestRowSetListener requestRowSetListener) {
        this.listenerList.remove(RequestRowSetListener.class, requestRowSetListener);
    }

    public EventListener[] getRequestRowSetListeners() {
        return this.listenerList.getListeners(RequestRowSetListener.class);
    }

    public void addRequesetDataListener(String id, RequestDataListener listener) {
        DataSetWrapper o = this.getDataSetWrapper(id);
        if (o instanceof BaseDataSetWrapper) {
            ((BaseDataSetWrapper)o).addRequestDataListener(listener);
        }
    }

    public void setCommonParams(ReportParam[] params) {
        DataSetWrapper[] os = this.getDataSetWrappers();
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof BaseDataSetWrapper)) continue;
            ((BaseDataSetWrapper)os[i]).setCommonParams(params);
        }
    }
}

