/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.pool;

import com.kingdee.bos.ctrl.kdf.data.exception.BlockIsBusyException;
import com.kingdee.bos.ctrl.kdf.data.exception.BlockIsExistsException;
import com.kingdee.bos.ctrl.kdf.data.exception.BlockNotFoundException;
import com.kingdee.bos.ctrl.kdf.data.exception.TaskInvalidException;
import com.kingdee.bos.ctrl.kdf.data.exception.TaskNotFoundException;
import com.kingdee.bos.ctrl.kdf.data.pool.CacheManager;
import com.kingdee.bos.ctrl.kdf.data.pool.DataPoolProperties;

public class DataPoolProvider {
    private DataPoolProperties prop = DataPoolProperties.getInstance();
    private CacheManager cmanager;

    public DataPoolProvider() {
        this.prop.setFilePath(System.getProperty("java.io.tmpdir"));
        this.cmanager = new CacheManager();
    }

    public DataPoolProvider(String path) {
        this.prop.setFilePath(path);
        this.cmanager = new CacheManager();
    }

    public byte[] read(int taskID, int blockID) throws BlockNotFoundException, TaskInvalidException, TaskNotFoundException, BlockIsBusyException {
        return this.cmanager.readBlock(taskID, blockID);
    }

    public byte[][] read(int taskID) throws TaskInvalidException, TaskNotFoundException {
        return this.cmanager.readBlock(taskID);
    }

    public void write(int taskID, int blockID, byte[] block) throws TaskNotFoundException, BlockIsExistsException, TaskInvalidException {
        this.cmanager.writeBlock(taskID, blockID, block);
    }

    public void clear(int taskID, int blockID) {
        this.cmanager.delete(taskID, blockID);
    }

    public void clear(int taskID) {
        this.cmanager.delete(taskID);
    }

    public int requireTask() {
        return this.cmanager.newTask();
    }

    public int requireTask(int validTime) {
        return this.cmanager.newTask(validTime);
    }
}

