/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.export;

import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.kml.BookToKml;
import com.kingdee.bos.ctrl.kdf.export.CsvExporter;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.HtmlExporter;
import com.kingdee.bos.ctrl.kdf.export.KDSBookToBook;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.export.POIXlsExporter;
import com.kingdee.bos.ctrl.kdf.export.PdfExporter;
import com.kingdee.bos.ctrl.kdf.export.RtfExporter;
import com.kingdee.bos.ctrl.kdf.export.RtfExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.XlsExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.direct.ImageExporter;
import com.kingdee.bos.ctrl.kdf.export.direct.PdfExporter2;
import com.kingdee.bos.ctrl.kdf.export.direct.RtfExporter2;
import com.kingdee.bos.ctrl.kdf.form.PageCollection;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import java.awt.print.Printable;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public final class ExportManager {
    HashMap parametermap = new HashMap();
    private boolean noPrint = false;

    public void setExporterParmeter(ExporterParameter parameter, Object ob) {
        this.parametermap.put(parameter, ob);
    }

    public void CleanExporterParmeter() {
        this.parametermap.clear();
    }

    public void exportToPdfFile(PrintableBook book, String destFileName) {
        PdfExporter exporter = new PdfExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        exporter.export();
    }

    public void exportToPdfStream(PrintableBook book, OutputStream outputStream) {
        PdfExporter exporter = new PdfExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.export();
    }

    public void exportToPdfFile2(Printable printable, String destFileName) {
        PdfExporter2 exporter = new PdfExporter2();
        exporter.setParameter(ExporterParameter.PRINTABLE, printable);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }

    public void exportToExcel(PrintableBook book, String destName) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        try {
            exporter.export();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exportToExcelStream(PrintableBook book, OutputStream outputStream) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        try {
            exporter.export();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
    }

    public void exportToExcelStream(KDSBook book, OutputStream outputStream) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KDS_BOOK, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        try {
            exporter.exportKDS();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
    }

    public void exportToSpreadSheet(KDSBook book, String destName) {
        BookToKml btk = new BookToKml();
        BookIOController bc = new BookIOController();
        bc.setForExcel(true);
        btk.setBookIOController(bc);
        try {
            btk.export(KDSBookToBook.traslate(book), destName);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exportToExcel(KDSBook book, String destName) {
        POIXlsExporter exporter = new POIXlsExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KDS_BOOK, book);
        this.noPrint = true;
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        try {
            exporter.exportKDS();
        }
        catch (Exception e) {
            throw new POIExportException(e.getMessage(), e.getCause());
        }
        this.noPrint = false;
    }

    public boolean isetPrintInfo() {
        return this.noPrint;
    }

    public void exportToCsv(PrintableBook book, String destName) {
        CsvExporter exporter = new CsvExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destName);
        exporter.setParameter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);
        exporter.export();
    }

    public void exportToCsvStream(PrintableBook book, OutputStream outputStream) {
        CsvExporter exporter = new CsvExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.setParameter(XlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.TRUE);
        exporter.export();
    }

    public byte[] exportToPdf(PrintableBook book) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfExporter exporter = new PdfExporter();
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, baos);
        exporter.export();
        return baos.toByteArray();
    }

    public String[] exportToHtmlFile(PrintableBook book, String destFileName) {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
        return (String[])exporter.getParameter(ExporterParameter.IMAGE_FILE_NAMES);
    }

    public void exportToHtmlStream(PrintableBook book, OutputStream outputStream) {
        HtmlExporter exporter = new HtmlExporter();
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }

    public void exportToRtfFile(PrintableBook book, String destFileName) {
        RtfExporter exporter = new RtfExporter();
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }

    public void exportToRtfStream(PrintableBook book, OutputStream outputStream) {
        RtfExporter exporter = new RtfExporter();
        exporter.setParameter(ExporterParameter.KD_Print, book);
        exporter.setParameter(RtfExporterParameter.IS_OUTTABLE, Boolean.TRUE);
        exporter.setParameter(ExporterParameter.OUTPUT_STREAM, outputStream);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }

    public void exportToRtfFile2(PageCollection pc, String destFileName) {
        RtfExporter2 exporter = new RtfExporter2();
        exporter.setParameter(ExporterParameter.PAGE_COLLECTION, pc);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }

    public void exportToImageFile(Printable printable, String destFileName) {
        ImageExporter exporter = new ImageExporter();
        exporter.setParameter(ExporterParameter.PRINTABLE, printable);
        exporter.setParameter(ExporterParameter.OUTPUT_FILE_NAME, destFileName);
        for (ExporterParameter parameter : this.parametermap.keySet()) {
            exporter.setParameter(parameter, this.parametermap.get(parameter));
        }
        exporter.export();
    }
}

