/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.Column;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.EntityInfo;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.FormBuilder;
import com.kingdee.bos.ctrl.kdf.form.FuncImpl;
import com.kingdee.bos.ctrl.kdf.form.Layer;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Property;
import com.kingdee.bos.ctrl.kdf.form.PropertyCollection;
import com.kingdee.bos.ctrl.kdf.form.Row;
import com.kingdee.bos.ctrl.kdf.form.RuntimeServiceProvider;
import com.kingdee.bos.ctrl.kdf.form.RuntimeStyleService;
import com.kingdee.bos.ctrl.kdf.form.Style;
import com.kingdee.bos.ctrl.kdf.form.StyleCollection;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jdom2.Element;

public final class BaseFormBuilder
implements FormBuilder {
    private HashMap pageBuffer;
    private HashMap styleBuffer;
    private RuntimeStyleService stsvs;
    private boolean snapMode = false;
    private boolean designMode = false;

    @Override
    public Form createForm(RuntimeServiceProvider sp, Element formElement) {
        this.stsvs = sp.getRuntimeStyleService();
        this.initParse();
        Form fm = this.parseForm(formElement);
        if (fm != null) {
            fm.setRuntimeServiceProvider(sp);
        }
        return fm;
    }

    public Page createPage(RuntimeStyleService rss, Element pageElement) {
        this.stsvs = rss;
        this.initParse();
        if (pageElement != null) {
            return (Page)this.parsePureElement(null, null, null, pageElement);
        }
        return null;
    }

    public Container createContainer(RuntimeStyleService rss, Element contElement) {
        this.stsvs = rss;
        this.initParse();
        if (contElement != null) {
            return this.parsePureElement(null, null, null, contElement);
        }
        return null;
    }

    private void initParse() {
        this.pageBuffer = new HashMap();
        this.styleBuffer = new HashMap();
    }

    private void sortChildren(Container parent) {
        if (parent != null) {
            ArrayList srcList = parent.innerList();
            Object[] srcs = srcList.toArray(new Container[0]);
            Arrays.sort(srcs);
            srcList.clear();
            for (int i = 0; i < srcs.length; ++i) {
                srcList.add(srcs[i]);
            }
        }
    }

    private PropertyCollection parsePureProperties(Element elem) {
        PropertyCollection pc = PropertyCollection.getEmptyPropertyCollection();
        if (elem != null) {
            for (Element el : elem.getChildren()) {
                String nm;
                if (!el.getName().equalsIgnoreCase("Property") || (nm = el.getAttributeValue("name")) == null) continue;
                Property pt = new Property(nm, el.getAttributeValue("type"), el.getTextTrim());
                pc = pc.add(pt);
            }
        }
        return pc;
    }

    private Collection[] parseProperties(Element elem) {
        PropertyCollection pc = PropertyCollection.getEmptyPropertyCollection();
        StyleCollection sc = StyleCollection.getEmptyStyleCollection();
        if (elem != null) {
            for (Element el : elem.getChildren()) {
                String nm;
                if (!el.getName().equalsIgnoreCase("Property") || (nm = el.getAttributeValue("name")) == null) continue;
                String tp = el.getAttributeValue("type");
                if (tp != null && tp.equalsIgnoreCase("style")) {
                    sc = sc.add(new Style(nm, el.getTextTrim()));
                    continue;
                }
                pc = pc.add(new Property(nm, el.getAttributeValue("type"), el.getTextTrim()));
            }
        }
        return new Collection[]{sc, pc};
    }

    private Form parseForm(Element elem) {
        Form fom = null;
        if (elem.getName().equalsIgnoreCase("Form")) {
            fom = new Form();
            fom.setId(elem.getAttributeValue("id"));
            fom.setUserAlias(elem.getAttributeValue("alias"));
            fom.setHeaderID(elem.getAttributeValue("headerID"));
            fom.setFooterID(elem.getAttributeValue("footerID"));
            Element dsn = elem.getChild("DesignedForm", KDFXmlReader.NS_FORM);
            if (dsn != null) {
                fom.setUserObject(dsn.clone());
            }
            for (Element el : elem.getChildren()) {
                if (el.getName().equalsIgnoreCase("Page")) {
                    this.parsePureElement(fom, null, null, el);
                    continue;
                }
                if (el.getName().equalsIgnoreCase("Layers")) {
                    for (Element lel : el.getChildren()) {
                        if (!lel.getName().equalsIgnoreCase("Layer")) continue;
                        Layer lay = new Layer();
                        lay.setId(lel.getAttributeValue("id"));
                        lay.setAlias(lel.getAttributeValue("alias"));
                        lay.setCategory(lel.getAttributeValue("category"));
                        lay.setStyleID(lel.getAttributeValue("styleID"));
                        fom.getLayers().add(lay);
                    }
                    continue;
                }
                if (!el.getName().equalsIgnoreCase("Properties")) continue;
                fom.setProperties(this.parsePureProperties(el));
            }
        } else {
            throw new AssertionError((Object)"Not a valid form element");
        }
        return fom;
    }

    private Container parsePureElement(Form currentForm, Container currentParent, Page currentPage, Element elem) {
        ShareStyleAttributes ssa;
        String attr;
        Element cdsn;
        if (elem.getName().equalsIgnoreCase("Properties")) {
            Collection[] colls = this.parseProperties(elem);
            if (currentParent != null) {
                currentParent.setCustomStyles((StyleCollection)colls[0]);
                currentParent.setProperties((PropertyCollection)colls[1]);
            }
            return null;
        }
        if (elem.getName().equalsIgnoreCase("Page") || elem.getName().equalsIgnoreCase("Header") || elem.getName().equalsIgnoreCase("Footer")) {
            Page pg;
            if (this.pageBuffer.containsKey(elem.getAttributeValue("id"))) {
                pg = (Page)this.pageBuffer.remove(elem.getAttributeValue("id"));
            } else {
                pg = new Page();
                pg.setId(elem.getAttributeValue("id"));
            }
            pg.setUserAlias(elem.getAttributeValue("alias"));
            cdsn = elem.getChild("DesignedPage", KDFXmlReader.NS_FORM);
            if (cdsn != null) {
                pg.setUserObject(cdsn.clone());
            } else {
                cdsn = elem.getChild("DesignedHeader", KDFXmlReader.NS_FORM);
                if (cdsn != null) {
                    pg.setUserObject(cdsn.clone());
                } else {
                    cdsn = elem.getChild("DesignedFooter", KDFXmlReader.NS_FORM);
                    if (cdsn != null) {
                        pg.setUserObject(cdsn.clone());
                    }
                }
            }
            pg.getLeft().setString(elem.getAttributeValue("left"));
            pg.getRight().setString(elem.getAttributeValue("right"));
            pg.getTop().setString(elem.getAttributeValue("top"));
            pg.getBottom().setString(elem.getAttributeValue("bottom"));
            pg.syncOriginString();
            pg.group().setDataSource(elem.getAttributeValue("dataSourceID"));
            pg.setVisibility(new EntityInfo(elem.getAttributeValue("visible")));
            pg.setHoldPlace(new EntityInfo(elem.getAttributeValue("holdPlace")));
            pg.setPreSteps(elem.getAttributeValue("preMacro"));
            pg.setPostSteps(elem.getAttributeValue("postMacro"));
            pg.setAnchor(elem.getAttributeValue("anchor"));
            pg.setHint(elem.getAttributeValue("hint"));
            attr = elem.getAttributeValue("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                pg.setStyles(ssa);
            }
            if ((attr = elem.getAttributeValue("repeat")) != null) {
                pg.setRepeat(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttributeValue("layerID")) != null) {
                pg.setLayer(attr);
            }
            pg.setParent(pg);
            if (pg.getId() != null) {
                pg.getIdTable().put(pg.getId(), pg);
            }
            currentPage = pg;
            currentParent = pg;
            if (currentForm != null) {
                currentForm.getPages().add(pg);
                pg.setForm(currentForm);
            }
        } else if (elem.getName().equalsIgnoreCase("Area")) {
            String nt;
            Area ara;
            if (currentPage != null && currentPage.getIdTable().containsKey(elem.getAttributeValue("id"))) {
                ara = (Area)currentPage.getIdTable().get(elem.getAttributeValue("id"));
            } else {
                ara = new Area();
                ara.setId(elem.getAttributeValue("id"));
                if (ara.getId() != null && currentPage != null) {
                    currentPage.getIdTable().put(ara.getId(), ara);
                }
            }
            ara.setUserAlias(elem.getAttributeValue("alias"));
            cdsn = elem.getChild("DesignedArea", KDFXmlReader.NS_FORM);
            if (cdsn != null) {
                ara.setUserObject(cdsn.clone());
            }
            ara.getLeft().setString(elem.getAttributeValue("left"));
            ara.getRight().setString(elem.getAttributeValue("right"));
            ara.getTop().setString(elem.getAttributeValue("top"));
            ara.getBottom().setString(elem.getAttributeValue("bottom"));
            ara.syncOriginString();
            ara.setVisibility(new EntityInfo(elem.getAttributeValue("visible")));
            ara.setHoldPlace(new EntityInfo(elem.getAttributeValue("holdPlace")));
            ara.setPreSteps(elem.getAttributeValue("preMacro"));
            ara.setPostSteps(elem.getAttributeValue("postMacro"));
            ara.setAnchor(elem.getAttributeValue("anchor"));
            ara.setHint(elem.getAttributeValue("hint"));
            attr = elem.getAttributeValue("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                ara.setStyles(ssa);
            }
            if ((attr = elem.getAttributeValue("layerID")) != null) {
                ara.setLayer(attr);
            }
            if ((attr = elem.getAttributeValue("priority")) != null && FuncImpl.isInteger(attr)) {
                ara.setPriority(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttributeValue("minLoopCount")) != null && FuncImpl.isInteger(attr)) {
                ara.setMinLoopCount(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttributeValue("maxLoopCount")) != null && FuncImpl.isInteger(attr)) {
                ara.setMaxLoopCount(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttributeValue("verticalSpacing")) != null) {
                ara.setVerticalSpacing(attr);
            } else {
                ara.setVerticalSpacing("0");
            }
            attr = elem.getAttributeValue("horizontalSpacing");
            if (attr != null) {
                ara.setHorizontalSpacing(attr);
            } else {
                ara.setHorizontalSpacing("0");
            }
            if (currentParent != null) {
                currentParent.addChild(ara);
                ara.setParent(currentParent);
            }
            if (!this.snapMode && (nt = elem.getAttributeValue("nextAreaID")) != null && currentPage != null) {
                Area arb = null;
                if (nt.indexOf(".") == -1) {
                    if (currentPage.getIdTable().containsKey(nt)) {
                        arb = (Area)currentPage.getIdTable().get(nt);
                    } else {
                        arb = new Area();
                        arb.setId(nt);
                        currentPage.getIdTable().put(nt, arb);
                    }
                } else if (currentForm != null) {
                    String pName = nt.substring(0, nt.indexOf("."));
                    String aName = nt.substring(nt.indexOf(".") + 1);
                    Page pg = currentForm.getPages().get(pName);
                    if (pg != null) {
                        if (pg.getIdTable().containsKey(aName)) {
                            arb = (Area)pg.getIdTable().get(aName);
                        } else {
                            arb = new Area();
                            arb.setId(aName);
                            if (aName != null) {
                                pg.getIdTable().put(aName, arb);
                            }
                        }
                    } else if (this.pageBuffer.containsKey(pName)) {
                        pg = (Page)this.pageBuffer.get(pName);
                        if (pg.getIdTable().containsKey(aName)) {
                            arb = (Area)pg.getIdTable().get(aName);
                        } else {
                            arb = new Area();
                            arb.setId(aName);
                            if (aName != null) {
                                pg.getIdTable().put(aName, arb);
                            }
                        }
                    } else {
                        pg = new Page();
                        pg.setId(pName);
                        this.pageBuffer.put(pName, pg);
                        arb = new Area();
                        arb.setId(aName);
                        if (aName != null) {
                            pg.getIdTable().put(aName, arb);
                        }
                    }
                }
                ara.setNext(arb);
                if (null != arb) {
                    arb.setPrevious(ara);
                }
            }
            currentParent = ara;
        } else if (elem.getName().equalsIgnoreCase("Panel")) {
            Panel pnl = new Panel();
            pnl.setId(elem.getAttributeValue("id"));
            pnl.setUserAlias(elem.getAttributeValue("alias"));
            cdsn = elem.getChild("DesignedPanel", KDFXmlReader.NS_FORM);
            if (cdsn != null) {
                pnl.setUserObject(cdsn.clone());
            }
            pnl.group().setDataSource(elem.getAttributeValue("dataSourceID"));
            pnl.group().setField(elem.getAttributeValue("groupField"));
            if (!(this.snapMode || this.designMode || !(currentParent instanceof Area) || pnl.group().getDataSource() != null && pnl.group().getDataSource().length() != 0)) {
                return null;
            }
            pnl.getLeft().setString(elem.getAttributeValue("left"));
            pnl.getRight().setString(elem.getAttributeValue("right"));
            pnl.getTop().setString(elem.getAttributeValue("top"));
            pnl.getBottom().setString(elem.getAttributeValue("bottom"));
            pnl.syncOriginString();
            pnl.setVisibility(new EntityInfo(elem.getAttributeValue("visible")));
            pnl.setHoldPlace(new EntityInfo(elem.getAttributeValue("holdPlace")));
            pnl.setPreSteps(elem.getAttributeValue("preMacro"));
            pnl.setPostSteps(elem.getAttributeValue("postMacro"));
            pnl.setAnchor(elem.getAttributeValue("anchor"));
            pnl.setHint(elem.getAttributeValue("hint"));
            attr = elem.getAttributeValue("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                pnl.setStyles(ssa);
            }
            if ((attr = elem.getAttributeValue("layerID")) != null) {
                pnl.setLayer(attr);
            }
            if ((attr = elem.getAttributeValue("priority")) != null && FuncImpl.isInteger(attr)) {
                pnl.setPriority(Integer.parseInt(attr));
            }
            if (currentParent != null) {
                currentParent.addChild(pnl);
                pnl.setParent(currentParent);
            }
            if (pnl.getId() != null && currentPage != null) {
                currentPage.getIdTable().put(pnl.getId(), pnl);
            }
            currentParent = pnl;
        } else if (elem.getName().equalsIgnoreCase("Table")) {
            Table tab = new Table();
            tab.setId(elem.getAttributeValue("id"));
            tab.setUserAlias(elem.getAttributeValue("alias"));
            cdsn = elem.getChild("DesignedTable", KDFXmlReader.NS_FORM);
            if (cdsn != null) {
                tab.setUserObject(cdsn.clone());
            }
            tab.group().setDataSource(elem.getAttributeValue("dataSourceID"));
            tab.group().setField(elem.getAttributeValue("groupField"));
            if (!(this.snapMode || this.designMode || !(currentParent instanceof Area) || tab.group().getDataSource() != null && tab.group().getDataSource().length() != 0)) {
                return null;
            }
            tab.getLeft().setString(elem.getAttributeValue("left"));
            tab.getRight().setString(elem.getAttributeValue("right"));
            tab.getTop().setString(elem.getAttributeValue("top"));
            tab.getBottom().setString(elem.getAttributeValue("bottom"));
            tab.syncOriginString();
            tab.setVisibility(new EntityInfo(elem.getAttributeValue("visible")));
            tab.setHoldPlace(new EntityInfo(elem.getAttributeValue("holdPlace")));
            tab.setPreSteps(elem.getAttributeValue("preMacro"));
            tab.setPostSteps(elem.getAttributeValue("postMacro"));
            tab.setAnchor(elem.getAttributeValue("anchor"));
            tab.setHint(elem.getAttributeValue("hint"));
            attr = elem.getAttributeValue("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                tab.setStyles(ssa);
            }
            if ((attr = elem.getAttributeValue("layerID")) != null) {
                tab.setLayer(attr);
            }
            if ((attr = elem.getAttributeValue("priority")) != null && FuncImpl.isInteger(attr)) {
                tab.setPriority(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttributeValue("layout")) != null) {
                if (attr.equalsIgnoreCase("auto") || attr.equals("0")) {
                    tab.setLayoutMode(0);
                } else {
                    tab.setLayoutMode(1);
                }
            }
            if (currentParent != null) {
                currentParent.addChild(tab);
                tab.setParent(currentParent);
            }
            if (tab.getId() != null && currentPage != null) {
                currentPage.getIdTable().put(tab.getId(), tab);
            }
            currentParent = tab;
        } else {
            if (elem.getName().equalsIgnoreCase("Row")) {
                if (currentParent instanceof Table) {
                    String attr2;
                    Row row = new Row();
                    Table tab = (Table)currentParent;
                    tab.getRows().add(row);
                    if (tab.getLayoutMode() > 0) {
                        row.getHeight().setString(elem.getAttributeValue("height"));
                        row.getHeight().setOriginString(row.getHeight().getString());
                    }
                    if ((attr2 = elem.getAttributeValue("styleID")) != null) {
                        ShareStyleAttributes ssa2 = null;
                        if (this.styleBuffer.containsKey(attr2)) {
                            ssa2 = (ShareStyleAttributes)this.styleBuffer.get(attr2);
                        } else {
                            ssa2 = this.stsvs.getStyleAttributes(attr2);
                            this.styleBuffer.put(attr2, ssa2);
                        }
                        row.setStyles(ssa2);
                    }
                }
                return null;
            }
            if (elem.getName().equalsIgnoreCase("Column")) {
                if (currentParent instanceof Table) {
                    String attr3;
                    Column col = new Column();
                    Table tab = (Table)currentParent;
                    tab.getCols().add(col);
                    if (tab.getLayoutMode() > 0) {
                        col.getWidth().setString(elem.getAttributeValue("width"));
                        col.getWidth().setOriginString(col.getWidth().getString());
                    }
                    if ((attr3 = elem.getAttributeValue("styleID")) != null) {
                        ShareStyleAttributes ssa3 = null;
                        if (this.styleBuffer.containsKey(attr3)) {
                            ssa3 = (ShareStyleAttributes)this.styleBuffer.get(attr3);
                        } else {
                            ssa3 = this.stsvs.getStyleAttributes(attr3);
                            this.styleBuffer.put(attr3, ssa3);
                        }
                        col.setStyles(ssa3);
                    }
                }
                return null;
            }
            if (elem.getName().equalsIgnoreCase("Cell")) {
                Cell cel = new Cell();
                cel.setId(elem.getAttributeValue("id"));
                cel.setUserAlias(elem.getAttributeValue("alias"));
                cdsn = elem.getChild("DesignedCell", KDFXmlReader.NS_FORM);
                if (cdsn != null) {
                    cel.setUserObject(cdsn.clone());
                }
                cel.setClipContent(elem.getAttributeValue("clip"));
                cel.getLeft().setString(elem.getAttributeValue("left"));
                cel.getRight().setString(elem.getAttributeValue("right"));
                cel.getTop().setString(elem.getAttributeValue("top"));
                cel.getBottom().setString(elem.getAttributeValue("bottom"));
                cel.syncOriginString();
                cel.setVisibility(new EntityInfo(elem.getAttributeValue("visible")));
                cel.setHoldPlace(new EntityInfo(elem.getAttributeValue("holdPlace")));
                cel.setPreSteps(elem.getAttributeValue("preMacro"));
                cel.setPostSteps(elem.getAttributeValue("postMacro"));
                cel.setAnchor(elem.getAttributeValue("anchor"));
                cel.setHint(elem.getAttributeValue("hint"));
                cel.setType(elem.getAttributeValue("type"));
                cel.setDataFormat(elem.getAttributeValue("format"));
                attr = elem.getAttributeValue("styleID");
                if (attr != null) {
                    ssa = null;
                    if (this.styleBuffer.containsKey(attr)) {
                        ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                    } else {
                        ssa = this.stsvs.getStyleAttributes(attr);
                        this.styleBuffer.put(attr, ssa);
                    }
                    cel.setStyles(ssa);
                }
                if ((attr = elem.getAttributeValue("layerID")) != null) {
                    cel.setLayer(attr);
                }
                if ((attr = elem.getAttributeValue("priority")) != null && FuncImpl.isInteger(attr)) {
                    cel.setPriority(Integer.parseInt(attr));
                }
                if (currentParent != null) {
                    currentParent.addChild(cel);
                    cel.setParent(currentParent);
                }
                if (cel.getId() != null && currentPage != null) {
                    currentPage.getIdTable().put(cel.getId(), cel);
                }
                DivideCharacter dc = DivideCharacter.load(elem);
                cel.setDivideCharacter(dc);
                currentParent = cel;
            } else if (elem.getName().equalsIgnoreCase("Data")) {
                if (currentParent instanceof Cell) {
                    Data data = new Data();
                    data.setType(elem.getAttributeValue("type"));
                    data.setFormat(elem.getTextTrim());
                    Cell cel = (Cell)currentParent;
                    cel.setData(data);
                }
                return null;
            }
        }
        for (Element el : elem.getChildren()) {
            this.parsePureElement(currentForm, currentParent, currentPage, el);
        }
        this.sortChildren(currentParent);
        return currentParent;
    }

    public void setSnapMode(boolean snapMode) {
        this.snapMode = snapMode;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }
}

