/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.ChartData;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.Group;
import com.kingdee.bos.ctrl.kdf.form.NameHelper;
import com.kingdee.bos.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.bos.ctrl.kdf.util.NullIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public final class Cell
extends Container
implements Serializable {
    private static final long serialVersionUID = -6759612919229295803L;
    private String type;
    private Data data;
    private String dataFormat;
    private String groupId;
    private String clipContent;
    private int groupNum;
    private static final NullIterator NULLITERATOR = new NullIterator();
    private static final ArrayList ZEROLIST = new ArrayList(0);
    private DivideCharacter divideCharacter;
    public static final String TYPE_CONSTANT = "constant";
    public static final String TYPE_FIELD = "field";
    public static final String TYPE_FORMULA = "formula";
    public static final String TYPE_VARIANT = "variant";
    public static final String TYPE_GROUPFIELD = "groupField";
    public static final String TYPE_GROUPTOTAL = "groupTotal";
    public static final String TYPE_AREATOTAL = "areaTotal";
    public static final String TYPE_HORIZONTALBREAK = "horizontalBreak";
    public static final String TYPE_VERTICALBREAK = "verticalBreak";
    public static final String TYPE_CHART = "chart";

    public Cell() {
        this(TYPE_CONSTANT);
    }

    public Cell(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String val) {
        this.type = val;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data val) {
        this.data = val;
    }

    @Override
    public void syncDataForSnap() {
        if (this.data != null) {
            if (TYPE_CHART.equals(this.data.getType())) {
                this.data.setValue(new Variant((Object)ChartData.valueOf(this.data.getFormat(), null)));
            } else {
                this.data.setValue(new Variant((Object)this.data.getFormat(), 11));
            }
        }
        super.syncDataForSnap();
    }

    @Override
    public boolean addChild(Container child) {
        return true;
    }

    @Override
    public boolean deleteChild(Container child) {
        return true;
    }

    @Override
    public Iterator iterator() {
        return NULLITERATOR;
    }

    @Override
    public Group group() {
        return null;
    }

    @Override
    public Container nextCopy() {
        return null;
    }

    @Override
    public Container copyTo(Container parent, boolean copyEdge) {
        Cell cel = new Cell();
        cel.setId(NameHelper.getUniqueName());
        cel.setUserAlias(this.getUserAlias());
        cel.setParent(parent);
        cel.setAliasName(this.getAliasName());
        cel.setLayer(this.getLayer());
        cel.setAnchor(this.getAnchor());
        cel.setHint(this.getHint());
        cel.setSource(this.getSource());
        cel.setStyles(this.getStyles());
        cel.copyCustomStyles(this.getCustomStyles());
        cel.copyProperties(this.getProperties());
        cel.setVisibility(this.getVisibility());
        cel.setHoldPlace(this.getHoldPlace());
        cel.setPreSteps(this.getPreSteps());
        cel.setPostSteps(this.getPostSteps());
        if (copyEdge) {
            cel.setLeft(this.getLeft());
            cel.setRight(this.getRight());
            cel.setTop(this.getTop());
            cel.setBottom(this.getBottom());
        } else {
            cel.copyOriginString(this);
        }
        if (this.parent != null) {
            String oname = "(?:\\[\\s*)" + this.parent.getId() + "\\.";
            String nname = "[" + parent.getId() + ".";
            String oname2 = "(?:\\[\\s*)" + this.getId() + "\\.";
            String nname2 = "[" + cel.getId() + ".";
            Pattern p1 = Pattern.compile(oname);
            Pattern p2 = Pattern.compile(oname2);
            if (cel.getLeft().getString() != null) {
                cel.getLeft().setString(p1.matcher(cel.getLeft().getString()).replaceAll(nname));
                cel.getLeft().setString(p2.matcher(cel.getLeft().getString()).replaceAll(nname2));
            }
            if (cel.getRight().getString() != null) {
                cel.getRight().setString(p1.matcher(cel.getRight().getString()).replaceAll(nname));
                cel.getRight().setString(p2.matcher(cel.getRight().getString()).replaceAll(nname2));
            }
            if (cel.getTop().getString() != null) {
                cel.getTop().setString(p1.matcher(cel.getTop().getString()).replaceAll(nname));
                cel.getTop().setString(p2.matcher(cel.getTop().getString()).replaceAll(nname2));
            }
            if (cel.getBottom().getString() != null) {
                cel.getBottom().setString(p1.matcher(cel.getBottom().getString()).replaceAll(nname));
                cel.getBottom().setString(p2.matcher(cel.getBottom().getString()).replaceAll(nname2));
            }
        }
        cel.setType(this.getType());
        cel.setDataFormat(this.getDataFormat());
        cel.setGroupId(this.getGroupId());
        cel.setGroupNum(this.getGroupNum());
        if (this.getData() != null) {
            cel.setData(this.getData().copy());
        }
        if (!copyEdge) {
            cel.syncOriginString();
        }
        cel.setDivideCharacter(this.getDivideCharacter());
        return cel;
    }

    @Override
    public Container copy(boolean copyEdge) {
        Cell cel = (Cell)this.copyTo(this.parent, copyEdge);
        return cel;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public int getGroupNum() {
        return this.groupNum;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public void setGroupNum(int i) {
        this.groupNum = i;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    public String getClipContent() {
        return this.clipContent;
    }

    public void setClipContent(String string) {
        this.clipContent = string;
    }

    @Override
    protected ArrayList innerList() {
        return ZEROLIST;
    }

    @Override
    public String toString() {
        return "Cell " + super.toString() + " data=" + this.data.toString();
    }

    public DivideCharacter getDivideCharacter() {
        return this.divideCharacter;
    }

    public void setDivideCharacter(DivideCharacter divideCharacter) {
        this.divideCharacter = divideCharacter;
    }
}

