/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.formbrowser2.actions.ToolbarBuilder;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.DefaultFormPageRetriver;
import com.kingdee.bos.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.BaseComponent;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ClientForm {
    public static final Logger logger = LogUtil.getLogger(ClientForm.class);
    private KDF templateKDF;
    private InputStream kdfInputStream;
    private DefaultFormPageRetriver formPageRetriver;
    private transient ClientCore clientCore;
    private ToolbarBuilder toolbarBuilder;

    public ClientForm() {
        try {
            logger.debug((Object)"ClientForm#");
            this.clientCore = new ClientCore();
            this.clientCore.initialize();
            this.formPageRetriver = this.clientCore.getFormPageRetriver();
            this.toolbarBuilder = new ToolbarBuilder(this.clientCore);
            this.clientCore.getContextOfBrowser().addContextEventListener(this.toolbarBuilder);
        }
        catch (ServiceException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }

    public void setTemplate(String kdfTempFile) throws FileNotFoundException {
        this.setTemplate(new FileInputStream(new File(FilenameUtils.normalize((String)kdfTempFile))));
    }

    public void setTemplate(InputStream templateStream) {
        this.kdfInputStream = templateStream;
    }

    public void setTemplate(KDF templateKDF) {
        this.templateKDF = templateKDF;
    }

    public void setPlugins(IServerPluginParam[] params) {
        this.formPageRetriver.setKdfPlugins(params);
    }

    public void setVariantDataListener(IVariantDataListener listener) {
        this.formPageRetriver.setKdfVariantDataListener(listener);
    }

    public void setUserFunctionProvider(Object obj) {
        this.formPageRetriver.setKdfUserFunctionProvider(obj);
    }

    public void setReportParams(HashMap params) {
        this.formPageRetriver.setKdfReportParams(params);
    }

    public Thread startRetriveData() {
        if (this.templateKDF != null) {
            return this.formPageRetriver.RequestRawPagesAsync(this.templateKDF);
        }
        if (this.kdfInputStream == null) {
            logger.error((Object)"ClientForm.startRetriveData() : \u6ca1\u6709\u5148\u8bbe\u7f6ekdf\u6587\u4ef6\uff0c\r\n\t\u7528ClientForm.setTemplate()\u8bbe\u7f6e.");
            return null;
        }
        return this.formPageRetriver.RequestRawPagesAsync(this.kdfInputStream);
    }

    public Form getForm() {
        return this.formPageRetriver.getForm();
    }

    public BaseComponent.ToolBarManager getToolBarManager() {
        return this.getClientCore().getInitializedBaseComponent().getToolbarManager();
    }

    public Thread getWorker() {
        return this.formPageRetriver.getWorker();
    }

    public DefaultFormPageRetriver getRawpages() {
        return this.formPageRetriver;
    }

    public KDPrintService getPrintService() {
        return this.clientCore.getPrintService();
    }

    public ClientCore getClientCore() {
        return this.clientCore;
    }

    public ToolbarBuilder getToolbarBuilder() {
        return this.toolbarBuilder;
    }
}

