/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Area;
import com.kingdee.bos.ctrl.kdf.form.Cell;
import com.kingdee.bos.ctrl.kdf.form.ChartData;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.Panel;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.LayerManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.ChartObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.ImageObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.LineObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.PageObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.PaneObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.TableObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.TextObject;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.log4j.Logger;

public class ClientFormPages
implements Serviceable {
    private static Logger logger = LogUtil.getPackageLogger(ClientFormPages.class);
    private TreeSet existLayers = new TreeSet();
    private ArrayList formPages = new ArrayList();
    private LayerManager layermgr;

    public void service(ServiceManager manager) throws ServiceException {
        assert (manager != null);
        this.layermgr = (LayerManager)manager.lookup("LayerManager");
    }

    public Iterator iterator() {
        return this.formPages.iterator();
    }

    public void clear() {
        this.formPages.clear();
    }

    public PageObject appendRawPage(Page rawPage) {
        FormObject pageObj = this.buildFormObjects(rawPage, null);
        this.formPages.add(pageObj);
        Object[] layerset = this.existLayers.toArray();
        for (int i = 0; i < layerset.length; ++i) {
            this.layermgr.add(layerset[i]);
        }
        return (PageObject)pageObj;
    }

    private FormObject buildFormObjects(Container cont, FormContainerObject parent) {
        if (cont.getLayer() != null) {
            this.existLayers.add(cont.getLayer());
        }
        int xpos = (int)((double)cont.getLeft().getInteger() * 0.28346456692913385);
        int ypos = (int)((double)cont.getTop().getInteger() * 0.28346456692913385);
        double cellwidth = (double)cont.getRight().getInteger() * 0.28346456692913385 - (double)xpos;
        double cellheight = (double)cont.getBottom().getInteger() * 0.28346456692913385 - (double)ypos;
        FormObject theObject = null;
        if (cont instanceof Page) {
            theObject = new PageObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
        } else if (cont instanceof Table) {
            theObject = new TableObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
        } else if (cont instanceof Panel || cont instanceof Area) {
            theObject = new PaneObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
        } else if (cont instanceof Cell && ((Cell)cont).getType().equalsIgnoreCase("constant")) {
            Variant value;
            String dataType = ((Cell)cont).getData().getType();
            if (dataType.equalsIgnoreCase("line")) {
                theObject = new LineObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
            } else if (dataType.equalsIgnoreCase("string") || ((Cell)cont).getData().getType().equalsIgnoreCase("number") || dataType.equalsIgnoreCase("unknown")) {
                theObject = new TextObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
            } else if (dataType.equalsIgnoreCase("image")) {
                value = (Variant)((Cell)cont).getData().getValue();
                if (value != null && value.getValue() != null) {
                    theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, (byte[])value.getValue(), cont, parent);
                }
            } else if (dataType.equalsIgnoreCase("embeddedImage")) {
                value = (Variant)((Cell)cont).getData().getValue();
                if (value != null && value.getValue() != null) {
                    String base64val = (String)value.getValue();
                    byte[] data = Base64.decode((String)base64val);
                    theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, data, cont, parent);
                }
            } else if (dataType.equalsIgnoreCase("linkedImage")) {
                value = (Variant)((Cell)cont).getData().getValue();
                if (value != null && value.getValue() != null) {
                    try {
                        String urlVal = (String)value.getValue();
                        URL url = new URL(urlVal);
                        theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, url, cont, parent);
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)"Exception occurred.", (Throwable)e);
                        theObject = null;
                    }
                }
            } else if (dataType.equalsIgnoreCase("chart") && (value = (Variant)((Cell)cont).getData().getValue()) != null && value.getValue() != null) {
                theObject = new ChartObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
                ((ChartObject)theObject).setData((ChartData)value.getValue());
            }
        }
        if (theObject != null && theObject instanceof FormContainerObject) {
            Iterator itr = cont.iterator();
            Container elt = null;
            while (itr.hasNext()) {
                elt = (Container)itr.next();
                this.buildFormObjects(elt, (FormContainerObject)theObject);
            }
        }
        if (theObject != null) {
            if (parent == null) {
                assert (cont instanceof Page);
            } else {
                assert (parent instanceof FormContainerObject);
                parent.addChild(theObject);
            }
        }
        return theObject;
    }
}

