/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kds;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;

public class BaseProperty {
    private ShareStyleAttributes ssa;
    private Style style;
    private KDSMergeBlock merge;
    private HyperLink hyperLink;
    private ValidationList validationList;

    public BaseProperty(ShareStyleAttributes ssa, Style style) {
        assert (ssa != null && style != null);
        this.ssa = this.removeGeneralFormat(ssa);
        this.style = this.removeGeneralFormat(style);
        this.merge = KDSMergeBlock.NULL_MERGE;
    }

    private ShareStyleAttributes removeGeneralFormat(ShareStyleAttributes ssa) {
        if ("g/\u901a\u7528\u683c\u5f0f".equalsIgnoreCase(ssa.getNumberFormat())) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            sa.put(StyleAttributes.NUMBER_FORMAT, null);
            return Styles.getSSA((StyleAttributes)sa);
        }
        return ssa;
    }

    private Style removeGeneralFormat(Style style) {
        if ("g/\u901a\u7528\u683c\u5f0f".equalsIgnoreCase(style.getNumberFormat())) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)style);
            sa.put(StyleAttributes.NUMBER_FORMAT, null);
            return Styles.getStyle((ShareStyleAttributes)Styles.getSSA((StyleAttributes)sa));
        }
        return style;
    }

    public boolean isEmptyBaseProperty() {
        return this.ssa.isEmpty() && this.merge.isNullMergeBlock();
    }

    public ShareStyleAttributes getSSA() {
        return this.ssa;
    }

    protected void setSSA(ShareStyleAttributes ssa) {
        assert (ssa != null);
        this.ssa = ssa == null ? Styles.getEmptySSA() : this.removeGeneralFormat(ssa);
    }

    public Style getStyle() {
        return this.style;
    }

    protected void setStyle(Style style) {
        assert (style != null);
        this.style = style == null ? Styles.getDefaultStyle() : this.removeGeneralFormat(style);
    }

    public boolean isMerged() {
        return !this.merge.isNullMergeBlock();
    }

    public KDSMergeBlock getMergeBlock() {
        return this.merge;
    }

    protected void setMergeBlock(KDSMergeBlock merge) {
        assert (merge != null);
        this.merge = merge == null ? KDSMergeBlock.NULL_MERGE : merge;
    }

    public int hashCode() {
        int hash = this.ssa.hashCode() ^ this.style.hashCode();
        if (!this.merge.isNullMergeBlock()) {
            hash ^= this.merge.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BaseProperty)) {
            return false;
        }
        BaseProperty ele = (BaseProperty)obj;
        return this.ssa.equals((Object)ele.getSSA()) && this.style.equals((Object)ele.getStyle()) && this.merge.equals(ele.getMergeBlock());
    }

    public void setHyperLink(HyperLink hyperLink) {
        this.hyperLink = hyperLink;
    }

    public HyperLink getHyperLink() {
        return this.hyperLink;
    }

    public void setValidationList(ValidationList validationList) {
        this.validationList = validationList;
    }

    public ValidationList getValidationList() {
        return this.validationList;
    }
}

