/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kds;

public class KDSProtection {
    private int _opers;
    private String passWord;
    private boolean _isProtected = false;

    public KDSProtection(int opers, String passWord) {
        this._opers = opers;
        this.passWord = passWord;
        if (null != passWord) {
            this._isProtected = true;
        }
    }

    public int getOperations() {
        return this._opers;
    }

    public void setOperations(int opers) {
        this._opers = opers;
    }

    public void deleteOperations() {
        this._opers = 0;
    }

    public void appendOperation(int operation) {
        this._opers |= operation;
    }

    public void deleteOperation(int operation) {
        this._opers &= ~operation;
    }

    public boolean hasOperation(int operation) {
        return (this._opers & operation) != 0;
    }

    public boolean allowSelectLocked() {
        return !this._isProtected || (this._opers & 1) != 0;
    }

    public boolean allowSelectUnLocked() {
        return !this._isProtected || (this._opers & 2) != 0;
    }

    public boolean allowFormattingCells() {
        return !this._isProtected || (this._opers & 4) != 0;
    }

    public boolean allowFormattingColumns() {
        return !this._isProtected || (this._opers & 8) != 0;
    }

    public boolean allowFormattingRows() {
        return !this._isProtected || (this._opers & 0x10) != 0;
    }

    public boolean allowInsertingColumns() {
        return !this._isProtected || (this._opers & 0x20) != 0;
    }

    public boolean allowInsertingRows() {
        return !this._isProtected || (this._opers & 0x40) != 0;
    }

    public boolean allowInsertingHyperlinks() {
        return !this._isProtected || (this._opers & 0x80) != 0;
    }

    public boolean allowDeletingColumns() {
        return !this._isProtected || (this._opers & 0x100) != 0;
    }

    public boolean allowDeletingRows() {
        return !this._isProtected || (this._opers & 0x200) != 0;
    }

    public boolean allowSorting() {
        return !this._isProtected || (this._opers & 0x400) != 0;
    }

    public boolean allowFiltering() {
        return !this._isProtected || (this._opers & 0x800) != 0;
    }

    public boolean allowUsingPivotTables() {
        return !this._isProtected || (this._opers & 0x1000) != 0;
    }

    public boolean allowEditObjects() {
        return !this._isProtected || (this._opers & 0x2000) != 0;
    }

    public boolean allowEditScenarios() {
        return !this._isProtected || (this._opers & 0x4000) != 0;
    }

    public boolean allowUnhideColumnsACols() {
        return this._isProtected || (this._opers & 0x20000) != 0;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }
}

