/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.gui;

import com.kingdee.bos.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.bos.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.ContextEventListener;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UpdateViewEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.PrintPaperMeasureWithZoom;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.event.MouseInputAdapter;

public class MarginLines
extends MouseInputAdapter
implements ContextEventListener {
    private Line2D header;
    private Line2D footer;
    private Line2D leftLine;
    private Line2D rightLine;
    private Line2D topLine;
    private Line2D bottomLine;
    private AbstractPreviewPane pane;
    private PrintPaperMeasureWithZoom paperMeasure;
    private ContextOfPreview context;
    private boolean isAdjusting = false;
    private boolean isDragging = false;
    Rectangle2D leftLineArea;
    Rectangle2D rightLineArea;
    Rectangle2D topLineArea;
    Rectangle2D bottomLineArea;
    Cursor saveCursor;
    Rectangle2D lineActived;
    private Rectangle2D headerArea;
    private Rectangle2D footerArea;

    public MarginLines(AbstractPreviewPane pane, PrinterAttrManager attrmgr, ContextOfPreview context) {
        this.pane = pane;
        this.paperMeasure = new PrintPaperMeasureWithZoom(attrmgr, context, pane);
        this.context = context;
    }

    public void recalcMargins() {
        double h = this.paperMeasure.getPaperHeight();
        double w = this.paperMeasure.getPaperWidth();
        double x1 = this.paperMeasure.getLeft() + (float)this.context.getBeginOfCurrentPage().x;
        double x2 = w - (double)this.paperMeasure.getRight() + (double)this.context.getBeginOfCurrentPage().x;
        double y1 = this.paperMeasure.getTop() + (float)this.context.getBeginOfCurrentPage().y;
        double y2 = h - (double)this.paperMeasure.getBottom() + (double)this.context.getBeginOfCurrentPage().y;
        KDPrintService.logger.debug((Object)this.paperMeasure.toString());
        this.header = new Line2D.Double(this.context.getBeginOfCurrentPage().x, this.paperMeasure.getHeaderMargin() + (float)this.context.getBeginOfCurrentPage().y, w + (double)this.context.getBeginOfCurrentPage().x, this.paperMeasure.getHeaderMargin() + (float)this.context.getBeginOfCurrentPage().y);
        this.footer = new Line2D.Double(this.context.getBeginOfCurrentPage().x, (int)(h - (double)this.paperMeasure.getFooterMargin() + (double)this.context.getBeginOfCurrentPage().y), w + (double)this.context.getBeginOfCurrentPage().x, (int)(h - (double)this.paperMeasure.getFooterMargin()) + this.context.getBeginOfCurrentPage().y);
        this.leftLine = new Line2D.Double(x1, this.context.getBeginOfCurrentPage().y, x1, h + (double)this.context.getBeginOfCurrentPage().y);
        this.rightLine = new Line2D.Double(x2, this.context.getBeginOfCurrentPage().y, x2, h + (double)this.context.getBeginOfCurrentPage().y);
        this.topLine = new Line2D.Double(this.context.getBeginOfCurrentPage().x, y1, w + (double)this.context.getBeginOfCurrentPage().x, y1);
        this.bottomLine = new Line2D.Double(this.context.getBeginOfCurrentPage().x, y2, w + (double)this.context.getBeginOfCurrentPage().x, y2);
        this.leftLineArea = this.lineAreaFromLine(this.leftLine, 2);
        this.rightLineArea = this.lineAreaFromLine(this.rightLine, 2);
        this.topLineArea = this.lineAreaFromLine(this.topLine, 2);
        this.bottomLineArea = this.lineAreaFromLine(this.bottomLine, 2);
        this.headerArea = this.lineAreaFromLine(this.header, 2);
        this.footerArea = this.lineAreaFromLine(this.footer, 2);
        this.paperMeasure.recalc();
    }

    @Override
    public void uiStateChanged(UIStateChangedEvent event) {
        if (event.getState() == 3) {
            this.isAdjusting = true;
            this.recalcMargins();
            this.pane.addMouseListener(this);
            this.pane.addMouseMotionListener(this);
            this.pane.doRepaint();
        } else if (this.isAdjusting && event.getState() == 4) {
            this.isAdjusting = false;
            this.pane.removeMouseListener(this);
            this.pane.removeMouseMotionListener(this);
        }
    }

    @Override
    public void updateView(UpdateViewEvent event) {
    }

    @Override
    public void currentPageChanged(CurrentPageChangedEvent event) {
    }

    public Line2D getHeaderLine() {
        return this.header;
    }

    public Line2D getFooterLine() {
        return this.footer;
    }

    public Line2D getLeftLine() {
        return this.leftLine;
    }

    public Line2D getRightLine() {
        return this.rightLine;
    }

    public Line2D getTopLine() {
        return this.topLine;
    }

    public Line2D getBottomLine() {
        return this.bottomLine;
    }

    private Rectangle2D lineAreaFromLine(Line2D line, int halfWidth) {
        if (line.getX1() == line.getX2()) {
            return new Rectangle2D.Double(line.getX1() - (double)halfWidth, line.getY1(), halfWidth * 2, line.getY2() - line.getY1());
        }
        if (line.getY1() == line.getY2()) {
            return new Rectangle2D.Double(line.getX1(), line.getY1() - (double)halfWidth, line.getX2() - line.getX1(), halfWidth * 2);
        }
        return null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.footerArea != null && this.footerArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(8));
            this.lineActived = this.footerArea;
        } else if (this.headerArea != null && this.headerArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(8));
            this.lineActived = this.headerArea;
        } else if (this.leftLineArea != null && this.leftLineArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(10));
            this.lineActived = this.leftLineArea;
        } else if (this.rightLineArea != null && this.rightLineArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(10));
            this.lineActived = this.rightLineArea;
        } else if (this.topLineArea != null && this.topLineArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(8));
            this.lineActived = this.topLineArea;
        } else if (this.bottomLineArea != null && this.bottomLineArea.contains(e.getPoint()) && this.saveCursor == null) {
            this.saveCursor = e.getComponent().getCursor();
            e.getComponent().setCursor(new Cursor(8));
            this.lineActived = this.bottomLineArea;
        } else if (this.saveCursor != null && !this.lineActived.contains(e.getPoint())) {
            e.getComponent().setCursor(this.saveCursor);
            this.saveCursor = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.saveCursor != null) {
            Point ptEvent = e.getPoint();
            Point ptPage = this.context.getBeginOfCurrentPage();
            if (ptEvent.getX() <= (double)((float)ptPage.x + this.paperMeasure.getExtremeLeft()) || ptEvent.getY() <= (double)((float)ptPage.y + this.paperMeasure.getExtremeTop()) || ptEvent.getX() >= (double)((float)ptPage.x + this.paperMeasure.getPaperWidth() * this.paperMeasure.getScreenMapRatio()) - (double)(this.paperMeasure.getExtremeRight() * this.paperMeasure.getScreenMapRatio()) || ptEvent.getY() >= (double)((float)ptPage.y + this.paperMeasure.getPaperHeight() * this.paperMeasure.getScreenMapRatio()) - (double)(this.paperMeasure.getExtremeBottom() * this.paperMeasure.getScreenMapRatio())) {
                return;
            }
            if (this.lineActived == this.leftLineArea) {
                if (e.getPoint().getX() > this.rightLine.getX1()) {
                    return;
                }
            } else if (this.lineActived == this.footerArea || this.lineActived == this.headerArea || this.lineActived == this.topLineArea || this.lineActived == this.bottomLineArea) {
                // empty if block
            }
            this.drawXORLine(e.getPoint(), this.pane);
            this.isDragging = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isDragging) {
            return;
        }
        this.isDragging = false;
        this.checkOutOfBound();
        this.headerArea = this.lineAreaFromLine(this.header, 2);
        this.footerArea = this.lineAreaFromLine(this.footer, 2);
        this.leftLineArea = this.lineAreaFromLine(this.leftLine, 2);
        this.rightLineArea = this.lineAreaFromLine(this.rightLine, 2);
        this.topLineArea = this.lineAreaFromLine(this.topLine, 2);
        this.bottomLineArea = this.lineAreaFromLine(this.bottomLine, 2);
        this.paperMeasure.setHeaderMargin((int)this.header.getY1() - this.context.getBeginOfCurrentPage().y);
        this.paperMeasure.setFooterMargin((int)((double)this.paperMeasure.getPaperHeight() - (this.footer.getY1() - (double)this.context.getBeginOfCurrentPage().y)));
        MediaPrintableArea area = new MediaPrintableArea((float)(this.leftLine.getX1() - (double)this.context.getBeginOfCurrentPage().x) * 0.35277778f, (float)(this.topLine.getY1() - (double)this.context.getBeginOfCurrentPage().y) * 0.35277778f, (float)(this.rightLine.getX1() - this.leftLine.getX1()) * 0.35277778f, (float)(this.bottomLine.getY1() - this.topLine.getY1()) * 0.35277778f, 1000);
        this.paperMeasure.setMediaPrintableArea(area);
        this.context.refresh();
    }

    private void drawXORLine(Point point, Component comp) {
        Graphics2D g2 = (Graphics2D)comp.getGraphics();
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        float[] dash1 = new float[]{5.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
        g2.setStroke(dashed);
        g2.setColor(Color.BLACK);
        g2.setXORMode(Color.WHITE);
        if (this.lineActived == this.footerArea) {
            Line2D.Double line = new Line2D.Double(this.footer.getX1(), point.getY(), this.footer.getX2(), point.getY());
            g2.draw(this.footer);
            g2.draw(line);
            this.footer = line;
        } else if (this.lineActived == this.headerArea) {
            Line2D.Double line = new Line2D.Double(this.topLine.getX1(), point.getY(), this.topLine.getX2(), point.getY());
            g2.draw(this.header);
            g2.draw(line);
            this.header = line;
        } else if (this.lineActived == this.leftLineArea) {
            Line2D.Double line = new Line2D.Double(point.x, this.leftLine.getY1(), point.x, this.leftLine.getY2());
            g2.draw(this.leftLine);
            g2.draw(line);
            this.leftLine = line;
        } else if (this.lineActived == this.rightLineArea) {
            Line2D.Double line = new Line2D.Double(point.x, this.rightLine.getY1(), point.x, this.rightLine.getY2());
            g2.draw(this.rightLine);
            g2.draw(line);
            this.rightLine = line;
        } else if (this.lineActived == this.topLineArea) {
            Line2D.Double line = new Line2D.Double(this.topLine.getX1(), point.getY(), this.topLine.getX2(), point.getY());
            g2.draw(this.topLine);
            g2.draw(line);
            this.topLine = line;
        } else if (this.lineActived == this.bottomLineArea) {
            Line2D.Double line = new Line2D.Double(this.bottomLine.getX1(), point.getY(), this.bottomLine.getX2(), point.getY());
            g2.draw(this.bottomLine);
            g2.draw(line);
            this.bottomLine = line;
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    private void checkOutOfBound() {
        if (this.lineActived == this.leftLineArea) {
            if (this.leftLine.getX1() >= this.rightLine.getX1()) {
                double oldVal = this.paperMeasure.getLeft();
                this.leftLine.setLine(oldVal, this.leftLine.getY1(), oldVal, this.leftLine.getY2());
            }
        } else if (this.lineActived == this.rightLineArea) {
            if (this.rightLine.getX1() <= this.leftLine.getX1()) {
                double oldVal = (double)this.paperMeasure.getPaperWidth() - (double)this.paperMeasure.getRight();
                this.rightLine.setLine(oldVal, this.rightLine.getY1(), oldVal, this.rightLine.getY2());
            }
        } else if (this.lineActived == this.topLineArea) {
            if (this.topLine.getY1() > this.bottomLine.getY1()) {
                double oldVal = this.paperMeasure.getTop();
                this.topLine.setLine(this.topLine.getX1(), oldVal, this.topLine.getX2(), oldVal);
            }
        } else if (this.lineActived == this.bottomLineArea && this.bottomLine.getY1() <= this.topLine.getY1()) {
            double oldVal = (double)this.paperMeasure.getPaperHeight() - (double)this.paperMeasure.getBottom();
            this.bottomLine.setLine(this.bottomLine.getX1(), oldVal, this.bottomLine.getX2(), oldVal);
        }
    }
}

