/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.read;

import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;

public class DataValidationReader {
    public static ValidationList getValidationData(HSSFSheet sheet, KDSSheet kdssheet) {
        List _validationList = null;
        ValidationList vList = new ValidationList();
        try {
            _validationList = DataValidationReader.getValidationList(sheet);
            for (int i = 0; i < _validationList.size(); ++i) {
                DVRecord dv = (DVRecord)_validationList.get(i);
                MessagedValidate vMsg = new MessagedValidate();
                vMsg = DataValidationReader.getMessagedValidate(dv, vMsg, sheet);
                Validation v = DataValidationReader.getDataValidation(dv);
                v.setMessagedValidate(vMsg);
                vList.addValidation(v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vList;
    }

    private static Validation getDataValidation(DVRecord dv) {
        Validation v = new Validation();
        SortedCellBlockArray sb = new SortedCellBlockArray();
        CellRangeAddressList cellList = dv.getCellRangeAddress();
        for (int j = 0; j < cellList.countRanges(); ++j) {
            CellRangeAddress cellAddr = cellList.getCellRangeAddress(j);
            sb.insert((Object)CellBlock.getNewCellBlock((int)cellAddr.getFirstRow(), (int)cellAddr.getFirstColumn(), (int)cellAddr.getLastRow(), (int)cellAddr.getLastColumn()));
        }
        v.setBlocks(sb);
        return v;
    }

    private static MessagedValidate getMessagedValidate(DVRecord dv, MessagedValidate vMsg, HSSFSheet sheet) throws Exception {
        SimpleDateFormat format;
        Class<?> dr = Class.forName("org.apache.poi.hssf.record.DVRecord");
        Field _promptTitle = dr.getDeclaredField("_promptTitle");
        Field _promptText = dr.getDeclaredField("_promptText");
        Field _errorTitle = dr.getDeclaredField("_errorTitle");
        Field _errorText = dr.getDeclaredField("_errorText");
        Field _formula1 = dr.getDeclaredField("_formula1");
        Field _formula2 = dr.getDeclaredField("_formula2");
        ReflectUtil.makeAccessible((Field)_promptTitle);
        ReflectUtil.makeAccessible((Field)_promptText);
        ReflectUtil.makeAccessible((Field)_errorTitle);
        ReflectUtil.makeAccessible((Field)_errorText);
        ReflectUtil.makeAccessible((Field)_formula2);
        ReflectUtil.makeAccessible((Field)_formula1);
        vMsg.setType(DataValidationReader.switchTypes(dv.getDataType()));
        vMsg.setQualifier(DataValidationReader.switchOperator(dv.getConditionOperator()));
        vMsg.setUseBlank(!dv.getEmptyCellAllowed());
        vMsg.setErrorHide(!dv.getShowErrorOnInvalidValue());
        vMsg.setErrorStyle(DataValidationReader.switchErrorStyle(dv.getErrorStyle()));
        vMsg.setInputHide(!dv.getShowPromptOnCellSelected());
        vMsg.setCellRangeList(!dv.getSuppressDropdownArrow());
        String promptTitle = DataValidationReader.formatText((UnicodeString)_promptTitle.get(dv));
        String promptText = DataValidationReader.formatText((UnicodeString)_promptTitle.get(dv));
        String errorTitle = DataValidationReader.formatText((UnicodeString)_errorTitle.get(dv));
        String errorText = DataValidationReader.formatText((UnicodeString)_errorText.get(dv));
        Formula formula1 = (Formula)_formula1.get(dv);
        Formula formula2 = (Formula)_formula2.get(dv);
        vMsg.setInputTitle(promptTitle);
        vMsg.setInputMessage(promptText);
        vMsg.setErrorTitle(errorTitle);
        vMsg.setErrorMessage(errorText);
        try {
            String min = HSSFFormulaParser.toFormulaString((HSSFWorkbook)sheet.getWorkbook(), (Ptg[])Formula.getTokens((Formula)formula1));
            if (min != null) {
                if (!min.startsWith("=") && DataValidationReader.isRef(min)) {
                    min = "=" + min;
                } else if (Validate.Type_List.equals(vMsg.getType())) {
                    min = min.replaceAll("\"", "");
                    min = min.replace('\u0000', ',');
                } else if (Validate.Type_Date.equals(vMsg.getType())) {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    min = String.valueOf(format.format(HSSFDateUtil.getJavaDate((double)Double.parseDouble(min))));
                } else if (Validate.Type_Time.equals(vMsg.getType())) {
                    format = new SimpleDateFormat("HH:mm:ss");
                    min = String.valueOf(format.format(HSSFDateUtil.getJavaDate((double)Double.parseDouble(min))));
                }
            }
            vMsg.setMin(min);
        }
        catch (IllegalArgumentException iae) {
            vMsg.setMin("");
        }
        try {
            String max = HSSFFormulaParser.toFormulaString((HSSFWorkbook)sheet.getWorkbook(), (Ptg[])Formula.getTokens((Formula)formula2));
            if (max != null) {
                if (!max.startsWith("=") && DataValidationReader.isRef(max)) {
                    max = "=" + max;
                } else if (Validate.Type_Date.equals(vMsg.getType())) {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                    max = String.valueOf(format.format(HSSFDateUtil.getJavaDate((double)Double.parseDouble(max))));
                } else if (Validate.Type_Time.equals(vMsg.getType())) {
                    format = new SimpleDateFormat("hh:mm:ss");
                    max = String.valueOf(format.format(HSSFDateUtil.getJavaDate((double)Double.parseDouble(max))));
                }
            }
            vMsg.setMax(max);
        }
        catch (IllegalArgumentException iae) {
            vMsg.setMax("");
        }
        return vMsg;
    }

    private static List getValidationList(HSSFSheet sheet) throws Exception {
        Method method = null;
        InternalSheet _sheet = null;
        Field field = null;
        Class<?> hfs = Class.forName("org.apache.poi.hssf.usermodel.HSSFSheet");
        method = hfs.getDeclaredMethod("getSheet", null);
        ReflectUtil.makeAccessible((Method)method);
        _sheet = (InternalSheet)method.invoke((Object)sheet, null);
        DataValidityTable dvt = null;
        dvt = _sheet.getOrCreateDataValidityTable();
        Class<?> dvtCls = Class.forName("org.apache.poi.hssf.record.aggregates.DataValidityTable");
        field = dvtCls.getDeclaredField("_validationList");
        ReflectUtil.makeAccessible((Field)field);
        return (List)field.get(dvt);
    }

    private static boolean isRef(String formula) {
        block4: {
            try {
                Integer.parseInt(formula);
            }
            catch (NumberFormatException nfe) {
                try {
                    Double.parseDouble(formula);
                }
                catch (NumberFormatException nfe1) {
                    if (formula.indexOf("\"") >= 0) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    private static String switchTypes(int type) {
        switch (type) {
            case 0: {
                return Validate.Type_ANY;
            }
            case 1: {
                return Validate.Type_Whole;
            }
            case 2: {
                return Validate.Type_Decimal;
            }
            case 3: {
                return Validate.Type_List;
            }
            case 4: {
                return Validate.Type_Date;
            }
            case 5: {
                return Validate.Type_Time;
            }
            case 6: {
                return Validate.Type_TextLength;
            }
        }
        return Validate.Type_ANY;
    }

    private static String switchOperator(int operator) {
        switch (operator) {
            case 0: {
                return Validate.Between;
            }
            case 1: {
                return Validate.NotBetween;
            }
            case 2: {
                return Validate.Equal;
            }
            case 3: {
                return Validate.NotEqual;
            }
            case 4: {
                return Validate.Greater;
            }
            case 5: {
                return Validate.Less;
            }
            case 6: {
                return Validate.GreaterOrEqual;
            }
            case 7: {
                return Validate.LessOrEqual;
            }
        }
        return Validate.Between;
    }

    private static String switchErrorStyle(int errorStyle) {
        switch (errorStyle) {
            case 0: {
                return MessagedValidate.STOP_STYLE;
            }
            case 1: {
                return MessagedValidate.WARNING_STYLE;
            }
            case 2: {
                return MessagedValidate.INFORMATION_STYLE;
            }
        }
        return MessagedValidate.STOP_STYLE;
    }

    private static String formatText(UnicodeString us) {
        String str = us.getString();
        if (str.length() == 1 && str.charAt(0) == '\u0000') {
            return "";
        }
        return str;
    }
}

