/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.read;

class Parameter {
    private int tokenPos;
    private int tokenLength;
    private String token;
    private int rowNum;
    private int colNum;
    private boolean isAbsCol;
    private boolean isAbsRow;

    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public Parameter(int tokenPos, int tokenLength, String token) {
        this.tokenPos = tokenPos;
        this.tokenLength = tokenLength;
        this.token = token;
        this.init();
    }

    private void init() {
        char ch = this.token.charAt(0);
        int pos = 0;
        int s = 0;
        if (ch == '$') {
            this.isAbsCol = true;
            ch = this.getChar(++pos);
            ++s;
        }
        while (ch >= 'A' && ch <= 'Z') {
            ch = this.token.charAt(++pos);
        }
        String col = this.token.substring(s, pos);
        this.calColNum(col);
        if (this.getChar(pos) == '$') {
            this.isAbsRow = true;
            ++pos;
        }
        this.rowNum = Integer.parseInt(this.token.substring(pos, this.token.length())) - 1;
    }

    private char getChar(int pos) {
        return pos < this.token.length() ? this.token.charAt(pos) : (char)'\u0000';
    }

    private void calColNum(String col) {
        byte[] rowAbc = col.getBytes();
        int len = rowAbc.length;
        for (int i = 0; i < len; ++i) {
            this.colNum = (int)((double)this.colNum + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        --this.colNum;
    }

    public int getTokenPos() {
        return this.tokenPos;
    }

    public void setTokenPos(int tokenPos) {
        this.tokenPos = tokenPos;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength = tokenLength;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean isAbsCol() {
        return this.isAbsCol;
    }

    public boolean isAbsRow() {
        return this.isAbsRow;
    }
}

