/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.server;

import com.kingdee.bos.ctrl.kdf.server.FormContext;
import com.kingdee.bos.ctrl.kdf.server.FormPageEvent;
import com.kingdee.bos.ctrl.kdf.server.FormPageInfo;
import com.kingdee.bos.ctrl.kdf.server.IForm;
import com.kingdee.bos.ctrl.kdf.server.IORMForm;
import com.kingdee.bos.ctrl.kdf.server.IORMFormPageQueue;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.ORMEngine;
import java.io.InputStream;
import java.util.HashMap;

class RemoteFormVisitor
implements IForm {
    private IORMFormPageQueue pageQueue;
    private IORMForm form;
    private int kdfID;
    private FormContext context;
    private transient Thread thread;
    private transient FormPageInfo formPageInfo;
    private transient byte[] kdf;
    private transient IServerPluginParam[] plugins;
    private transient IVariantDataListener vdataListener;
    private transient Object userFuncObj;
    private transient HashMap reportParams;

    public RemoteFormVisitor(String tcpUrl) {
        try {
            this.form = (IORMForm)ORMEngine.createRemoteObject((String)tcpUrl, (String)"com.kingdee.bos.ctrl.kdf.server.ORMFormServer", IORMForm.class);
            this.pageQueue = (IORMFormPageQueue)ORMEngine.createRemoteObject((String)tcpUrl, (String)"com.kingdee.bos.ctrl.kdf.server.ORMFormPageQueue", IORMFormPageQueue.class);
            this.kdfID = this.form.getKDFID();
            this.context = FormContext.getInstance(this.kdfID);
        }
        catch (ORMCoreException orme) {
            throw new RuntimeException(orme);
        }
    }

    @Override
    public void setPageInfo(FormPageInfo info) {
        this.formPageInfo = info;
    }

    @Override
    public void setKDF(byte[] kdf) {
        this.kdf = kdf;
    }

    @Override
    public void makeForm() {
        try {
            this.form.setKDF(this.kdf);
            this.form.setPageInfo(this.formPageInfo);
            this.form.setVariantDataListener(this.vdataListener);
            this.form.setUserFunctionProvider(this.userFuncObj);
            this.form.setReportParams(this.reportParams);
            this.form.setPlugins(this.plugins);
            this.thread = ServerPageEventListener.runNewInstance(this.kdfID, this.pageQueue);
            Object[] rt = this.form.prepareForm();
            if (rt != null && this.plugins != null) {
                for (int i = 0; i < rt.length; ++i) {
                    if (this.plugins[i] == null) continue;
                    this.plugins[i].notify(rt[i]);
                }
            }
            this.form.makeForm();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FormContext.close(this.context.getID());
        }
        catch (ORMCoreException orme) {
            throw new RuntimeException(orme);
        }
    }

    @Override
    public int getKDFID() {
        return this.kdfID;
    }

    @Override
    public void setPlugins(IServerPluginParam[] plugins) {
        this.plugins = plugins;
    }

    @Override
    public void cancelJob(Thread worker) {
        this.form.cancelJob(null);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void setVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    @Override
    public void setUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }

    @Override
    public void setReportParams(HashMap params) {
        this.reportParams = params;
    }

    @Override
    public void setKDF(InputStream kdfStream) {
        throw new AssertionError((Object)"Remote Mode do not support Stream Input");
    }

    private static class ServerPageEventListener
    implements Runnable {
        private IORMFormPageQueue pageQueue;
        private int kdfID;
        private Thread thread;
        private boolean isEnd = false;

        private ServerPageEventListener() {
        }

        public static Thread runNewInstance(int kdfID, IORMFormPageQueue pageQueue) {
            ServerPageEventListener instance = new ServerPageEventListener();
            instance.pageQueue = pageQueue;
            instance.kdfID = kdfID;
            instance.thread = new Thread(instance);
            instance.thread.start();
            return instance.thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isEnd && !Thread.currentThread().isInterrupted()) {
                ServerPageEventListener serverPageEventListener = this;
                synchronized (serverPageEventListener) {
                    try {
                        if (this.pageQueue != null) {
                            FormPageEvent[] content = this.pageQueue.getPages(this.kdfID);
                            for (int i = 0; i < content.length; ++i) {
                                int kdfID = content[i].getKDFID();
                                FormContext context = FormContext.getInstance(kdfID);
                                this.isEnd = content[i].isFormOutputEnd();
                                if (this.isEnd) {
                                    context.endFormOutput();
                                    this.pageQueue.remove(kdfID);
                                    continue;
                                }
                                int pageIndex = content[i].getPageIndex();
                                context.obtainNewPage(pageIndex, content[i].getPage());
                            }
                        }
                        this.wait(1000L);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
        }
    }
}

