/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state.util;

import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadCellTextRender;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.LineMetrics;

public class KDSpreadHelper {
    private KDSpreadHelper() {
    }

    public static void autoFitRowHeight(KDSpread spread) {
        Book book = spread.getBook();
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            return;
        }
        Sheet sheet = spread.getBook().getActiveSheet();
        int viewMode = sheet.getSheetOption().getCellDisplayMode();
        ICellDisplayProvider prov = spread.getCellDisplayProvider();
        Object value = prov.getBaseValue(cell, viewMode);
        Range rowRange = sheet.getRowRange(cell.getRow(), cell.getRow());
        int cellHeight = sheet.getDefRowHeight();
        Integer oldHeight = rowRange.getRowHeight();
        if (null != oldHeight) {
            cellHeight = oldHeight;
        }
        if (value instanceof String && cell.getStyle().isWrapText()) {
            Graphics2D g2d = (Graphics2D)spread.getGraphics();
            IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
            if (cellRender instanceof SpreadCellTextRender) {
                float h;
                int pos = sheet.getColSpans().searchSpan(cell.getCol());
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (pos >= 0) {
                    span = (SortedAttributeSpanArray.AttributeSpan)sheet.getColSpans().getSpan(pos);
                }
                float colWidth = span != null ? (float)span.getLength() : (float)sheet.getDefColWidth();
                float rowHeight = cellHeight;
                CellBlock mergeBlock = book.getActiveSheet().getMergeBlock(cell);
                if (mergeBlock != null) {
                    Rectangle bufRect = new Rectangle();
                    SheetBaseMath.getBlockRect(cell.getSheet(), mergeBlock, false, bufRect);
                    Rectangle bd = bufRect.getBounds();
                    colWidth = bd.width;
                    rowHeight = bd.height;
                }
                if ((h = ((SpreadCellTextRender)cellRender).getPreferredHeight(g2d, new Rectangle(0, 0, (int)colWidth, (int)rowHeight), value, cell.getStyle())) > 0.0f && h > rowHeight) {
                    double c = (double)h - (double)rowHeight;
                    rowRange.setRowHeight(cellHeight + ((int)c + 4));
                }
            }
            if (cell.getStyle().isVerticalText()) {
                KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
            }
        } else if (value instanceof String && cell.getStyle().isVerticalText()) {
            KDSpreadHelper.autoFitVerticalTextHeight(spread, cell, value.toString(), rowRange, oldHeight);
        }
    }

    protected static void autoFitVerticalTextHeight(KDSpread spread, Cell cell, String value, Range rowRange, Integer oldHeight) {
        Graphics2D g = (Graphics2D)spread.getGraphics();
        KDFont f = cell.getStyle().getKDFont();
        g.setColor(cell.getStyle().getFontColor());
        g.setFont((Font)f);
        LineMetrics lm = f.getLineMetrics(value, g.getFontRenderContext());
        double fontHeight = lm.getAscent() + lm.getDescent();
        float height = 0.0f;
        int sourceHeight = (int)(fontHeight * (double)value.length());
        if ((float)sourceHeight > height) {
            height = sourceHeight;
        }
        if (height > 0.0f && height > (float)oldHeight.intValue()) {
            rowRange.setRowHeight((int)height + 4);
        }
    }
}

