/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.htm;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;

public final class PagingIterator {
    public static final boolean ORDER_COLUMN2ROW = true;
    public static final boolean ORDER_ROW2COLUMN = false;
    private int rowSpan;
    private int colSpan;
    private Sheet sheet;
    private boolean order;
    int[] leftUpRightDown = new int[4];

    public PagingIterator(Sheet sheet, int rowSpan, int colSpan, boolean order) {
        this.sheet = sheet;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.order = order;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void reset() {
        this.leftUpRightDown[3] = 0;
        this.leftUpRightDown[2] = 0;
        this.leftUpRightDown[1] = 0;
        this.leftUpRightDown[0] = 0;
    }

    public int[] next() {
        int maxCol = this.sheet.getMaxColIndex();
        int maxRow = this.sheet.getMaxRowIndex();
        if (this.leftUpRightDown[2] == 0) {
            this.leftUpRightDown[2] = this.colSpan - 1;
            this.leftUpRightDown[3] = this.rowSpan - 1;
        } else if (!this.order) {
            if (this.leftUpRightDown[2] != maxCol) {
                this.leftUpRightDown[0] = this.leftUpRightDown[0] + this.colSpan;
                this.leftUpRightDown[2] = this.leftUpRightDown[2] + this.colSpan > maxCol ? maxCol : this.leftUpRightDown[2] + this.colSpan;
            } else {
                this.leftUpRightDown[1] = this.leftUpRightDown[1] + this.rowSpan;
                this.leftUpRightDown[3] = this.leftUpRightDown[3] + this.rowSpan > maxRow ? maxRow : this.leftUpRightDown[3] + this.rowSpan;
                this.leftUpRightDown[0] = 0;
                this.leftUpRightDown[2] = this.colSpan - 1;
            }
        } else if (this.leftUpRightDown[3] != maxRow) {
            this.leftUpRightDown[1] = this.leftUpRightDown[1] + this.rowSpan;
            this.leftUpRightDown[3] = this.leftUpRightDown[3] + this.rowSpan > maxRow ? maxRow : this.leftUpRightDown[3] + this.rowSpan;
        } else {
            this.leftUpRightDown[1] = 0;
            this.leftUpRightDown[3] = this.rowSpan - 1;
            this.leftUpRightDown[0] = this.leftUpRightDown[0] + this.colSpan;
            this.leftUpRightDown[2] = this.leftUpRightDown[2] + this.colSpan > maxCol ? maxCol : this.leftUpRightDown[2] + this.colSpan;
        }
        return this.leftUpRightDown;
    }

    public boolean hasNext() {
        if (this.sheet == null) {
            return false;
        }
        if (this.rowSpan > this.sheet.getMaxRowIndex()) {
            return false;
        }
        if (this.colSpan > this.sheet.getMaxColIndex()) {
            return false;
        }
        return this.leftUpRightDown[2] < this.sheet.getMaxColIndex() || this.leftUpRightDown[3] < this.sheet.getMaxRowIndex();
    }
}

