/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.ExcelWorkBookElement;
import com.kingdee.bos.ctrl.excel.io.kml.KingdeeDefinedElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.io.kml.NamesElement;
import com.kingdee.bos.ctrl.excel.io.kml.SheetElement;
import com.kingdee.bos.ctrl.excel.io.kml.StylesElement;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BookElement
extends BasicElement {
    private AbsElement _stylesE;
    private AbsElement _sheetE;
    private AbsElement _namesE;
    private AbsElement _excelE;
    private AbsElement _kdE;

    BookElement() {
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        AbsElement parser;
        if ("Styles".equals(KmlUtil.getLocalName(qName))) {
            if (this._stylesE == null) {
                this._stylesE = new StylesElement();
            }
            parser = this._stylesE;
        } else if ("Worksheet".equals(KmlUtil.getLocalName(qName))) {
            if (this._sheetE == null) {
                this._sheetE = new SheetElement();
            }
            parser = this._sheetE;
        } else if ("KingdeeDefined".equals(KmlUtil.getLocalName(qName))) {
            if (this._kdE == null) {
                this._kdE = new KingdeeDefinedElement();
            }
            parser = this._kdE;
        } else if ("Names".equals(KmlUtil.getLocalName(qName))) {
            if (this._namesE == null) {
                this._namesE = new NamesElement();
            }
            parser = this._namesE;
        } else if ("ExcelWorkbook".equals(KmlUtil.getLocalName(qName))) {
            if (this._excelE == null) {
                this._excelE = new ExcelWorkBookElement();
            }
            parser = this._excelE;
        } else {
            parser = null;
        }
        return parser;
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            Book book = dataCache.getBook();
            if (book == null) {
                book = Book.Manager.getNewBook(null, 0);
            }
            book.startGroup();
            book.setAutoCalculate(false);
            book.getUndoManager().enable(false);
            book.setA1Style(false);
            dataCache.setBook(book);
            dataCache.setCurUOParent(book);
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
        if (this.isCurrentElement(uri, localName, qName)) {
            Book book = dataCache.getBook();
            String sindex = dataCache.getActiveSheetIndex();
            int index = 0;
            if (!StringUtil.isEmptyString((String)sindex)) {
                index = Integer.parseInt(sindex);
            }
            book.activeSheet(index);
            book.endGroup();
            book.updatePendingSheet();
            BookProtection pro = dataCache.getBook().getProtection();
            if (pro.getOperations() != 0) {
                String eptPassword = dataCache.getEptPassword();
                pro.startWithEncryptedPassword(eptPassword);
            }
            HashMap names = dataCache.getNames();
            for (Object parent : names.keySet()) {
                Object aNames = names.get(parent);
                if (!(aNames instanceof HashMap)) continue;
                HashMap hm = (HashMap)aNames;
                for (String name : hm.keySet()) {
                    String refersTo = (String)hm.get(name);
                    if (parent instanceof Sheet) {
                        Sheet sheet = (Sheet)parent;
                        NamedObjectNode nod = sheet.getBook().getNames().searchByName(name);
                        if (nod != null) {
                            sheet.getBook().getNames().remove(nod);
                            sheet.getNames().insert(nod);
                            nod.setSheet(sheet);
                            nod.setExpr(sheet.getExpr(nod, refersTo));
                            continue;
                        }
                        try {
                            sheet.getRange(0, 0).setName(sheet.getSyntaxName() + "!" + name, refersTo);
                        }
                        catch (SyntaxErrorException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (!(parent instanceof Book)) continue;
                    NamedObjectNode nod = book.getNames().searchByName(name);
                    if (nod != null) {
                        Expr expr = book.getActiveSheet().getExpr(nod, refersTo);
                        nod.setExpr(expr);
                        continue;
                    }
                    try {
                        book.getActiveSheet().getRange(0, 0).setName(name, refersTo);
                    }
                    catch (SyntaxErrorException e) {
                        e.printStackTrace();
                    }
                }
            }
            int size = book.getSheetCount();
            for (int i = 0; i < size; ++i) {
                book.getSheet(i).getConditionalFormats().reduce();
                book.getSheet(i).getValidations().reduce();
            }
            book.setAutoCalculate(true);
            book.getUndoManager().enable(true);
            book.setA1Style(true);
            book.clearEmptyCells();
        }
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Workbook".equals(KmlUtil.getLocalName(qName));
    }
}

