/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.ConditionalFormatElement;
import com.kingdee.bos.ctrl.excel.io.kml.DataValidationElement;
import com.kingdee.bos.ctrl.excel.io.kml.KingdeeDefinedElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.io.kml.NamesElement;
import com.kingdee.bos.ctrl.excel.io.kml.SheetOptionElement;
import com.kingdee.bos.ctrl.excel.io.kml.SheetTableElement;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SheetElement
extends BasicElement {
    private AbsElement _te;
    private AbsElement _soe;
    private AbsElement _namesE;
    private AbsElement _kdE;
    private AbsElement _dvE;
    private AbsElement conditionalFromatListElement;

    SheetElement() {
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Worksheet".equals(KmlUtil.getLocalName(qName));
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        if ("Table".equals(KmlUtil.getLocalName(qName))) {
            if (this._te == null) {
                this._te = new SheetTableElement();
            }
            return this._te;
        }
        if ("WorksheetOptions".equals(KmlUtil.getLocalName(qName))) {
            if (this._soe == null) {
                this._soe = new SheetOptionElement();
            }
            return this._soe;
        }
        if ("KingdeeDefined".equals(KmlUtil.getLocalName(qName))) {
            if (this._kdE == null) {
                this._kdE = new KingdeeDefinedElement();
            }
            return this._kdE;
        }
        if ("Names".equals(KmlUtil.getLocalName(qName))) {
            if (this._namesE == null) {
                this._namesE = new NamesElement();
            }
            return this._namesE;
        }
        if ("DataValidation".equals(KmlUtil.getLocalName(qName))) {
            if (this._dvE == null) {
                this._dvE = new DataValidationElement();
            }
            return this._dvE;
        }
        if ("conditionalFormatting".equals(KmlUtil.getLocalName(qName))) {
            if (null == this.conditionalFromatListElement) {
                this.conditionalFromatListElement = new ConditionalFormatElement();
            }
            return this.conditionalFromatListElement;
        }
        return null;
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            String isProtected;
            String id;
            String sheetName = attributes.getValue(KmlUtil.getNSName("Name", NS_SHEET));
            if (sheetName != null) {
                sheetName = KmlUtil.toBookString(sheetName);
            }
            Sheet sheet = new Sheet(dataCache.getBook(), sheetName);
            String isShowGridLines = attributes.getValue(KmlUtil.getNSName("Gridlines", NS_SHEET));
            if (!StringUtil.isEmptyString((String)isShowGridLines)) {
                sheet.getSheetOption().setShowHoriLines(Boolean.valueOf(isShowGridLines));
                sheet.getSheetOption().setShowVertLines(Boolean.valueOf(isShowGridLines));
            }
            if ((id = attributes.getValue(KmlUtil.getNSName("ID", NS_SHEET))) != null) {
                id = KmlUtil.toBookString(id);
                sheet.setID(id);
            }
            if ("1".equals(isProtected = attributes.getValue(KmlUtil.getNSName("Protected", NS_SHEET)))) {
                sheet.getSheetOption().getProtection(true).start();
            }
            dataCache.getBook().addSheet(sheet, false);
            dataCache.setCurSheet(sheet);
            dataCache.setCurUOParent(sheet);
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }
}

