/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;

public class SheetAction_Clear
extends SheetAction {
    private boolean _formula;
    private boolean _value;
    private boolean _format;
    private boolean _comment;
    private String[] _userKeys;
    boolean isClosedAutoFilter = false;

    public SheetAction_Clear(Range rg, boolean formula, boolean value, boolean format, boolean comment, String[] userKeys) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style | SheetChangeEvent.Changed_Resize);
        this._formula = formula;
        this._value = value;
        this._format = format;
        this._comment = comment;
        if (userKeys != null) {
            this._userKeys = new String[userKeys.length];
            KDToolkit.arraycopy((Object[])userKeys, (int)0, (Object[])this._userKeys, (int)0, (int)userKeys.length);
        } else {
            this._userKeys = null;
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        Protection pro;
        boolean bState;
        boolean bl = bState = state != null;
        if (this._format) {
            SortedCellBlockArray mergeBlocks;
            MergeBlocks merger = sheet.getMerger(false);
            SortedCellBlockArray sortedCellBlockArray = mergeBlocks = merger == null ? null : merger.getTouchedBlocks(cb);
            if (mergeBlocks != null) {
                merger.remove(mergeBlocks);
                if (bState) {
                    state.setData("MERGE_BLOCKS", (Object)mergeBlocks);
                }
            }
        }
        boolean isProtected = (pro = sheet.getSheetOption().getProtection(false)) != null && pro.isProtected();
        ObjectArray clls = bState ? (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null) : null;
        Sheet.ICellsIterator i = sheet.getCellsIterator(cb, false, false);
        while (i.hasNext()) {
            Cell cll = i.next();
            if (isProtected && cll.isLocked()) continue;
            cll = cll.clear(this._formula, this._value, this._format, this._comment, this._userKeys);
            if (!bState || cll == null) continue;
            clls.append((Object)cll);
        }
        if (this._value && this._formula && this._comment && this._format) {
            SortedCellBlockArray scba = new SortedCellBlockArray();
            scba.insert(CellBlock.getNewCellBlock(cb));
            sheet.getConditionalFormats().insertConditionalFormat(new Condition[0], (ShareStyleAttributes[])new StyleAttributes[0], scba);
            scba = new SortedCellBlockArray();
            scba.insert(CellBlock.getNewCellBlock(cb));
            sheet.getValidations().insertValidation(null, scba);
        }
        if (this._format) {
            SortedSpanArray aChanged;
            boolean bEntireRow = cb.isRow();
            boolean bEntireCol = cb.isCol();
            if (bEntireRow && bEntireCol) {
                this.URStore(state, "SHEET_SSA", sheet.getSSA());
                sheet.setSSA(sheet.getBook().getSSA());
            }
            if (bEntireRow) {
                aChanged = sheet.getRowSpans().clearStyle(cb.getRowSpan(), true);
                this.URStore(state, "ROW_SSA", (Object)aChanged);
            }
            if (bEntireCol) {
                aChanged = sheet.getColSpans().clearStyle(cb.getColSpan(), true);
                this.URStore(state, "COL_SSA", (Object)aChanged);
            }
            Borders bdrs = sheet.getBorders();
            Borders bdrsBak = bState ? new Borders(sheet) : null;
            bdrs.clearOuter(cb, bdrsBak);
            if (!cb.isSingleCell()) {
                bdrs.clearInner(cb, bdrsBak);
            }
            if (bdrsBak != null && !bdrsBak.isEmpty() && this.URStore(state, "BDR", bdrsBak)) {
                sheet.clearStyleCache(cb);
            }
        }
    }

    private void checkedAutoFilter(URState state, Sheet sheet, CellBlock block) {
        CellBlock autofilterArea = sheet.getAutoFilterArea();
        if (autofilterArea == null) {
            return;
        }
        if (block.contains(new CellBlock(autofilterArea.getRow(), autofilterArea.getCol(), autofilterArea.getRow(), autofilterArea.getCol2()))) {
            this.isClosedAutoFilter = true;
        }
    }

    private void updateAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        if (this.isClosedAutoFilter) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        CellBlock newArea = CellBlock.getNewCellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        Borders bdrs;
        SortedCellBlockArray mergeBlocks;
        ShareStyleAttributes sheetSSA = (ShareStyleAttributes)state.get("SHEET_SSA");
        if (sheetSSA != null) {
            sheet.setSSA(sheetSSA);
        }
        sheet.getRowSpans().setSpans((SortedSpanArray)((Object)state.get("ROW_SSA")));
        sheet.getColSpans().setSpans((SortedSpanArray)((Object)state.get("COL_SSA")));
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            int size = clls.size();
            for (int i = 0; i < size; ++i) {
                Cell cll = (Cell)clls.get(i);
                Cell dstCell = sheet.getCell(cll.getRow(), cll.getCol(), true);
                dstCell.resumeClear(cll, this._formula, this._value, this._format, this._comment, this._userKeys);
                dstCell.queue();
            }
        }
        if ((mergeBlocks = (SortedCellBlockArray)((Object)state.get("MERGE_BLOCKS"))) != null) {
            sheet.getMerger(true).addAll(mergeBlocks);
        }
        if ((bdrs = (Borders)state.get("BDR")) != null) {
            sheet.getBorders().set(bdrs);
        }
        this.resumeAutoFilter(sheet, state);
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"clear", AbstractUndoableEdit.class, (String)"\u6e05\u9664 ") + super.getPresentationName();
    }
}

