/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.List;

public class SheetAction_InsertValidation
extends SheetAction {
    private MessagedValidate validation;
    private static final String STATE_KEY = "_validations";

    public SheetAction_InsertValidation(Range rg, MessagedValidate mv) {
        super(rg, SheetChangeEvent.Changed_Validation_Insert);
        this.validation = mv;
    }

    public static String getURStateKey(Sheet sheet) {
        return sheet.getSheetName() + STATE_KEY;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        ValidationList list = sheet.getValidations();
        ArrayList<Validation> sheetValidation = new ArrayList<Validation>();
        for (int i = 0; i < list.size(); ++i) {
            sheetValidation.add(list.getValidation(i).getCloneValidation());
        }
        this.URStore(state, SheetAction_InsertValidation.getURStateKey(sheet), sheetValidation);
        SortedCellBlockArray array = new SortedCellBlockArray();
        array.insert(cb);
        list.insertValidation(this.validation, array);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        List sheetValidation = (List)state.get(SheetAction_InsertValidation.getURStateKey(sheet));
        if (null != sheetValidation) {
            ValidationList list = sheet.getValidations();
            list.clearAll();
            for (int i = 0; i < sheetValidation.size(); ++i) {
                list.addValidation((Validation)sheetValidation.get(i));
            }
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Validation_Reset);
        }
    }
}

