/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.node;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.IVarReferences;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;

public class CellBlockNode
extends CellBlock
implements IExprNode,
Cloneable,
IVarReferences {
    public static final int ABS_Row = 1;
    public static final int ABS_Col = 2;
    public static final int ABS_Row2 = 4;
    public static final int ABS_Col2 = 8;
    public static final int ABS_All = 15;
    protected Sheet _sheet;
    private Object _refs;
    private Cell _firstCell;
    private Variant _varThis;
    protected int _flags;

    public static CellBlockNode getNewBlock(Sheet sheet, int row, int col, int row2, int col2, int flags) {
        return new CellBlockNode(sheet, row, col, row2, col2, flags);
    }

    public static CellBlockNode getClone(CellBlockNode cb) {
        return (CellBlockNode)cb.clone();
    }

    public static int getAbsFlags(boolean absRow, boolean absCol, boolean absRow2, boolean absCol2) {
        int flags = 0;
        if (absRow) {
            flags |= 1;
        }
        if (absCol) {
            flags |= 2;
        }
        if (absRow2) {
            flags |= 4;
        }
        if (absCol2) {
            flags |= 8;
        }
        return flags;
    }

    protected CellBlockNode(Sheet sheet, int row, int col, int row2, int col2, int flags) {
        super(row, col, row2, col2);
        this._sheet = sheet;
        this._flags = flags;
    }

    public Variant getVarThis() {
        if (this._varThis == null) {
            this._varThis = new Variant((Object)this, 18);
        }
        return this._varThis;
    }

    @Override
    public Object clone() {
        CellBlockNode obj = (CellBlockNode)super.clone();
        obj._varThis = null;
        return obj;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public boolean isAbsolute() {
        return (this._flags & 0xF) == 15;
    }

    public void copyFrom(CellBlockNode src) {
        super.copyFrom(src);
        if (src == null) {
            return;
        }
        this._refs = src._refs;
        this._flags = src._flags;
    }

    @Override
    public void offset(int offsetY, int offsetX) {
        if (this._flags == 15) {
            return;
        }
        if (offsetY != 0) {
            if (!this.touchFlag(1)) {
                this.setRow(this._row + offsetY);
            }
            if (!this.touchFlag(4)) {
                this.setRow2(this._row2 + offsetY);
            }
            this._firstCell = null;
        }
        if (offsetX != 0) {
            if (!this.touchFlag(2)) {
                this.setCol(this._col + offsetX);
            }
            if (!this.touchFlag(8)) {
                this.setCol2(this._col2 + offsetX);
            }
            this._firstCell = null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellBlockNode) {
            CellBlockNode cmp = (CellBlockNode)obj;
            return this._sheet == cmp._sheet && this._flags == cmp._flags && super.equals(cmp);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        int cmp = super.compareTo(obj);
        if (cmp == 0) {
            if (obj instanceof CellBlockNode) {
                CellBlockNode node = (CellBlockNode)obj;
                cmp = this._flags > node._flags ? 1 : (this._flags < node._flags ? -1 : 0);
            } else {
                cmp = -1;
            }
        }
        return cmp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.touchFlag(1) ? (char)'1' : '0');
        sb.append(this.touchFlag(2) ? (char)'1' : '0');
        sb.append(this.touchFlag(4) ? (char)'1' : '0');
        sb.append(this.touchFlag(8) ? (char)'1' : '0');
        sb.append(' ');
        sb.append(this._sheet.getSyntaxName());
        sb.append('!');
        this.getBlockName(sb, null);
        return sb.toString();
    }

    @Override
    public int getExprType() {
        return 4;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        String sheetName = this._sheet.getSheetName();
        Sheet sheet = this._sheet.getBook().getSheet(sheetName);
        if (sheet == null) {
            Variant var = Variant.badReference;
            ctx.getCurrentExprStack().push(var);
            return;
        }
        if (sheet != null && !this._sheet.equals(sheet)) {
            this._sheet = sheet;
        }
        this._sheet.setDependent(exprOwner, this);
        boolean queueLast = false;
        boolean isNeedCalc = false;
        Dependents deps = this._sheet.getDeps();
        if (this.isSingleCell()) {
            Cell referTo = this._sheet.getCell(this._row, this._col, false);
            if (referTo != null && !(queueLast = referTo.isQueueLast())) {
                deps.calcReferTo(referTo);
                isNeedCalc = referTo.isNeedRecalc();
            }
        } else {
            Cell referTo;
            Sheet.ICellsIterator ci = this._sheet.getCellsIterator(this, false, true);
            while (ci.hasNext() && !(queueLast |= (referTo = ci.next()).isQueueLast())) {
                deps.calcReferTo(referTo);
                isNeedCalc |= referTo.isNeedRecalc();
            }
        }
        if (isNeedCalc && exprOwner instanceof NamedObjectNode) {
            throw SyntaxErrorException.CALC_LAST;
        }
        Variant var = queueLast ? Variant.calcLast : this.getVarThis();
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        if (this.isRowColReversed() || this.isRowColInvalid()) {
            return ExprErr.getString((long)262144L);
        }
        StringBuffer sb = new StringBuffer();
        if (this._sheet.isDisposed()) {
            sb.append("'#REF'!");
        } else if (!this._sheet.equals(exprOwner.getSheet())) {
            sb.append(this._sheet.getSyntaxName());
            sb.append('!');
        }
        this.getBlockName(sb, exprOwner);
        return sb.toString();
    }

    public Variant getValue() {
        Cell referTo;
        Variant var = this.isRowColReversed() || this.isRowColInvalid() || this._sheet.isDisposed() ? new Variant((Object)new SyntaxErrorException(262144L), 16) : (this.isSingleCell() ? ((referTo = this._sheet.getCell(this._row, this._col, false)) == null ? Variant.nullVariant : referTo.getValue()) : this.getVarThis());
        return var;
    }

    public String getBlockName(boolean bA1Style, CellBlock block) {
        int baseRow = block == null ? 0 : block.getRow();
        int baseCol = block == null ? 0 : block.getCol();
        return this.getBlockName(bA1Style, baseRow, baseCol);
    }

    public String getBlockName(boolean bA1Style, Cell cll) {
        int baseRow = cll == null ? 0 : cll.getRow();
        int baseCol = cll == null ? 0 : cll.getCol();
        return this.getBlockName(bA1Style, baseRow, baseCol);
    }

    private String getBlockName(boolean bA1Style, int baseRow, int baseCol) {
        boolean isAll;
        StringBuffer sb = new StringBuffer();
        boolean isRow = this.isRow();
        boolean isCol = this.isCol();
        boolean bl = isAll = isRow && isCol;
        if (bA1Style) {
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(this._col, 0, true, this.touchFlag(2)));
            }
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(this._row, 0, true, this.touchFlag(1)));
            }
            if (!this.isSingleCell()) {
                sb.append(':');
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(this._col2, 0, true, this.touchFlag(8)));
                }
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(this._row2, 0, true, this.touchFlag(4)));
                }
            }
        } else {
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(this._row, baseRow, false, this.touchFlag(1)));
            }
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(this._col, baseCol, false, this.touchFlag(2)));
            }
            if (!this.isSingleCell()) {
                sb.append(':');
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(this._row2, baseRow, false, this.touchFlag(4)));
                }
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(this._col2, baseCol, false, this.touchFlag(8)));
                }
            }
        }
        return sb.toString();
    }

    private void getBlockName(StringBuffer sb, ICalculable exprOwner) {
        boolean bA1Style = this._sheet.getDeps().isA1Style();
        if ((this._flags & 0xF) == 15) {
            sb.append(this.getBlockName(bA1Style, (Cell)null));
        } else if (exprOwner instanceof Cell) {
            sb.append(this.getBlockName(bA1Style, (Cell)exprOwner));
        } else if (exprOwner instanceof CellBlock) {
            sb.append(this.getBlockName(bA1Style, (CellBlock)((Object)exprOwner)));
        } else {
            sb.append(this.getBlockName(bA1Style, (Cell)null));
        }
    }

    public Object getRefs() {
        return this._refs;
    }

    public void setRefs(Object refs) {
        this._refs = refs;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    public Cell getFirstCell(boolean create) {
        if (this._firstCell == null) {
            this._firstCell = this._sheet.getCell(this._row, this._col, create);
        }
        return this._firstCell;
    }

    public Sheet.ICellsIterator getCellsIterator(boolean bDescend, boolean forContentCell) {
        return this._sheet.getCellsIterator(this, bDescend, forContentCell);
    }

    public void queue(boolean updateFormula) {
        if (this._refs == null) {
            return;
        }
        boolean queueRefer = this._sheet.getBook().isAutoCalculate();
        Dependents deps = this._sheet.getDeps();
        if (this._refs instanceof ICalculable) {
            ICalculable node = (ICalculable)this._refs;
            if (!node.isQueued()) {
                node.setNeedRecalc(true);
                deps.queue(node, queueRefer, updateFormula);
            }
            if (updateFormula) {
                node.updateFormula();
            }
        } else {
            SortedObjectArray sa = (SortedObjectArray)this._refs;
            int count = sa.size();
            for (int i = 0; i < count; ++i) {
                ICalculable node = (ICalculable)sa.get(i);
                if (!node.isQueued()) {
                    node.setNeedRecalc(true);
                    deps.queue(node, queueRefer, updateFormula);
                }
                if (!updateFormula) continue;
                node.updateFormula();
            }
        }
    }
}

