/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;

public class ObjectStack {
    static final long serialVersionUID = -6665676479322842737L;
    private static final int Stack_InitSize = 10;
    private Object[] _array = new Object[10];
    private int _count = 0;

    public void push(Object obj) {
        if (this._count >= this._array.length) {
            Object[] newArray = new Object[(int)((double)this._array.length * 1.5)];
            System.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
        }
        this._array[this._count++] = obj;
    }

    public Object pop() {
        if (this._count-- == 0) {
            throw new EmptyStackException();
        }
        Object obj = this._array[this._count];
        this._array[this._count] = null;
        return obj;
    }

    public void popN(int n) {
        if (n < 1) {
            return;
        }
        int newCount = this._count - n;
        if (newCount < 0) {
            throw new EmptyStackException();
        }
        Arrays.fill(this._array, newCount, this._count, null);
        this._count = newCount;
    }

    public Object[] getArray() {
        Object[] newArray = new Object[this._count];
        System.arraycopy(this._array, 0, newArray, 0, this._count);
        return newArray;
    }

    public List getReversedList() {
        List<Object> list = Arrays.asList(this.getArray());
        Collections.reverse(list);
        return list;
    }

    public final void clear() {
        if (this._count > 0) {
            Arrays.fill(this._array, 0, this._count, null);
            this._count = 0;
        }
    }

    public final int size() {
        return this._count;
    }

    public final boolean isEmpty() {
        return this._count == 0;
    }

    public Object getAt(int index) {
        return this._array[index];
    }

    public Object getTop() {
        return this._count > 0 ? this._array[this._count - 1] : null;
    }

    public String toString() {
        if (this._count > 0) {
            ArrayList<Object> al = new ArrayList<Object>(this._count);
            for (int i = 0; i < this._count; ++i) {
                al.add(this._array[i]);
            }
            return al.toString();
        }
        return "";
    }
}

