/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.servertable;

class KDTMark {
    public static final int TREE_LEVEL_MARK = 255;
    public static final int COLLAPSE_MARK = 256;
    public static final int HIDE_MARK = 512;
    public static final int MERGE_MARK = 1024;
    public static final int GROUP_MARK = 2048;
    public static final int RESIZE_MARK = 4096;
    public static final int MOVE_MARK = 8192;
    public static final int STAT_MARK = 16384;
    public static final int CHANGE_MARK = 32768;
    public static final int INITIAL_VALUE = 13312;

    KDTMark() {
    }

    public static boolean isHide(int mark) {
        return (mark & 0x200) != 0;
    }

    public static int setHide(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x200) : (mark &= 0xFFFFFDFF);
        return mark;
    }

    public static boolean isChange(int mark) {
        return (mark & 0x8000) != 0;
    }

    public static int setChange(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x8000) : (mark &= 0xFFFF7FFF);
        return mark;
    }

    public static boolean isMergeable(int mark) {
        return (mark & 0x400) != 0;
    }

    public static int setMergeable(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x400) : (mark &= 0xFFFFFBFF);
        return mark;
    }

    public static boolean isGroupable(int mark) {
        return (mark & 0x800) != 0;
    }

    public static int setGroupable(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x800) : (mark &= 0xFFFFF7FF);
        return mark;
    }

    public static boolean isMoveable(int mark) {
        return (mark & 0x2000) != 0;
    }

    public static int setMoveable(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x2000) : (mark &= 0xFFFFDFFF);
        return mark;
    }

    public static boolean isResizeable(int mark) {
        return (mark & 0x1000) != 0;
    }

    public static int setResizeable(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x1000) : (mark &= 0xFFFFEFFF);
        return mark;
    }

    public static boolean isStat(int mark) {
        return (mark & 0x4000) != 0;
    }

    public static int setStat(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x4000) : (mark &= 0xFFFFBFFF);
        return mark;
    }

    public static boolean isCollapse(int mark) {
        return (mark & 0x100) != 0;
    }

    public static int setCollapse(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x100) : (mark &= 0xFFFFFEFF);
        return mark;
    }

    public static int getTreeLevel(int mark) {
        return mark & 0xFF;
    }

    public static int setTreeLevel(int mark, int treeLevel) {
        mark &= 0xFFFFFF00;
        return mark |= (treeLevel &= 0xFF);
    }
}

