/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.AbstractTableTravelPolicy;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;

public final class DataBlockJumpByColumn
extends AbstractTableTravelPolicy {
    private KDTCellIndex cellIndex = new KDTCellIndex();
    KDTSelectManager sman = this.table.getSelectManager();

    public DataBlockJumpByColumn(KDTable table) {
        super(table);
    }

    @Override
    public KDTCellIndex nextCellIndex(int rowIndex, int colIndex) {
        this.cellIndex.setColIndex(colIndex);
        int maxRowIndex = this.table.getExpandedRowCount() - 1;
        if (maxRowIndex < rowIndex) {
            maxRowIndex = rowIndex;
        }
        boolean flag = this.isNullCell(rowIndex, colIndex);
        int nextRowIndex = this.sman.nextRowIndex(rowIndex, colIndex);
        if (nextRowIndex < maxRowIndex) {
            if (flag) {
                while (rowIndex < maxRowIndex && this.isNullCell(rowIndex, colIndex)) {
                    rowIndex = this.sman.nextRowIndex(rowIndex, colIndex);
                }
            } else if (this.isNullCell(nextRowIndex, colIndex)) {
                rowIndex = nextRowIndex + 1;
                while (rowIndex < maxRowIndex && this.isNullCell(rowIndex, colIndex)) {
                    rowIndex = this.sman.nextRowIndex(rowIndex, colIndex);
                }
            } else {
                rowIndex = nextRowIndex + 1;
                while (rowIndex < maxRowIndex) {
                    if (this.isNullCell(rowIndex, colIndex)) {
                        --rowIndex;
                        break;
                    }
                    rowIndex = this.sman.nextRowIndex(rowIndex, colIndex);
                }
            }
        } else {
            rowIndex = nextRowIndex;
        }
        if (rowIndex > maxRowIndex) {
            rowIndex = maxRowIndex;
        }
        this.cellIndex.setRowIndex(rowIndex);
        return this.cellIndex;
    }

    @Override
    public KDTCellIndex previousCellIndex(int rowIndex, int colIndex) {
        this.cellIndex.setColIndex(colIndex);
        boolean flag = this.isNullCell(rowIndex, colIndex);
        int preRowIndex = this.sman.previousRowIndex(rowIndex, colIndex);
        if (preRowIndex > 0) {
            if (flag) {
                while (rowIndex > 0 && this.isNullCell(rowIndex, colIndex)) {
                    rowIndex = this.sman.previousRowIndex(rowIndex, colIndex);
                }
            } else if (this.isNullCell(preRowIndex, colIndex)) {
                rowIndex = preRowIndex - 1;
                while (rowIndex > 0 && this.isNullCell(rowIndex, colIndex)) {
                    rowIndex = this.sman.previousRowIndex(rowIndex, colIndex);
                }
            } else {
                rowIndex = preRowIndex - 1;
                while (rowIndex > 0) {
                    if (this.isNullCell(rowIndex, colIndex)) {
                        ++rowIndex;
                        break;
                    }
                    rowIndex = this.sman.previousRowIndex(rowIndex, colIndex);
                }
            }
        } else {
            rowIndex = preRowIndex;
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        this.cellIndex.setRowIndex(rowIndex);
        return this.cellIndex;
    }

    private boolean isNullCell(int rowIndex, int colIndex) {
        ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
        if (cell.getMergeBlock() == null) {
            return null == this.table.getRow(rowIndex).getCell(colIndex).getValue();
        }
        KDTMergeBlock block = cell.getMergeBlock();
        return null == this.table.getRow(block.getTop()).getCell(block.getLeft()).getValue();
    }
}

