/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public class KDTCellSelectAction
extends KDTAbstractAction {
    private static final long serialVersionUID = 362251884020341942L;
    public static final short DIR_UP = 0;
    public static final short DIR_DOWN = 1;
    public static final short DIR_LEFT = 2;
    public static final short DIR_RIGHT = 3;
    public static final short DIR_LEFTEST = 4;
    public static final short DIR_RIGHTEST = 5;
    public static final short DIR_LEFT_TOP = 6;
    public static final short DIR_RIGHT_BOTTOM = 7;
    protected short dirCode;
    protected boolean isAdd;
    protected boolean isAddRow = false;
    protected Action actionAfterAddRow = null;

    public KDTCellSelectAction(KDTable table, short dirCode, boolean isAdd) {
        super(table);
        this.dirCode = dirCode;
        this.isAdd = isAdd;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KDTEditManager em = this.table.getEditManager();
        if (em.isEditing()) {
            if ((this.dirCode == 0 || this.dirCode == 1 || this.dirCode == 6 || this.dirCode == 7 || this.dirCode == 2 || this.dirCode == 3 || this.dirCode == 4 || this.dirCode == 5) && em.getEditorComponent() != null && em.getEditorComponent() instanceof KDBizPromptBox && ((KDBizPromptBox)em.getEditorComponent()).hasDownPanel()) {
                return;
            }
            if (em.stopEditing() != 0) {
                return;
            }
        }
        KDTSelectManager selectMan = this.table.getSelectManager();
        int selectMode = selectMan.getCellSelectMode();
        int rowCount = this.table.getRowCount1();
        int colCount = this.table.getColumnCount();
        if (rowCount <= 0 && colCount <= 0) {
            return;
        }
        if (rowCount <= 0) {
            if (this.dirCode == 0 || this.dirCode == 1 || this.dirCode == 6 || this.dirCode == 7 || !selectMan.isColumnSelectable()) {
                return;
            }
            selectMode = 4;
        }
        if (colCount <= 0) {
            if (this.dirCode == 2 || this.dirCode == 3 || this.dirCode == 4 || this.dirCode == 5 || !selectMan.isRowSelectable()) {
                return;
            }
            selectMode = 2;
        }
        if (!this.isAdd) {
            int verticalIndex = this.table.getViewManager().getVerticalIndex(selectMan.getActiveViewIndex());
            int horizonIndex = this.table.getViewManager().getHorizonIndex(selectMan.getActiveViewIndex());
            int activeRow = selectMan.getActiveRowIndex();
            int activeCol = selectMan.getActiveColumnIndex();
            if (this.isAddRow && activeRow == rowCount - 1 && this.dirCode == 1) {
                this.table.addRow();
                rowCount = this.table.getRowCount1();
                if (this.actionAfterAddRow != null) {
                    ActionEvent evt = new ActionEvent(this.table, 0, "");
                    this.actionAfterAddRow.actionPerformed(evt);
                }
            }
            if (!this.canTravel(activeRow, activeCol)) {
                return;
            }
            int rowIndex = 0;
            int colIndex = 0;
            switch (this.dirCode) {
                case 0: {
                    rowIndex = selectMan.previousRowIndex(activeRow, activeCol);
                    colIndex = activeCol;
                    break;
                }
                case 1: {
                    rowIndex = selectMan.nextRowIndex(activeRow, activeCol);
                    colIndex = activeCol;
                    break;
                }
                case 2: {
                    rowIndex = activeRow;
                    int firstCol = KDTableUtil.getFirstVisibleColumnIndex(this.table);
                    int preCol = selectMan.previousColIndex(activeRow, activeCol);
                    if (preCol >= firstCol) {
                        colIndex = preCol;
                        break;
                    }
                    colIndex = firstCol;
                    break;
                }
                case 3: {
                    rowIndex = activeRow;
                    int lastCol = KDTableUtil.getLastVisibleColumnIndex(this.table);
                    int nextCol = selectMan.nextColIndex(activeRow, activeCol);
                    if (nextCol <= lastCol) {
                        colIndex = nextCol;
                        break;
                    }
                    colIndex = lastCol;
                    break;
                }
                case 4: {
                    rowIndex = activeRow;
                    colIndex = KDTableUtil.getFirstVisibleColumnIndex(this.table);
                    break;
                }
                case 5: {
                    rowIndex = activeRow;
                    colIndex = KDTableUtil.getLastVisibleColumnIndex(this.table);
                    break;
                }
                case 6: {
                    rowIndex = 0;
                    colIndex = 0;
                    break;
                }
                case 7: {
                    int exRowCount = this.table.getExpandedRowCount();
                    int exColCount = this.table.getExpandedColumnCount();
                    rowIndex = exRowCount - 1;
                    colIndex = exColCount - 1;
                    if (rowIndex < activeRow) {
                        rowIndex = activeRow;
                    }
                    if (colIndex >= activeCol) break;
                    colIndex = activeCol;
                    break;
                }
            }
            rowIndex = this.keepInBound(rowIndex, rowCount - 1, 0);
            colIndex = this.keepInBound(colIndex, colCount - 1, 0);
            this.table.getLayoutManager().getVertical(verticalIndex).scrollToShowRow(rowIndex);
            this.table.getLayoutManager().getHorizon(horizonIndex).scrollToShowCol(colIndex);
            selectMan.select(rowIndex, colIndex, rowIndex, colIndex, selectMode);
        } else {
            int blockIndex = selectMan.getBlockIndexActiveCellIn();
            KDTSelectBlock block = selectMan.getOrigin(blockIndex);
            int beginRow = block.getBeginRow();
            int endRow = block.getEndRow();
            int beginCol = block.getBeginCol();
            int endCol = block.getEndCol();
            selectMan.savePrevBlockCopy(block);
            switch (this.dirCode) {
                case 0: {
                    int i;
                    int saveRow = endRow;
                    int theRow = endRow;
                    for (i = block.getLeft(); i <= block.getRight(); ++i) {
                        theRow = selectMan.previousRowIndex(saveRow, i);
                        if (endRow <= (theRow = this.keepInBound(theRow, rowCount - 1, 0))) continue;
                        endRow = theRow;
                    }
                    break;
                }
                case 1: {
                    int i;
                    int saveRow = endRow;
                    int theRow = endRow;
                    for (i = block.getLeft(); i <= block.getRight(); ++i) {
                        theRow = selectMan.nextRowIndex(saveRow, i);
                        if (endRow >= (theRow = this.keepInBound(theRow, rowCount - 1, 0))) continue;
                        endRow = theRow;
                    }
                    break;
                }
                case 2: {
                    int i;
                    int saveCol = endCol;
                    int theCol = endCol;
                    for (i = block.getTop(); i <= block.getBottom(); ++i) {
                        theCol = selectMan.previousColIndex(i, saveCol);
                        if (endCol <= (theCol = this.keepInBound(theCol, colCount - 1, 0))) continue;
                        endCol = theCol;
                    }
                    break;
                }
                case 3: {
                    int i;
                    int saveCol = endCol;
                    int theCol = endCol;
                    for (i = block.getTop(); i <= block.getBottom(); ++i) {
                        theCol = selectMan.nextColIndex(i, saveCol);
                        if (endCol >= (theCol = this.keepInBound(theCol, colCount - 1, 0))) continue;
                        endCol = theCol;
                    }
                    break;
                }
                case 4: {
                    endCol = 0;
                    break;
                }
                case 5: {
                    endCol = colCount - 1;
                    break;
                }
            }
            beginRow = this.keepInBound(beginRow, rowCount - 1, 0);
            endRow = this.keepInBound(endRow, rowCount - 1, 0);
            beginCol = this.keepInBound(beginCol, colCount - 1, 0);
            endCol = this.keepInBound(endCol, colCount - 1, 0);
            int verticalIndex = this.table.getViewManager().getVerticalIndex(selectMan.getActiveViewIndex());
            int horizonIndex = this.table.getViewManager().getHorizonIndex(selectMan.getActiveViewIndex());
            this.table.getLayoutManager().getVertical(verticalIndex).scrollToShowRow(endRow);
            this.table.getLayoutManager().getHorizon(horizonIndex).scrollToShowCol(endCol);
            KDTSelectBlock sb = new KDTSelectBlock();
            sb.setTop(beginRow);
            sb.setLeft(beginCol);
            sb.setBottom(endRow);
            sb.setRight(endCol);
            sb.setMode(selectMode);
            selectMan.set(blockIndex, sb, false);
        }
    }

    private int keepInBound(int value, int max, int min) {
        if (max < min) {
            int temp = max;
            max = min;
            min = temp;
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    private boolean canTravel(int rowIndex, int colIndex) {
        if (!this.isOnlySingleCellBolck()) {
            return true;
        }
        if (this.dirCode == 0 && rowIndex <= 0) {
            return false;
        }
        if (this.dirCode == 2 && colIndex <= 0) {
            return false;
        }
        if (this.dirCode == 4 && colIndex <= 0) {
            return false;
        }
        if (this.dirCode == 6 && rowIndex <= 0 && colIndex <= 0) {
            return false;
        }
        int rowCount = this.table.getRowCount1();
        int colCount = this.table.getColumnCount();
        if (this.dirCode == 1 && rowIndex >= rowCount - 1) {
            return false;
        }
        if (this.dirCode == 3 && colIndex >= colCount - 1) {
            return false;
        }
        if (this.dirCode == 5 && colIndex >= colCount - 1) {
            return false;
        }
        return this.dirCode != 7 || rowIndex < rowCount - 1 || colIndex < colCount - 1;
    }

    private boolean isOnlySingleCellBolck() {
        if (this.table.getSelectManager().getBlocks().size() != 1) {
            return false;
        }
        KDTSelectBlock block = this.table.getSelectManager().get();
        return block.getBeginCol() == block.getEndCol() && block.getBeginRow() == block.getEndRow();
    }

    public boolean isAddRow() {
        return this.isAddRow;
    }

    public void setAddRow(boolean isAddRow) {
        this.isAddRow = isAddRow;
    }

    public Action getActionAfterAddRow() {
        return this.actionAfterAddRow;
    }

    public void setActionAfterAddRow(Action actionAfterAddRow) {
        this.actionAfterAddRow = actionAfterAddRow;
    }
}

