/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.table.IExceptionHandler;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class KDTMenuManager {
    public static int EXPORT_MAX_ROW = 10000;
    protected KDPopupMenu menu;
    protected KDTable table;
    protected int clickCount = 1;
    protected int button = 3;

    public KDTMenuManager() {
    }

    public KDTMenuManager(KDTable table) {
        this.table = table;
        table.addKDTMouseListener(new KDTMouseListener(){

            @Override
            public void tableClicked(KDTMouseEvent e) {
                if (e.getButton() == KDTMenuManager.this.getButton() && e.getClickCount() == KDTMenuManager.this.getClickCount() && KDTMenuManager.this.getMenu() != null && KDTMenuManager.this.getMenu().getComponents().length != 0) {
                    KDTMenuManager.this.getMenu().show(e.getOriginView(), e.getX(), e.getY());
                }
            }
        });
    }

    protected KDPopupMenu createDefaultMenu() {
        KDPopupMenu menu = new KDPopupMenu();
        return menu;
    }

    public void loadDefaultAction() {
        KDPopupMenu menu = this.getMenu();
        KDMenuItem item1 = new KDMenuItem();
        ExportAction action1 = new ExportAction();
        action1.putValue("Name", LanguageManager.getLangMessage((String)"Export", KDTMenuManager.class, (String)"Export to EXCEL"));
        item1.setAction((Action)action1);
        menu.add((JMenuItem)item1);
        KDMenuItem item2 = new KDMenuItem();
        ExportSelectAction action2 = new ExportSelectAction();
        action2.putValue("Name", LanguageManager.getLangMessage((String)"ExportSelection", KDTMenuManager.class, (String)"Export selection to EXCEL"));
        item2.setAction((Action)action2);
        menu.add((JMenuItem)item2);
    }

    public static File createSpreadSheetTempFile(String filePath) {
        File file = null;
        if (filePath != null && (file = new File(filePath)).isFile()) {
            file = file.getParentFile();
        }
        try {
            file = File.createTempFile("tmp", ".xml", file);
        }
        catch (IOException e) {
            try {
                file = File.createTempFile("tmp", ".xml");
            }
            catch (IOException e1) {
                file = null;
            }
        }
        return file;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(int clickCount) {
        this.clickCount = clickCount;
    }

    public KDPopupMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.createDefaultMenu();
        }
        return this.menu;
    }

    public void setMenu(KDPopupMenu menu) {
        this.menu = menu;
    }

    public String getTempFile() {
        return this.table.getIOManager().getTempFileDirection();
    }

    public void setTempFile(String tempFile) {
        this.table.getIOManager().setTempFileDirection(tempFile);
    }

    public IExceptionHandler getExceptionHandler() {
        return this.table.getIOManager().getExceptionHandler();
    }

    public void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.table.getIOManager().setExceptionHandler(exceptionHandler);
    }

    public static File createTempFile(String filePath) {
        File file = null;
        if (filePath != null && (file = new File(filePath)).isFile()) {
            file = file.getParentFile();
        }
        try {
            file = File.createTempFile("tmp", ".xls", file);
        }
        catch (IOException e) {
            try {
                file = File.createTempFile("tmp", ".xls");
            }
            catch (IOException e1) {
                file = null;
            }
        }
        return file;
    }

    public static void openFileInExcel(String file) throws IOException {
        Desktop.getDesktop().open(new File(file));
    }

    public static void openFileDir(String file) throws IOException {
        File f = new File(file);
        if (f != null) {
            if (!f.exists()) {
                throw new IOException("\u627e\u4e0d\u5230\u8def\u5f84");
            }
        } else {
            throw new IOException("\u627e\u4e0d\u5230\u8def\u5f84");
        }
        Runtime.getRuntime().exec("");
    }

    class ExportSelectAction
    extends ExportAction {
        private static final long serialVersionUID = 434934499231637423L;

        ExportSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTMenuManager.this.table.getIOManager().setTempFileDirection(KDTMenuManager.this.getTempFile());
            KDTMenuManager.this.table.getIOManager().exportExcelToTempFile(true);
        }
    }

    class ExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 7069846690510434242L;
        KDFileChooser fileChooser;

        @Override
        public void actionPerformed(ActionEvent e) {
            KDTMenuManager.this.table.getIOManager().setTempFileDirection(KDTMenuManager.this.getTempFile());
            KDTMenuManager.this.table.getIOManager().exportExcelToTempFile(false);
        }
    }
}

