/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.ITipContentProvider;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.TipPanel;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;

public class KDTVertical
extends KDTLayoutInfo
implements AdjustmentListener,
ITipContentProvider {
    private IRows rows;

    public KDTVertical(KDTable table) {
        this(table, false);
    }

    public KDTVertical(KDTable table, boolean hasScrollBar) {
        super(table, hasScrollBar);
    }

    public KDTVertical(KDTable table, JScrollBar vBar) {
        super(table, true);
        if (1 != vBar.getOrientation()) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u4e3aKDTVertical\u5bf9\u8c61\u8bbe\u7f6e\u975e\u7ad6\u76f4\u7684\u6eda\u52a8\u6761");
        }
        this.setScrollBar(vBar);
    }

    @Override
    public JScrollBar getScrollBar() {
        if (this.scrollable && this.scrollBar == null) {
            KDDBntScrollBar vBar = new KDDBntScrollBar(1);
            this.setScrollBar((JScrollBar)vBar);
        }
        return this.scrollBar;
    }

    @Override
    public void setScrollBar(JScrollBar scrollBar) {
        scrollBar.addAdjustmentListener(this);
        super.setScrollBar(scrollBar);
        if (this.table.getLayoutManager().isToolTipVisible()) {
            this.getToolTip().addComponent(scrollBar, this);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.table.getLayoutManager().isToolTipVisible()) {
            this.getToolTip().setText(LanguageManager.getLangMessage((String)"row", KDTVertical.class, (String)"Row:") + String.valueOf(e.getValue() + 1));
        }
        JScrollBar sb = (JScrollBar)e.getSource();
        if (!this.isTrackable() && sb.getValueIsAdjusting()) {
            return;
        }
        if (this.first == e.getValue()) {
            return;
        }
        if (!sb.getValueIsAdjusting()) {
            int index;
            int rows = this.table.getBody().size();
            int index2 = index = e.getValue();
            while (index2 < rows && index2 > 0 && this.table.getBody().getRowHeight(index2) <= 0) {
                if (index > this.first) {
                    ++index2;
                    continue;
                }
                --index2;
            }
            if (index != index2) {
                if (sb != null) {
                    DefaultBoundedRangeModel model = (DefaultBoundedRangeModel)sb.getModel();
                    if (index2 + model.getExtent() > model.getMaximum()) {
                        index2 = model.getMaximum() - model.getExtent();
                        this.scrollToPosition2(index2);
                        this.table.repaint();
                        return;
                    }
                    sb.setValue(index2);
                }
                return;
            }
        }
        this.scrollToPosition2(e.getValue());
    }

    public void onMouseWheelMoved(MouseWheelEvent event) {
        if (event.getScrollType() == 0) {
            JScrollBar sb = this.getScrollBar();
            if (sb != null && sb.isVisible()) {
                int totalScrollAmount = event.getUnitsToScroll();
                int value = sb.getValue() + totalScrollAmount;
                if (value < sb.getMinimum()) {
                    value = sb.getMinimum();
                }
                if (value > sb.getMaximum()) {
                    value = sb.getMaximum();
                }
                sb.setValue(value);
                this.table.repaint();
            }
            Object var2_2 = null;
        }
    }

    public void scrollToShowRow(int rowIndex) {
        int firstIndex;
        if (this.getFirst() <= rowIndex && this.getLast2() > rowIndex) {
            return;
        }
        if (rowIndex < this.getFirst()) {
            this.scrollToPosition(rowIndex);
            return;
        }
        int height = this.getSpan();
        if (height <= 0) {
            return;
        }
        int tableHeight = height;
        int rowHeight = 0;
        for (firstIndex = rowIndex; firstIndex >= 0; --firstIndex) {
            rowHeight = this.table.getBody().getRowHeight(firstIndex);
            if ((height -= rowHeight) >= 0) continue;
            if (tableHeight > rowHeight) break;
            --firstIndex;
            break;
        }
        this.scrollToPosition(++firstIndex);
    }

    public void scrollToNextPage() {
        if (this.getLast() == this.table.getRowCount() - 1) {
            return;
        }
        this.scrollToPosition(this.getFirstOfNextPage());
    }

    public int getFirstOfNextPage() {
        if (this.getLast() == this.table.getRowCount() - 1) {
            return this.getFirst();
        }
        return this.getLast2();
    }

    public int getFirstOfLastPage() {
        int firstIndex;
        if (this.getFirst() == 0) {
            return 0;
        }
        int height = this.getSpan();
        for (firstIndex = this.getFirst() - 1; firstIndex >= 0 && (height -= this.table.getBody().getRowHeight(firstIndex)) >= 0; --firstIndex) {
        }
        return ++firstIndex;
    }

    public void scrollToLastPage() {
        if (this.getFirst() == 0) {
            return;
        }
        this.scrollToPosition(this.getFirstOfLastPage());
    }

    private void scrollToPosition2(int index) {
        if (index < 0 || index >= this.table.getBody().virtualSize()) {
            return;
        }
        if (this.table.getEditManager().isEditing()) {
            this.table.getEditManager().stopEditing();
        }
        this.setFirst(index);
        this.repaint();
    }

    private void scrollByScrollBar(int value) {
        JScrollBar sb = this.getScrollBar();
        if (sb != null && sb.isVisible()) {
            if (value < sb.getMinimum()) {
                value = sb.getMinimum();
            }
            if (value > sb.getMaximum()) {
                value = sb.getMaximum();
            }
            sb.setValue(value);
            this.table.repaint();
        }
    }

    public void scrollToPosition(int index) {
        if (!this.isEnable()) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= this.table.getBody().virtualSize()) {
            index = this.table.getBody().virtualSize() - 1;
        }
        if (index >= this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()) {
            int block = this.scrollBar.getMaximum() - index - 1;
            if (block <= 0) {
                this.scrollBar.setVisibleAmount(0);
                this.scrollBar.setBlockIncrement(1);
            } else {
                this.scrollBar.setVisibleAmount(block);
                this.scrollBar.setBlockIncrement(block);
            }
        }
        this.scrollBar.setValue(index);
    }

    public void scrollToPrevUnit() {
        this.scrollToPosition(this.getFirst() - 1);
    }

    public void scrollToNextUnit() {
        this.scrollByScrollBar(this.getFirst() + 1);
    }

    public void scrollToPrevBlock() {
        this.scrollToPosition(this.getFirst() - 1);
    }

    public void scrollToNextBlock() {
        this.scrollToPosition(this.getLast2());
    }

    @Override
    public int getLast() {
        if (this.last == -1) {
            this.refresh();
        }
        return this.last;
    }

    @Override
    public int getLast2() {
        if (this.last == -1) {
            this.refresh();
        }
        return this.last2;
    }

    @Override
    protected void refresh() {
        if (!this.isCanRefresh()) {
            return;
        }
        this.calculateLast();
        this.adjustScrollBar(this.first);
    }

    void calculateLast() {
        int h;
        if (this.rows == null) {
            boolean isHead = this.index == 0;
            this.rows = isHead ? this.table.getHead() : this.table.getBody();
        }
        int rowIndex = this.first;
        int hs = 0;
        while ((h = this.rows.getRowHeight(rowIndex)) >= 0 && (hs += h) <= this.span) {
            ++rowIndex;
        }
        if (rowIndex == this.first && h == -1) {
            this.last = -2;
            this.last2 = -2;
        } else if (h == -1) {
            this.last = rowIndex - 1;
            this.last2 = this.last + 1;
        } else {
            this.last = rowIndex;
            this.last2 = hs == this.span ? this.last + 1 : this.last;
        }
    }

    public void repaint() {
        if (!this.table.enableRepaint) {
            return;
        }
        int hCount = this.table.getHorizonCount();
        for (int i = 0; i < hCount; ++i) {
            BasicView view = this.table.getViewManager().getView(this.index, i);
            view.updateBounds(true);
            view.repaint();
        }
    }

    @Override
    protected int getVisibleAmount() {
        int visible;
        int colIndex;
        int firstInAll = this.getFirstInAll();
        int lastInAll = this.getLastInAll();
        if (lastInAll < 0) {
            lastInAll = 0;
        }
        int width = 0;
        KDTBody body = this.table.getBody();
        for (colIndex = lastInAll; colIndex >= firstInAll; --colIndex) {
            KDTRow row = body.getRow2(colIndex);
            width = row == null ? (width += this.table.getDefaultRowHeight()) : (width += body.getRowHeight(colIndex));
            if (width > this.span) break;
        }
        return (visible = lastInAll - colIndex) <= 0 ? 1 : visible;
    }

    @Override
    public void setTipContent(TipPanel tip, MouseEvent evt) {
    }

    @Override
    public Object clone() {
        JScrollBar sb = this.getScrollBar();
        if (sb != null) {
            sb = KDTLayoutInfo.createScrollBar(sb.getClass(), 1);
        }
        KDTVertical vertical = new KDTVertical(this.table, sb);
        return vertical;
    }

    @Override
    public int getFirstInAll() {
        if (this.firstInAll == -1) {
            return 0;
        }
        return super.getFirstInAll();
    }

    @Override
    public int getLastInAll() {
        if (this.lastInAll == -1) {
            return this.table.getRowCount3() - 1;
        }
        return super.getLastInAll();
    }

    public IRows getRows() {
        return this.rows;
    }

    public void setRows(IRows rows) {
        this.rows = rows;
    }
}

