/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.AbstractRelations;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.bos.ctrl.kdf.table.KDTCellSelectAction;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTGroupManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTScriptManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.MultiPrint;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.IRenderRect;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KDTableHelper {
    public static final int HORIZON = 0;
    public static final int VERTICAL = 1;
    public static final int ORIGIN = 2;

    public static void regroupTable(KDTable table) {
        KDTGroupManager gm = table.getGroupManager();
        if (!gm.isGroup()) {
            return;
        }
        gm.fillIndexs();
        KDTMergeManager mm = table.getMergeManager();
        List mergeBlockList = mm.getMergeBlockList();
        if (mergeBlockList != null) {
            for (KDTMergeBlock mb : mergeBlockList) {
                int top = mb.getTop();
                int bottom = mb.getBottom();
                int left = mb.getLeft();
                int right = mb.getRight();
                for (int i = top; i <= bottom; ++i) {
                    for (int j = left; j <= right; ++j) {
                        table.getCell(i, j).getKDTCell().setMergeBlock(null);
                    }
                }
            }
        }
        mm.removeAllMergeBlock();
        gm.removeGroup();
        int mode = table.getDataRequestManager().getDataRequestMode();
        if (mode == 0) {
            gm.group();
        } else if (mode == 1) {
            int pageRowCount = table.getDataRequestManager().getPageRowCount();
            int actualRowCount = table.getRowCount3();
            int page = actualRowCount / pageRowCount + 1;
            for (int i = 0; i < page; ++i) {
                int baseRow = i * pageRowCount;
                if (table.getRow2(baseRow) == null) continue;
                if (i == page - 1) {
                    table.getGroupManager().group(baseRow, actualRowCount - 1);
                    continue;
                }
                table.getGroupManager().group(baseRow, baseRow + pageRowCount - 1);
            }
        }
    }

    public static void initTable(KDTable table, String[] columnKeys, Object[][] head, Object[][] body) {
        int j;
        int cellCount;
        Object[] cells;
        IRow row;
        int i;
        boolean refresh = table.isRefresh();
        table.setRefresh(false);
        int colCount = columnKeys == null ? 0 : columnKeys.length;
        int headRowCount = head == null ? 0 : head.length;
        int rowCount = body == null ? 0 : body.length;
        for (i = 0; i < colCount; ++i) {
            IColumn col = table.addColumn();
            col.setKey(columnKeys[i]);
        }
        colCount = table.getColumnCount();
        for (i = 0; i < headRowCount; ++i) {
            row = table.addHeadRow();
            cells = head[i];
            cellCount = cells.length < colCount ? cells.length : colCount;
            for (j = 0; j < cellCount; ++j) {
                row.getCell(j).setValue(cells[j]);
            }
        }
        for (i = 0; i < rowCount; ++i) {
            row = table.addRow();
            cells = body[i];
            cellCount = cells.length < colCount ? cells.length : colCount;
            for (j = 0; j < cellCount; ++j) {
                row.getCell(j).setValue(cells[j]);
            }
        }
        table.setRefresh(refresh);
        table.repaint();
    }

    public static void initTable(KDTable table, String[] columnKeys, Object[] head, Object[][] body) {
        Object[][] temp = null;
        if (head != null) {
            temp = new Object[][]{head};
        }
        KDTableHelper.initTable(table, columnKeys, temp, body);
    }

    public static void addRows(KDTable table, Collection c) {
        boolean refresh = table.isRefresh();
        table.setRefresh(false);
        int colCount = table.getColumnCount();
        if (colCount <= 0) {
            return;
        }
        Iterator iterator = c.iterator();
        int i = 0;
        IRow row = null;
        while (iterator.hasNext()) {
            int j = i % colCount;
            if (j == 0) {
                row = table.addRow();
            }
            row.getCell(j).setValue(iterator.next());
            ++i;
        }
        table.setRefresh(refresh);
        table.repaint();
    }

    public static void addRows(KDTable table, Collection[] cs) {
        boolean refresh = table.isRefresh();
        table.setRefresh(false);
        int colCount = table.getColumnCount();
        int rowCount = cs.length;
        if (colCount <= 0 && rowCount <= 0) {
            return;
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Iterator iterator = cs[rowIndex].iterator();
            IRow row = null;
            for (int i = 0; iterator.hasNext() && i < colCount; ++i) {
                if (i == 0) {
                    row = table.addRow();
                }
                row.getCell(i).setValue(iterator.next());
            }
        }
        table.setRefresh(refresh);
        table.repaint();
    }

    public static BufferedImage getKDTableImage(String formatXml, int width, int height) {
        KDTable table = new KDTable();
        table.setBounds(0, 0, width, height);
        table.setFormatXml(formatXml);
        table.checkParsed();
        for (int i = 0; i < 5; ++i) {
            table.addRow(i);
        }
        return KDTableHelper.getKDTableImage(table);
    }

    public static BufferedImage getKDTableImage(KDTable table) {
        Rectangle rect = table.getBounds();
        BufferedImage bufferImage = null;
        Graphics2D bufferGraphics = null;
        bufferImage = new BufferedImage(rect.width, rect.height, 2);
        bufferGraphics = (Graphics2D)bufferImage.getGraphics();
        table.doLayout();
        table.paint(bufferGraphics);
        for (int i = table.getComponentCount() - 1; i >= 0; --i) {
            Component comp = table.getComponent(i);
            if (comp == null || JComponent.isLightweightComponent(comp) || !comp.isVisible()) continue;
            Rectangle cr = comp.getBounds();
            Graphics cg = bufferGraphics.create(cr.x, cr.y, cr.width, cr.height);
            comp.paint(cg);
        }
        return bufferImage;
    }

    public static void releaseEnter(JComponent comp) {
        InputMap inputMap = comp.getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(10, 0));
        inputMap.remove(KeyStroke.getKeyStroke(10, 64));
        HashSet<KeyStroke> managingFocusForwardTraversalKeys = new HashSet<KeyStroke>();
        managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 0));
        managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        HashSet<KeyStroke> managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>();
        managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 1));
        comp.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        comp.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    public static void releaseTab(JComponent comp) {
        InputMap inputMap = comp.getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(9, 0));
        inputMap.remove(KeyStroke.getKeyStroke(9, 64));
        HashSet<KeyStroke> managingFocusForwardTraversalKeys = new HashSet<KeyStroke>();
        managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
        managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        HashSet<KeyStroke> managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>();
        managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 3));
        comp.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        comp.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    public static void takeOverTab(JComponent comp) {
        InputMap inputMap = comp.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "FocusChangeRow");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "FocusChangeRowReverse");
        comp.setFocusTraversalKeys(0, new HashSet());
        comp.setFocusTraversalKeys(1, new HashSet());
    }

    public static void releaseEnterAndTab(JComponent comp) {
        InputMap inputMap = comp.getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(10, 0));
        inputMap.remove(KeyStroke.getKeyStroke(9, 0));
        inputMap.remove(KeyStroke.getKeyStroke(10, 64));
        inputMap.remove(KeyStroke.getKeyStroke(9, 64));
        comp.setFocusTraversalKeys(0, null);
        comp.setFocusTraversalKeys(1, null);
    }

    public static void updateEnterWithTab(KDTable table, boolean isAddRow) {
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeCol", new KDTFocusChangeAction(table, 0, false, isAddRow));
        actionMap.put("FocusChangeColReverse", new KDTFocusChangeAction(table, 0, true, true));
        actionMap.put("FocusChangeRow", new KDTFocusChangeAction(table, 0, false, isAddRow));
        actionMap.put("FocusChangeRowReverse", new KDTFocusChangeAction(table, 0, true, true));
    }

    public static void updateEnterWithTab(KDTable table, boolean isAddRow, Action actionAfterAddRow) {
        KDTableHelper.updateEnterWithTab(table, isAddRow, actionAfterAddRow, true);
    }

    public static void updateEnterWithTab(KDTable table, boolean isAddRow, Action actionAfterAddRow, boolean isFocusThenEdit) {
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeCol", new KDTFocusChangeAction(table, 0, false, isAddRow, actionAfterAddRow, isFocusThenEdit));
        actionMap.put("FocusChangeColReverse", new KDTFocusChangeAction(table, 0, true, true, null, isFocusThenEdit));
        actionMap.put("FocusChangeRow", new KDTFocusChangeAction(table, 0, false, isAddRow, actionAfterAddRow, isFocusThenEdit));
        actionMap.put("FocusChangeRowReverse", new KDTFocusChangeAction(table, 0, true, true, null, isFocusThenEdit));
    }

    public static void downArrowAutoAddRow(KDTable table, boolean isAddRow, Action actionAfterAddRow) {
        Action action = table.getActionMap().get("SelectDownCell");
        if (action instanceof KDTCellSelectAction) {
            ((KDTCellSelectAction)action).setAddRow(isAddRow);
            ((KDTCellSelectAction)action).setActionAfterAddRow(actionAfterAddRow);
        }
    }

    public static void releaseEsc(JComponent comp) {
        InputMap inputMap = comp.getInputMap(1);
        inputMap.remove(KeyStroke.getKeyStroke(27, 0));
    }

    public static void setEnterKeyJumpOrientation(KDTable table, int orientation) {
        KDTableHelper.setEnterKeyJumpOrientation(table, orientation, true);
    }

    public static void setEnterKeyJumpOrientation(KDTable table, int orientation, boolean isFocusThenEdit) {
        ActionMap actionMap = table.getActionMap();
        if (orientation == 0) {
            actionMap.put("FocusChangeCol", new KDTFocusChangeAction(table, 0, false, false, null, isFocusThenEdit));
            actionMap.put("FocusChangeColReverse", new KDTFocusChangeAction(table, 0, true, false, null, isFocusThenEdit));
        } else if (orientation == 1) {
            actionMap.put("FocusChangeCol", new KDTFocusChangeAction(table, 1, false, false, null, isFocusThenEdit));
            actionMap.put("FocusChangeColReverse", new KDTFocusChangeAction(table, 1, true, false, null, isFocusThenEdit));
        } else if (orientation == 2) {
            actionMap.remove("FocusChangeCol");
            actionMap.remove("FocusChangeColReverse");
        } else {
            throw new IllegalArgumentException("Illegal Argument");
        }
    }

    public static void setTabKeyJumpOrientation(KDTable table, int orientation) {
        ActionMap actionMap = table.getActionMap();
        if (orientation == 0) {
            actionMap.put("FocusChangeRow", new KDTFocusChangeAction(table, 0, false));
            actionMap.put("FocusChangeRowReverse", new KDTFocusChangeAction(table, 0, true));
        } else if (orientation == 1) {
            actionMap.put("FocusChangeRow", new KDTFocusChangeAction(table, 1, false));
            actionMap.put("FocusChangeRowReverse", new KDTFocusChangeAction(table, 1, true));
        } else if (orientation == 2) {
            actionMap.remove("FocusChangeRow");
            actionMap.remove("FocusChangeRowReverse");
        } else {
            throw new IllegalArgumentException("Illegal Argument");
        }
    }

    public static void mergeTableRelations(TableRelations trs, Collection tables) {
        for (KDTable table : tables) {
            KDTScriptManager sm = table.getScriptManager();
            TableRelations temp = sm.relations;
            if (temp == null) continue;
            trs.appendRelations((AbstractRelations)temp);
        }
    }

    public static void drawByRender(IBasicRender render, Graphics g, Shape clip, Object value, Style style, Object extObject) {
        if (render == null) {
            return;
        }
        if (render instanceof IExtBasicRender) {
            ((IExtBasicRender)render).draw(g, clip, value, style, extObject);
        } else {
            render.draw(g, clip, value, style);
        }
    }

    public static int getVirtualRowCount(KDTable table) {
        int rowCount = table.getRowCount();
        if (rowCount == -1) {
            rowCount = table.getRowCount3();
            IRow row = null;
            do {
                row = table.getRow(rowCount);
                int newCount = table.getRowCount3();
                if (newCount <= rowCount) break;
                rowCount = newCount;
            } while (row != null);
        }
        return rowCount;
    }

    public static Point cellAtPosition(KDTable table, int x, int y) {
        KDTView view = (KDTView)table.getViewManager().getView(5);
        Point p = SwingUtilities.convertPoint(table, x, y, view);
        KDTCellPosition pos = view.getCellPosition(p.x, p.y);
        return new Point(pos.colIndex, pos.rowIndex);
    }

    public static void setColumnLocked(KDTable table, int colIndex, boolean isLock) {
        if (table.getColumn(colIndex) != null) {
            StyleAttributes style = table.getColumn(colIndex).getStyleAttributes();
            style.setOwner(null);
            style.setLocked(!isLock);
            style.setLocked(isLock);
            table.setColumnStyle(colIndex, style, false);
        }
    }

    public static void setRowLocked(KDTable table, int rowIndex, boolean isLock) {
        IRow row = table.getRow(rowIndex);
        if (row != null) {
            StyleAttributes style = row.getStyleAttributes();
            style.setOwner(null);
            style.setLocked(!isLock);
            style.setLocked(isLock);
            table.setRowStyle(rowIndex, style, false);
        }
    }

    public static void setAllRowHeight(KDTable table, int h) {
        table.setDefaultRowHeight(h);
        KDTBody body = table.getBody();
        int rowCount = body.size();
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = body.getRow2(i);
            if (row == null) continue;
            row.setHeight(-1);
        }
    }

    public static Object getCellDisplayValue(KDTable table, int rIndex, int cIndex) {
        IBasicRender render;
        ICell cell = table.getCell(rIndex, cIndex);
        if (cell == null) {
            return null;
        }
        Object value = cell.getValue();
        String fmt = cell.getStyle().getNumberFormat();
        boolean noFmt = StringUtil.isEmptyString((String)fmt);
        if (table.getUserCellDisplayParser() != null) {
            int rowIndex = cell.getRowIndex();
            int colIndex = cell.getColumnIndex();
            value = table.getUserCellDisplayParser().parse(rowIndex, colIndex, cell, value);
        }
        if ((render = table.getCellRenderer(rIndex, cIndex)) instanceof ObjectValueRender) {
            value = ((ObjectValueRender)render).getText(value);
        } else if (noFmt && render instanceof CellTextRender) {
            value = ((CellTextRender)render).getText(value);
        }
        return value;
    }

    public static Object getCellDisplayValue2(KDTable table, int rIndex, int cIndex) {
        IBasicRender render;
        ICell cell = table.getCell(rIndex, cIndex);
        if (cell == null) {
            return null;
        }
        Object value = cell.getValue();
        if (table.getUserCellDisplayParser() != null) {
            int rowIndex = cell.getRowIndex();
            int colIndex = cell.getColumnIndex();
            value = table.getUserCellDisplayParser().parse(rowIndex, colIndex, cell, value);
        }
        if ((render = table.getCellRenderer(rIndex, cIndex)) instanceof ObjectValueRender) {
            value = ((ObjectValueRender)render).getText(value);
        }
        return value;
    }

    public static int getMaxColumnWidth(KDTable table, int colIndex, boolean ishead) {
        Graphics2D g2d = KDTable.getBufferGraphics();
        FontRenderContext context = null;
        if (g2d != null) {
            context = g2d.getFontRenderContext();
        }
        IRows rows = ishead ? table.getHead() : table.getBody();
        int rowCount = rows.size();
        int maxWidth = -1;
        for (int i = 0; i < rowCount; ++i) {
            IBasicRender render;
            KDTMergeBlock block;
            KDTCell cell;
            KDTRow row = rows.getRow(i);
            if (row == null || (cell = row.getCell(colIndex)) == null || (block = cell.getMergeBlock()) != null && block.getLeft() != block.getRight()) continue;
            String text = null;
            if (ishead) {
                Object value = cell.getValue();
                if (value != null) {
                    text = value.toString();
                }
            } else {
                text = table.getCellDisplayText(cell, i, colIndex);
            }
            if (StringUtil.isEmptyString((String)text)) continue;
            int width = 0;
            Style style = cell.getStyle();
            IBasicRender iBasicRender = render = ishead ? table.getHeadCellRenderer(i, colIndex) : table.getCellRenderer(i, colIndex);
            if (render instanceof IRenderRect) {
                width = (int)((IRenderRect)render).getPreferredWidth((Graphics)g2d, null, text, style, cell.getValue());
                if (width != 0) {
                    width += 6;
                }
            } else {
                KDFont font = style.getKDFont();
                Rectangle2D fontRect = font.getStringBounds(text, context);
                width = (int)fontRect.getWidth() + 6;
            }
            if (width == 0 || width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public static boolean autoFitColumnWidth(KDTable table, int colIndex) {
        return KDTableHelper.autoFitColumnWidth(table, colIndex, table.getColumns().getColumn(colIndex).getAutoFitWithExtend());
    }

    public static boolean autoFitColumnWidth(KDTable table, int colIndex, int extend) {
        int bodyMaxWidth;
        KDTColumn col = table.getColumns().getColumn(colIndex);
        if (col == null || !col.isResizeable() || col.getStyle().isHided()) {
            return false;
        }
        int maxWidth = -1;
        int headMaxWidth = KDTableHelper.getMaxColumnWidth(table, colIndex, true);
        if (headMaxWidth > maxWidth) {
            maxWidth = headMaxWidth;
        }
        if ((bodyMaxWidth = KDTableHelper.getMaxColumnWidth(table, colIndex, false)) > maxWidth) {
            maxWidth = bodyMaxWidth;
        }
        if (maxWidth != -1 && maxWidth != col.getWidth()) {
            col.setWidth(maxWidth + extend + 3);
            table.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public static boolean autoFitRowHeight(KDTable table, int rowIndex) {
        return KDTableHelper.autoFitRowHeight(table, rowIndex, 0);
    }

    public static boolean autoFitRowHeight(KDTable table, int rowIndex, int extend) {
        return KDTableHelper.autoFitRowHeight(table, rowIndex, extend, false);
    }

    public static boolean autoFitHeadRowHeight(KDTable table, int rowIndex) {
        return KDTableHelper.autoFitHeadRowHeight(table, rowIndex, 0);
    }

    public static boolean autoFitHeadRowHeight(KDTable table, int rowIndex, int extend) {
        return KDTableHelper.autoFitRowHeight(table, rowIndex, extend, true);
    }

    public static boolean autoFitRowHeight(KDTable table, int rowIndex, int extend, boolean isHead) {
        IRows rows = null;
        rows = isHead ? table.getHead() : table.getBody();
        KDTColumns cols = table.getColumns();
        KDTRow row = rows.getRow(rowIndex);
        if (row == null || !row.isResizeable() || row.getStyle().isHided()) {
            return false;
        }
        int maxHeight = 0;
        int rowHeight = rows.getRowHeight(rowIndex);
        int defaultHeight = isHead ? table.getDefaultHeadRowHeight() : table.getDefaultRowHeight();
        int colCount = table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            IBasicRender render;
            Object obj;
            KDTCell cell = row.getCell(i);
            if (cell == null) continue;
            Object object = obj = isHead ? cell.getValue() : table.getCellDisplayText(cell, rowIndex, i);
            if (obj == null) continue;
            IBasicRender iBasicRender = render = isHead ? table.getHeadCellRenderer(rowIndex, i) : table.getCellRenderer(rowIndex, i);
            if (!(render instanceof CellTextRender)) continue;
            CellTextRender textRender = (CellTextRender)render;
            Rectangle rect = new Rectangle(0, 0, cols.getColumnWidth(i) - 6, rowHeight);
            int h = (int)textRender.getPreferredHeight(table.getGraphics(), (Shape)rect, obj.toString(), cell.getStyle(), cell.getValue());
            h = h < defaultHeight ? defaultHeight : (h += extend);
            if (h <= maxHeight) continue;
            maxHeight = h;
        }
        if (maxHeight != 0 && maxHeight != rowHeight) {
            row.setHeight(maxHeight);
            table.reLayoutAndPaint();
            return true;
        }
        return false;
    }

    public static MultiPrint createMultiPrintForRowByHead(KDTable table) {
        return KDTableHelper.createMultiPrintForRowByHead(table, -1);
    }

    public static MultiPrint createMultiPrintForRowByHead(KDTable table, int wrapRowSpan) {
        if (table.getPrintManager().getPlugablePaginationAdvice() == null) {
            table.getPrintManager().setPlugablePaginationAdvice(new PlugablePaginationAdvice(){

                public int[] getColExtendedBreaks() {
                    return null;
                }

                public int[] getColShrinkedBreaks() {
                    return null;
                }

                public int[] getRowExtendedBreaks() {
                    return null;
                }

                public int[] getRowShrinkedBreaks() {
                    return null;
                }

                public boolean isColExtendedBreak(int colIndex) {
                    return false;
                }

                public boolean isColShrinkedBreak(int colIndex) {
                    return false;
                }

                public boolean isRowExtendedBreak(int rowIndex) {
                    return false;
                }

                public boolean isRowShrinkedBreak(int rowIndex) {
                    return true;
                }
            });
        }
        MultiPrint mp = new MultiPrint(table);
        mp.setFrugalPrint(true);
        mp.setBlockSpace(wrapRowSpan);
        mp.getMultiPrintModel().setTable(table);
        mp.getMultiPrintModel().addPrintJob("a1", null);
        return mp;
    }

    public static BigDecimal getSelectedSumInColumn(KDTable table, int col) {
        if (table == null) {
            return null;
        }
        int size = table.getSelectManager().size();
        BigDecimal result = new BigDecimal(0.0);
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int r1 = 0;
            int r2 = 0;
            int mode = sb.getMode();
            if (mode == 8 || mode == 4) {
                r2 = table.getRowCount() - 1;
            } else {
                r1 = sb.getBeginRow();
                r2 = sb.getEndRow();
            }
            for (int r = r1; r <= r2; ++r) {
                Object value;
                if (!sb.contains(col, r)) continue;
                ICell cell = table.getCell(r, col);
                Object object = value = cell == null ? null : cell.getValue();
                if (value == null || !(value instanceof Number)) continue;
                result = value instanceof BigDecimal ? result.add((BigDecimal)value) : result.add(new BigDecimal(((Number)value).doubleValue()));
            }
        }
        return result;
    }

    public static BigDecimal[] getSelectedSumInColumns(KDTable table, int[] cols) {
        int colSize = cols.length;
        if (table == null || cols == null || colSize == 0) {
            return null;
        }
        BigDecimal[] result = new BigDecimal[colSize];
        for (int i = 0; i < colSize; ++i) {
            result[i] = KDTableHelper.getSelectedSumInColumn(table, cols[i]);
        }
        return result;
    }

    public static int getSelectedCountInColumn(KDTable table, int col) {
        if (table == null) {
            return 0;
        }
        int size = table.getSelectManager().size();
        int result = 0;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int r1 = 0;
            int r2 = 0;
            int mode = sb.getMode();
            if (mode == 8 || mode == 4) {
                r2 = table.getRowCount() - 1;
            } else {
                r1 = sb.getBeginRow();
                r2 = sb.getEndRow();
            }
            for (int r = r1; r <= r2; ++r) {
                if (!sb.contains(col, r)) continue;
                ++result;
            }
        }
        return result;
    }

    public static int[] getSelectedCountInColumns(KDTable table, int[] cols) {
        int colSize = cols.length;
        if (table == null || cols == null || colSize == 0) {
            return null;
        }
        int[] result = new int[colSize];
        for (int i = 0; i < colSize; ++i) {
            result[i] = KDTableHelper.getSelectedCountInColumn(table, cols[i]);
        }
        return result;
    }
}

