/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.attribute;

import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.PrintRequestAttribute;

public final class OffsetXY
implements PrintRequestAttribute,
DocAttribute {
    private static final long serialVersionUID = -1588183095298900431L;
    private float direcOffsetX;
    private float direcOffsetY;
    private float sideOffsetX;
    private float sideOffsetY;
    private int direcPtsX;
    private int direcPtsY;
    private int sidePtsX;
    private int sidePtsY;
    public static final int INCH = 25400;
    public static final int MM = 1000;
    public static final OffsetXY DEFAULT = new OffsetXY();

    public void setDirecOffXY(float offX, float offY, int units) {
        if (units != 25400 && units != 1000) {
            throw new IllegalArgumentException("units must be OffsetXY.INCH or OffsetXY.MM");
        }
        this.direcOffsetX = offX * (float)units;
        this.direcOffsetY = offY * (float)units;
        this.direcPtsX = (int)this.getDirecOffsetX(25400) * KDPrinterUtils.getPtsPerInch();
        this.direcPtsY = (int)this.getDirecOffsetY(25400) * KDPrinterUtils.getPtsPerInch();
    }

    public void setSideOffXY(float offX, float offY, int units) {
        if (units != 25400 && units != 1000) {
            throw new IllegalArgumentException("units must be OffsetXY.INCH or OffsetXY.MM");
        }
        this.sideOffsetX = offX * (float)units;
        this.sideOffsetY = offY * (float)units;
        this.sidePtsX = (int)this.getSideOffsetX(25400) * KDPrinterUtils.getPtsPerInch();
        this.sidePtsY = (int)this.getSideOffsetY(25400) * KDPrinterUtils.getPtsPerInch();
    }

    public int getPtsOfSideX() {
        return this.sidePtsX;
    }

    public int getPtsOfSideY() {
        return this.sidePtsY;
    }

    public int getPtsOfDirecX() {
        return this.direcPtsX;
    }

    public int getPtsOfDirecY() {
        return this.direcPtsY;
    }

    public Class getCategory() {
        return OffsetXY.class;
    }

    @Override
    public String getName() {
        return "OffsetXY";
    }

    public float getDirecOffsetX(int units) {
        return OffsetXY.convertFromMicrometers(this.direcOffsetX, units);
    }

    public float getDirecOffsetY(int units) {
        return OffsetXY.convertFromMicrometers(this.direcOffsetY, units);
    }

    public float getSideOffsetX(int units) {
        return OffsetXY.convertFromMicrometers(this.sideOffsetX, units);
    }

    public float getSideOffsetY(int units) {
        return OffsetXY.convertFromMicrometers(this.sideOffsetY, units);
    }

    private static float convertFromMicrometers(float x, int units) {
        if (units != 25400 && units != 1000) {
            throw new IllegalArgumentException("units must be OffsetXY.INCH or OffsetXY.MM");
        }
        return x / (float)units;
    }

    public int hashCode() {
        return (int)(this.sideOffsetX + 37.0f * this.sideOffsetY + this.direcOffsetX * 12.0f + this.direcOffsetY * 24.0f);
    }

    private float[] getDirecOffsetXY(int units) {
        return new float[]{this.getDirecOffsetX(units), this.getDirecOffsetY(units)};
    }

    private float[] getSideOffsetXY(int units) {
        return new float[]{this.getSideOffsetX(units), this.getSideOffsetY(units)};
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            unitsName = "";
        }
        float[] direcVals = this.getDirecOffsetXY(units);
        float[] sideVals = this.getSideOffsetXY(units);
        StringBuffer sb = new StringBuffer();
        sb.append("Direc offset(X,Y)=(").append(direcVals[0]).append(",").append(direcVals[1]).append(")").append(unitsName);
        sb.append("\nSide offset(X,Y)=(").append(sideVals[0]).append(",").append(sideVals[1]).append(")").append(unitsName);
        return sb.toString();
    }

    public String toString() {
        return this.toString(1000, "mm");
    }

    public boolean equals(Object object) {
        boolean ret = false;
        if (object != null && object instanceof OffsetXY) {
            OffsetXY mm = (OffsetXY)object;
            if (this.direcOffsetX == mm.direcOffsetX && this.direcOffsetY == mm.direcOffsetY && this.sideOffsetX == mm.sideOffsetX && this.sideOffsetY == mm.sideOffsetY) {
                ret = true;
            }
        }
        return ret;
    }
}

