/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeInfo;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.config.ui.AbstractConfigUI;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.PrintGeneralUI;
import com.kingdee.bos.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import sun.print.SunAlternateMedia;

public class PageSetuplUI
extends AbstractConfigUI {
    private static final long serialVersionUID = -382082128900641019L;
    protected SunPrintConfigDialog printConfigDialog;
    private PrintService service;

    @Override
    public void init(PrintJobConfig manager, String uniqueName) {
        super.init(manager, uniqueName);
        this.service = manager.getPrintService();
        this.initPrintConfigDialog();
        KDTabbedPane tabbedPane = this.printConfigDialog.getTabbedPane();
        this.add((Component)tabbedPane);
    }

    @Override
    public void onShow() {
        PrintGeneralUI panel = (PrintGeneralUI)this.panelCache.get(Resources.getMsg("tree.print"));
        if (panel != null) {
            this.service = panel.getPrintService();
            this.printConfigDialog.setPrintService(this.service);
        }
    }

    protected void initPrintConfigDialog() {
        PageSetupModel theconfig = (PageSetupModel)this.config;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        this.printConfigDialog = new SunPrintConfigDialog(null, 0, 0, this.service, flavor, theconfig, this.manager);
    }

    @Override
    public IConfigModel createConfigModel() {
        return new PageSetupModel();
    }

    @Override
    public void updateConfigToUI() {
    }

    @Override
    public void approve() {
        PageSetupModel theconfig = (PageSetupModel)this.config;
        PrintRequestAttributeSet attributes = theconfig.getPrintRequestAttributeSet();
        PrintRequestAttributeSet newas = this.printConfigDialog.getAttributes();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        Class<Destination> dstCategory = Destination.class;
        Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
        Class<Fidelity> fdCategory = Fidelity.class;
        Class<PageRanges> pageRangeCategory = PageRanges.class;
        for (Class category : new Class[]{dstCategory, amCategory, pageRangeCategory, PageRangeInfo.class}) {
            if (!attributes.containsKey(category) || newas.containsKey(category)) continue;
            attributes.remove(category);
        }
        if (this.isNeedRepaging(newas, attributes)) {
            this.manager.setChange(true);
        }
        if (theconfig.isFrugalPrint() != this.printConfigDialog.isFrugalPrint()) {
            theconfig.setFrugalPrint(this.printConfigDialog.isFrugalPrint());
            this.manager.setChange(true);
        }
        if (theconfig.getBackGroundColor() != this.printConfigDialog.getBackGroundColor()) {
            theconfig.setBackGroundColor(this.printConfigDialog.getBackGroundColor());
            this.manager.setChange(true);
        }
        MixVariantLabelCell waterMark = theconfig.getWaterMark();
        String text1 = waterMark.getText();
        Style s1 = waterMark.getStyle();
        MixVariantLabelCell waterMark2 = this.printConfigDialog.getWaterMark();
        String text2 = waterMark2.getText();
        Style s2 = waterMark2.getStyle();
        if (!(text1 == null && text2 == null || text1 != null && text2 != null && text1.equals(text2) && s1.equals((Object)s2))) {
            theconfig.setWaterMark(waterMark2);
            this.manager.setChange(true);
        }
        if (theconfig.isWaterMark_onlyFirstPage() != this.printConfigDialog.isWaterMarkOnlyFirstPage()) {
            theconfig.setWaterMark_onlyFirstPage(this.printConfigDialog.isWaterMarkOnlyFirstPage());
            this.manager.setChange(true);
        }
        if (!this.isEqualsTwoObj(theconfig.getBackGround(), this.printConfigDialog.getBackGroundImage())) {
            theconfig.setBackGround(this.printConfigDialog.getBackGroundImage());
            theconfig.setBackGroundUrl(this.printConfigDialog.getBackGroundUrl());
            this.manager.setChange(true);
        }
        if (theconfig.getBackGroundFillMode() != this.printConfigDialog.getBackGroundImageFillMode()) {
            theconfig.setBackGroundFillMode(this.printConfigDialog.getBackGroundImageFillMode());
            this.manager.setChange(true);
        }
        if (this.printConfigDialog.isMediaSizeChange()) {
            this.manager.setChange(true);
        }
        if (theconfig.getFooterAlign() != this.printConfigDialog.getFooterAlign()) {
            theconfig.setFooterAlign(this.printConfigDialog.getFooterAlign());
            this.manager.setChange(true);
        }
        if (theconfig.getHeaderAlign() != this.printConfigDialog.getHeaderAlign()) {
            theconfig.setHeaderAlign(this.printConfigDialog.getHeaderAlign());
            this.manager.setChange(true);
        }
        if (theconfig.getCenterAlign() != this.printConfigDialog.getCenterAlign()) {
            theconfig.setCenterAlign(this.printConfigDialog.getCenterAlign());
            this.manager.setChange(true);
        }
        attributes.addAll(newas);
        Fidelity fd = (Fidelity)attributes.get(fdCategory);
        if (fd != null && fd == Fidelity.FIDELITY_TRUE) {
            PageSetuplUI.removeUnsupportedAttributes(this.service, flavor, attributes);
        }
    }

    private boolean isEqualsTwoObj(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 == o2;
    }

    private boolean isNeedRepaging(PrintRequestAttributeSet newas, PrintRequestAttributeSet attributes) {
        Class[] checkCategory = new Class[]{Media.class, OrientationRequested.class, ZoomScaleInfo.class, PageIntervalInfo.class, HeadFootIntervalInfo.class};
        for (int i = 0; i < checkCategory.length; ++i) {
            boolean isNew;
            Attribute a = newas.get(checkCategory[i]);
            if (a == null || !(isNew = attributes.add(a))) continue;
            return true;
        }
        return false;
    }

    private static void removeUnsupportedAttributes(PrintService ps, DocFlavor flavor, AttributeSet aset) {
        AttributeSet asUnsupported = ps.getUnsupportedAttributes(flavor, aset);
        if (asUnsupported != null) {
            Attribute[] usAttrs = asUnsupported.toArray();
            for (int i = 0; i < usAttrs.length; ++i) {
                Class<? extends Attribute> category = usAttrs[i].getCategory();
                if (ps.isAttributeCategorySupported(category)) {
                    Attribute attr = (Attribute)ps.getDefaultAttributeValue(category);
                    if (attr != null) {
                        aset.add(attr);
                        continue;
                    }
                    aset.remove(category);
                    continue;
                }
                aset.remove(category);
            }
        }
    }
}

