/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.print.PropertyConfig;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.ui.AbstractConfigModel;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PaperAdjustModel
extends AbstractConfigModel {
    Map adjustContent = new HashMap();
    public static String REPLACER = "!!";

    public PaperAdjustModel() {
        String config = PropertyConfig.getPaper_Adjust();
        this.load(config);
    }

    private void load(String config) {
        this.adjustContent.clear();
        if (config != null && !config.equals("")) {
            StringTokenizer st = new StringTokenizer(config, ":");
            while (st.hasMoreTokens()) {
                String oneConfig = st.nextToken();
                StringTokenizer stOne = new StringTokenizer(oneConfig, ",");
                String key = stOne.nextToken();
                float x = Float.parseFloat(stOne.nextToken());
                float y = Float.parseFloat(stOne.nextToken());
                float z = stOne.hasMoreTokens() ? Float.parseFloat(stOne.nextToken()) : 0.0f;
                key = key.replaceAll(REPLACER, ":");
                this.adjustContent.put(key, new float[]{x, y, z});
            }
        }
    }

    public void save() {
        PropertyConfig.setPaper_Adjust(this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String printer : this.adjustContent.keySet()) {
            float[] values = (float[])this.adjustContent.get(printer);
            float x = values[0];
            float y = values[1];
            float z = values[2];
            if (y == 0.0f && z == 0.0f) continue;
            printer = printer.replaceAll(":", REPLACER);
            sb.append(printer).append(",").append(x).append(",").append(y).append(",").append(z);
            sb.append(":");
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return null;
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void set(IConfigModel from) {
    }

    public float[] getAdjustValues(String item) {
        Object value = this.adjustContent.get(item);
        if (value == null) {
            value = new float[]{1.0f, 0.0f, 0.0f};
        }
        return (float[])value;
    }

    public boolean isEnableAdjust(String item) {
        float[] values = (float[])this.adjustContent.get(item);
        if (values == null) {
            return false;
        }
        return values[2] == 1.0f;
    }

    public Map getAdjustContent() {
        return this.adjustContent;
    }

    public void setAdjustContent(Map content) {
        this.adjustContent = content;
    }
}

